/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.test;

import es.capgemini.generalitat.common.properties.PropertyUtil;
import es.capgemini.generalitat.common.test.DatabaseUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.sql.DataSource;
import junit.framework.TestCase;
import net.gencat.ctti.canigo.services.logging.Log;
import net.gencat.ctti.canigo.services.logging.log4j.Log4JServiceImpl;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;

public abstract class BaseCommonAbstractTest
extends TestCase {
    private static ApplicationContext context;
    private static String sContext;
    private static Log4JServiceImpl loggingService;

    protected void setUp() {
        if (context == null) {
            context = new ClassPathXmlApplicationContext(this.getConfigLocations());
        }
        this.initDependencies();
    }

    private void initDependencies() {
        Field[] fields = ((Object)((Object)this)).getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            String fieldName = field.getName();
            try {
                Object bean = context.getBean(fieldName);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                field.set((Object)this, bean);
                field.setAccessible(false);
                continue;
            }
            catch (Exception e) {
                this.getLogger().error((Object)("No se pudo inicializar el campo: " + fieldName), (Throwable)e);
            }
        }
    }

    protected String[] getConfigLocations() {
        return new String[]{sContext};
    }

    protected void executeScript(DataSource dataSource, String script) {
        DatabaseUtils.executeScript(dataSource, (Resource)this.getBean(script), null, true);
    }

    protected void executeScripts(DataSource dataSource, String[] scripts) {
        for (String script : scripts) {
            DatabaseUtils.executeScript(dataSource, (Resource)this.getBean(script), null, true);
        }
    }

    protected static boolean inicializarBaseDatos() {
        return PropertyUtil.getPropertyAsBoolean("inicializarBBDD");
    }

    protected Object getBean(String beanId) {
        return context.getBean(beanId);
    }

    protected Log4JServiceImpl getLoggingService() {
        if (loggingService == null) {
            loggingService = (Log4JServiceImpl)this.getBean("loggingService");
        }
        return loggingService;
    }

    protected Log getLogger() {
        return this.getLoggingService().getLog(((Object)((Object)this)).getClass());
    }

    static {
        sContext = "base-common-test-context.xml";
    }
}

