/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.test;

import es.capgemini.generalitat.common.test.PropertyPlaceholderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseUtils {
    protected static final Log LOGGER = LogFactory.getLog(DatabaseUtils.class);

    private DatabaseUtils() {
    }

    public static void executeScript(DataSource dataSource, Resource scriptResource, Map<String, ?> params, boolean ignoreExceptions) {
        if (scriptResource == null || !scriptResource.exists()) {
            return;
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Executing script:" + scriptResource));
            }
            DatabaseUtils.executeScript(dataSource, scriptResource.getInputStream(), params, ignoreExceptions);
        }
        catch (IOException e) {
            throw new BeanInitializationException("Cannot load script from [" + scriptResource + "]", (Throwable)e);
        }
    }

    public static void executeScript(DataSource dataSource, InputStream inputStream, Map<String, ?> params, boolean ignoreExceptions) throws IOException {
        List script = IOUtils.readLines((InputStream)inputStream);
        inputStream.close();
        DatabaseUtils.executeScript(dataSource, script, params, ignoreExceptions);
    }

    public static void executeScript(final DataSource dataSource, final List<String> script, final Map<String, ?> params, final boolean ignoreExceptions) {
        TransactionTemplate transactionTemplate = new TransactionTemplate((PlatformTransactionManager)new DataSourceTransactionManager(dataSource));
        transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
                String[] scriptLines = StringUtils.delimitedListToStringArray((String)DatabaseUtils.stripComments(script), (String)";");
                for (int i = 0; i < scriptLines.length; ++i) {
                    String script2 = scriptLines[i].trim();
                    if (!StringUtils.hasText((String)script2)) continue;
                    if (params != null) {
                        script2 = PropertyPlaceholderUtils.resolve(script2, params);
                    }
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("executing script: " + script2));
                    }
                    try {
                        jdbcTemplate.execute(script2, params, new PreparedStatementCallback(){

                            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException {
                                ps.executeUpdate();
                                return null;
                            }
                        });
                        continue;
                    }
                    catch (DataAccessException e) {
                        if (ignoreExceptions && (!ignoreExceptions || script2.contains("DROP"))) continue;
                        throw e;
                    }
                }
                return null;
            }
        });
    }

    private static String stripComments(List<String> list) {
        StringBuffer buffer = new StringBuffer();
        for (String line : list) {
            if (line.startsWith("//") || line.startsWith("--") || line.trim().length() == 0) continue;
            buffer.append(line.trim()).append("\n");
        }
        return buffer.toString();
    }
}

