/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.test;

import es.capgemini.generalitat.common.properties.PropertyUtil;
import es.capgemini.generalitat.common.test.DatabaseUtils;
import javax.sql.DataSource;
import net.gencat.ctti.canigo.services.logging.Log;
import net.gencat.ctti.canigo.services.logging.log4j.Log4JServiceImpl;
import org.springframework.core.io.Resource;
import org.springframework.test.AbstractTransactionalSpringContextTests;

public abstract class TransactionalCommonAbstractTest
extends AbstractTransactionalSpringContextTests {
    private static Log4JServiceImpl loggingService;
    private static DataSource dataSource;

    public abstract String getDataSourceName();

    public abstract String[] getInitializationDataBaseScripts();

    public abstract String getDeleteDataBadeScripts();

    public abstract String getLoadDataBadeScripts();

    protected void onSetUp() throws Exception {
        this.setDefaultRollback(false);
        super.onSetUp();
    }

    protected void onSetUp(boolean rollback) throws Exception {
        this.setDefaultRollback(rollback);
        super.onSetUp();
    }

    protected void onSetUpBeforeTransaction() throws Exception {
        super.onSetUpBeforeTransaction();
        this.borrarBaseDatosApt();
        this.cargarBaseDatosApt();
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected void executeScript(String script) {
        DatabaseUtils.executeScript(this.getDataSource(), (Resource)this.applicationContext.getBean(script), null, true);
    }

    private void executeScripts(String[] scripts) {
        for (String script : scripts) {
            DatabaseUtils.executeScript(this.getDataSource(), (Resource)this.applicationContext.getBean(script), null, true);
        }
    }

    private void borrarBaseDatosApt() {
        this.getLogger().debug((Object)"Borrando BBDD");
        this.executeScript(this.getDeleteDataBadeScripts());
    }

    private void cargarBaseDatosApt() {
        this.getLogger().debug((Object)"Cargando BBDD");
        this.executeScript(this.getLoadDataBadeScripts());
    }

    protected Log getLogger() {
        return this.getLoggingService().getLog(((Object)((Object)this)).getClass());
    }

    protected Log4JServiceImpl getLoggingService() {
        if (loggingService == null) {
            loggingService = (Log4JServiceImpl)this.applicationContext.getBean("loggingService");
        }
        return loggingService;
    }

    private static boolean inicializarBaseDatos() {
        return PropertyUtil.getPropertyAsBoolean("inicializarBBDD");
    }

    private DataSource getDataSource() {
        if (dataSource == null) {
            dataSource = (DataSource)this.applicationContext.getBean(this.getDataSourceName());
            if (TransactionalCommonAbstractTest.inicializarBaseDatos()) {
                this.getLogger().debug((Object)"Inicializando BBDD");
                this.executeScripts(this.getInitializationDataBaseScripts());
            }
        }
        return dataSource;
    }
}

