/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class Utilitats {
    private static Logger logger = Logger.getLogger(Utilitats.class);
    public static final SimpleDateFormat FORMAT_DD_MM_YYYY_HH_MM_SS = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    public static final SimpleDateFormat FORMAT_DD_MM_YYYY_HH_MM = new SimpleDateFormat("dd/MM/yyyy HH:mm");
    public static final SimpleDateFormat FORMAT_DD_MM_YYYY = new SimpleDateFormat("dd/MM/yyyy");
    public static final DecimalFormatSymbols DEFAULT_DECIMAL_FORMAT_SYMBOLS_ES = new DecimalFormatSymbols(new Locale("es_ES"));
    public static final DecimalFormatSymbols DEFAULT_DECIMAL_FORMAT_SYMBOLS_CA = new DecimalFormatSymbols(new Locale("es_CA"));
    public static final DecimalFormat FORMAT_MONETARI_ES = new DecimalFormat("###,###.##", DEFAULT_DECIMAL_FORMAT_SYMBOLS_ES);
    public static final DecimalFormat FORMAT_MONETARI_CA = new DecimalFormat("###,###.##", DEFAULT_DECIMAL_FORMAT_SYMBOLS_CA);

    private Utilitats() {
    }

    public static String convertirDateAString(Date data, SimpleDateFormat format) {
        return data != null ? format.format(data) : "";
    }

    public static Date convertirStringADate(String strData, SimpleDateFormat format) {
        Date data = null;
        if (strData != null) {
            try {
                data = format.parse(strData);
            }
            catch (Exception e) {
                logger.error((Object)("Error al convertir la data " + strData + " a objecte Date mitjan\u00e7ant el patr\u00f3 " + format.toPattern()), (Throwable)e);
            }
        }
        return data;
    }

    public static String convertirFloatToString(Float valor, DecimalFormat format) throws IllegalArgumentException {
        format.setDecimalSeparatorAlwaysShown(false);
        return valor != null ? format.format(valor) : format.format(new Float(0.0f));
    }

    public static Float convertirStringToFloat(String valor, DecimalFormat format) throws ParseException {
        return Float.valueOf(format.parse(valor).floatValue());
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().equals("");
    }

    public static String tipoDocumento(String nif) {
        if (nif != null) {
            String letra;
            String dni;
            String tipo;
            nif = nif.toUpperCase();
            Matcher m = Pattern.compile("(\\d{8})([TRWAGMYFPDXBNJZSQVHLCKE])").matcher(nif);
            if (m.matches()) {
                tipo = "NIF";
                dni = m.group(1);
                letra = m.group(2);
            } else {
                m = Pattern.compile("([X])(\\d{0,8})([TRWAGMYFPDXBNJZSQVHLCKE])").matcher(nif);
                if (m.matches()) {
                    tipo = "NIE";
                } else {
                    m = Pattern.compile("([YZ])(\\d{0,7})([TRWAGMYFPDXBNJZSQVHLCKE])").matcher(nif);
                    if (m.matches()) {
                        tipo = "NIE";
                    } else {
                        return "Pasaporte";
                    }
                }
                if (m.group(1).equals("X")) {
                    dni = "0" + m.group(2);
                } else if (m.group(1).equals("Y")) {
                    dni = "1" + m.group(2);
                } else if (m.group(1).equals("Z")) {
                    dni = "2" + m.group(2);
                } else {
                    return "Pasaporte";
                }
                letra = m.group(3);
            }
            char[] letras = new char[]{'T', 'R', 'W', 'A', 'G', 'M', 'Y', 'F', 'P', 'D', 'X', 'B', 'N', 'J', 'Z', 'S', 'Q', 'V', 'H', 'L', 'C', 'K', 'E'};
            int numero = Integer.parseInt(dni) % 23;
            if (letra.charAt(0) == letras[numero]) {
                return tipo;
            }
            return "Pasaporte";
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean esNifNieValido(String valor) {
        String letra;
        String dni;
        boolean resultat = false;
        if (valor == null) return resultat;
        valor = valor.toUpperCase();
        Pattern patron = Pattern.compile("(\\d{8})([TRWAGMYFPDXBNJZSQVHLCKE])");
        Matcher m = patron.matcher(valor);
        if (m.matches()) {
            dni = m.group(1);
            letra = m.group(2);
        } else {
            patron = Pattern.compile("([X])(\\d{8})([TRWAGMYFPDXBNJZSQVHLCKE])");
            m = patron.matcher(valor);
            if (m.matches()) {
                if (!m.group(1).equals("X")) return resultat;
                dni = "0" + m.group(2);
            } else {
                patron = Pattern.compile("([YZ])(\\d{0,7})([TRWAGMYFPDXBNJZSQVHLCKE])");
                m = patron.matcher(valor);
                if (!m.matches()) return resultat;
                if (m.group(1).equals("Y")) {
                    dni = "1" + m.group(2);
                } else {
                    if (!m.group(1).equals("Z")) return resultat;
                    dni = "2" + m.group(2);
                }
            }
            letra = m.group(3);
        }
        char[] letras = new char[]{'T', 'R', 'W', 'A', 'G', 'M', 'Y', 'F', 'P', 'D', 'X', 'B', 'N', 'J', 'Z', 'S', 'Q', 'V', 'H', 'L', 'C', 'K', 'E'};
        int numero = Integer.parseInt(dni) % 23;
        if (letra.charAt(0) != letras[numero]) return resultat;
        return true;
    }
}

