/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.web.action;

import es.capgemini.generalitat.common.hibernate.dao.diccionarios.DaoDiccionario;
import es.capgemini.generalitat.common.i18n.I18nUtil;
import es.capgemini.generalitat.common.web.UIConstants;
import es.capgemini.generalitat.common.web.util.IDCAUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.gencat.ctti.canigo.services.exceptions.Exception;
import net.gencat.ctti.canigo.services.logging.Log;
import net.gencat.ctti.canigo.services.logging.log4j.Log4JServiceImpl;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.actions.DispatchAction;

public abstract class AbstractAction
extends DispatchAction
implements UIConstants {
    protected static final String UTF8_CHARSET = "UTF-8";
    private DaoDiccionario daoDiccionario;
    private Log4JServiceImpl loggingService;
    private Log logger;

    public Log getLogger() {
        return this.logger;
    }

    public void setLoggingService(Log4JServiceImpl loggingService) {
        this.loggingService = loggingService;
        this.logger = this.loggingService.getLog(this.getClass());
    }

    public DaoDiccionario getDaoDiccionario() {
        return this.daoDiccionario;
    }

    public void setDaoDiccionario(DaoDiccionario daoDiccionario) {
        this.daoDiccionario = daoDiccionario;
    }

    protected int getPage(HttpServletRequest request) {
        String value = this.getPaginationParameter(request, "p");
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value) - 1;
    }

    protected String getOrder(HttpServletRequest request) {
        String dir = "ASC";
        if ("2".equals(this.getPaginationParameter(request, "o"))) {
            dir = "DESC";
        }
        return dir;
    }

    protected String getSort(HttpServletRequest request) {
        String value = this.getPaginationParameter(request, "s");
        return value;
    }

    protected void setearIdioma(HttpServletRequest request) {
        String[] lang;
        String localeString = request.getParameter("locale");
        if (localeString != null && (lang = localeString.split("_")).length == 2) {
            Locale locale = new Locale(lang[0], lang[1].toUpperCase());
            request.getSession().setAttribute("org.apache.struts.action.LOCALE", (Object)locale);
            I18nUtil.setLocale(locale);
        }
    }

    protected String changeCharsetUtf8(String str) {
        try {
            if (str != null) {
                return new String(str.getBytes(), UTF8_CHARSET);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    protected void setCabecera(String key) {
        IDCAUtil.setCabecera(key);
    }

    protected void setPie(String key) {
        IDCAUtil.setPie(key);
    }

    protected void setMenuHorizontal(String key) {
        IDCAUtil.setMenuHorizontal(key);
    }

    protected void setMenuVertical(String key) {
        IDCAUtil.setMenuVertical(key);
    }

    protected void returnAjaxMsg(HttpServletResponse response, String msg) {
        response.setContentType("text/html;charset=ISO-8859-15");
        try {
            response.getOutputStream().print(msg);
        }
        catch (IOException e) {
            this.getLogger().error((Object)"Error al devolver la llamada de AJAX", (Throwable)e);
        }
    }

    protected void addMensajeError(String message, HttpServletRequest request, Object ... params) {
        ActionMessages messages = this.getMessages(request);
        messages.add("error", new ActionMessage(message, params));
        this.saveMessages(request, messages);
    }

    protected void addMensajeError(HttpServletRequest request, Exception exception) {
        String code = exception.getExceptionDetails().getErrorCode();
        Object[] params = exception.getExceptionDetails().getArguments();
        this.addMensajeError(code, request, params);
    }

    protected void addMensajeInfo(String message, HttpServletRequest request, Object ... params) {
        ActionMessages messages = this.getMessages(request);
        messages.add("info", new ActionMessage(message, params));
        this.saveMessages(request, messages);
    }

    protected void addMensajeConfirmacion(String message, HttpServletRequest request, Object ... params) {
        ActionMessages messages = this.getMessages(request);
        messages.add("confirmacion", new ActionMessage(message, params));
        this.saveMessages(request, messages);
    }

    private String getPaginationParameter(HttpServletRequest request, String ends) {
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            if (name == null || !name.startsWith("d-") || !name.endsWith("-" + ends)) continue;
            return request.getParameter(name);
        }
        return null;
    }
}

