/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.web.exception;

import es.capgemini.generalitat.common.i18n.I18nUtil;
import es.capgemini.generalitat.common.web.exception.PlatformException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.gencat.ctti.canigo.services.exceptions.BusinessException;
import net.gencat.ctti.canigo.services.exceptions.SystemException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.config.ExceptionConfig;

public class CustomExceptionHandler
extends ExceptionHandler {
    public ActionForward execute(Exception ex, ExceptionConfig ae, ActionMapping mapping, ActionForm formInstance, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String cod;
        Object[] arguments = null;
        if (ex instanceof BusinessException) {
            cod = ((BusinessException)ex).getExceptionDetails().getErrorCode();
            arguments = ((BusinessException)ex).getExceptionDetails().getArguments();
        } else if (ex instanceof SystemException) {
            cod = ((SystemException)((Object)ex)).getExceptionDetails().getErrorCode();
            arguments = ((SystemException)((Object)ex)).getExceptionDetails().getArguments();
        } else {
            cod = ex.getMessage();
        }
        if (cod != null) {
            cod = arguments != null ? I18nUtil.getMessage(cod, arguments) : I18nUtil.getMessage(cod);
        }
        request.setAttribute("errorMsg", (Object)cod);
        request.setAttribute("errorStack", (Object)PlatformException.stackTraceToString(ex));
        return super.execute(ex, ae, mapping, formInstance, request, response);
    }
}

