/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.web.exception;

import es.capgemini.generalitat.common.web.exception.ExceptionInfo;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;

public class PlatformException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(PlatformException.class);
    private Throwable throwable = null;
    private static MessageResources messages = MessageResources.getMessageResources((String)"ar.everis.nacargest.view.resources.ApplicationResources");

    public PlatformException(Throwable cause, String resourceKey) {
        super(messages.getMessage(resourceKey));
        this.setThrowable(cause);
    }

    public static String toString(Throwable error) {
        Throwable pe;
        StringBuffer res = new StringBuffer();
        ExceptionInfo sfi = new ExceptionInfo(error);
        res.append("Mensaje = " + error.getMessage() + "\n" + "Exception = " + error.getClass().getName() + "\n" + "Classname = " + sfi.getClassName() + "\n" + "Method = " + sfi.getMethod() + "\n" + "Line = " + sfi.getLine() + "\n" + "Stack = " + sfi.getStack() + "\n");
        if (error instanceof PlatformException && (pe = ((PlatformException)error).getThrowable()) != null) {
            res.append("\n**** Causa ****\n");
            res.append(PlatformException.toString(pe));
        }
        return res.toString();
    }

    public static ArrayList toArrayList(Throwable error) {
        Throwable pe;
        ExceptionInfo sfi = new ExceptionInfo(error);
        ArrayList<String> mensajes = new ArrayList<String>();
        mensajes.add("Mensaje = " + error.getMessage());
        mensajes.add("Exception = " + error.getClass().getName());
        mensajes.add("Classname = " + sfi.getClassName());
        mensajes.add("Method = " + sfi.getMethod());
        mensajes.add("Line = " + sfi.getLine());
        mensajes.add("Stack = " + sfi.getStack());
        if (error instanceof PlatformException && (pe = ((PlatformException)error).getThrowable()) != null) {
            mensajes.add("");
            mensajes.add("******************************** Causa ********************************");
            mensajes.addAll(PlatformException.toArrayList(pe));
        }
        return mensajes;
    }

    public static void logError(Throwable error) {
        String aux = PlatformException.toString(error);
        logger.error((Object)aux);
    }

    public static void showError(Throwable error) {
        System.out.println(PlatformException.toString(error));
    }

    public static String getMessage(ActionMessages am) {
        return "";
    }

    public static String getStackTrace(ActionMessages am) {
        return am.get("net.gencat.ctti.canigo.services.exceptions.Level.ERROR").next().toString();
    }

    public static String stackTraceToString(Exception e) {
        ExceptionInfo sfi = new ExceptionInfo(e);
        return e + "\n" + sfi.getStack();
    }

    private void setThrowable(Throwable throwable) {
        if (this.throwable == null) {
            this.throwable = throwable;
        }
    }

    private Throwable getThrowable() {
        return this.throwable;
    }
}

