/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SecurityFilter
implements Filter {
    protected String forward;
    private String[] excluded;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        if (request instanceof HttpServletRequest) {
            HttpSession session = ((HttpServletRequest)request).getSession();
            try {
                if (session.getAttribute("usuario") != null || this.validateExcludedPath(((HttpServletRequest)request).getRequestURI())) {
                    chain.doFilter(request, response);
                } else {
                    ((HttpServletResponse)response).sendRedirect(((HttpServletRequest)request).getContextPath() + this.forward);
                }
            }
            catch (IOException io) {
                System.out.println("IOException raised");
            }
            catch (ServletException se) {
                System.out.println("ServletException raised");
            }
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig arg0) throws ServletException {
        this.forward = arg0.getInitParameter("foward");
        String exclud = arg0.getInitParameter("excluded");
        if (exclud != null) {
            this.excluded = exclud.split(",");
        }
    }

    protected boolean validateExcludedPath(String uri) {
        if (this.excluded != null) {
            for (String e : this.excluded) {
                if (!uri.contains(e)) continue;
                return true;
            }
        }
        return false;
    }
}

