/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.web.struts;

import es.capgemini.generalitat.common.web.UIConstants;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.gencat.ctti.canigo.services.web.struts.ExtendedDelegatingTilesRequestProcessor;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.springframework.dao.DataIntegrityViolationException;

public class CommonExtendedDelegatingTilesRequestProcessor
extends ExtendedDelegatingTilesRequestProcessor
implements UIConstants {
    protected ActionForward processException(HttpServletRequest request, HttpServletResponse response, Exception exception, ActionForm form, ActionMapping mapping) {
        if (exception instanceof net.gencat.ctti.canigo.services.exceptions.Exception) {
            this.addCanigoErrorMessage(request, (net.gencat.ctti.canigo.services.exceptions.Exception)exception);
            return this.getActionForward(request, mapping);
        }
        if (exception instanceof DataIntegrityViolationException) {
            this.addDDBBErrorMessage(request, (DataIntegrityViolationException)exception);
            return this.getActionForward(request, mapping);
        }
        this.addErrorMessage(request, exception);
        return this.getActionForward(request, mapping);
    }

    private void addCanigoErrorMessage(HttpServletRequest request, net.gencat.ctti.canigo.services.exceptions.Exception exception) {
        String code = exception.getExceptionDetails().getErrorCode();
        Object[] params = exception.getExceptionDetails().getArguments();
        ActionMessages messages = new ActionMessages();
        ActionMessage message = new ActionMessage(code, params);
        messages.add("error", message);
        this.saveMessages(request, messages);
    }

    private void addDDBBErrorMessage(HttpServletRequest request, DataIntegrityViolationException exception) {
        ActionMessages messages = new ActionMessages();
        ActionMessage message = new ActionMessage("exception.baseDatos");
        messages.add("error", message);
        messages.add("stackTrace", this.createStackTraceMessage((Exception)exception));
        this.saveMessages(request, messages);
    }

    private void addErrorMessage(HttpServletRequest request, Exception exception) {
        ActionMessages messages = new ActionMessages();
        ActionMessage message = null;
        message = exception.getMessage() != null ? new ActionMessage("exception.unexpected", (Object)exception.getMessage()) : new ActionMessage("exception.unexpected", (Object)exception);
        messages.add("error", message);
        messages.add("stackTrace", this.createStackTraceMessage(exception));
        this.saveMessages(request, messages);
    }

    private ActionMessage createStackTraceMessage(Exception exception) {
        StringWriter stackTrace = new StringWriter();
        exception.printStackTrace(new PrintWriter(stackTrace));
        stackTrace.flush();
        return new ActionMessage("exception.stackTrace", new Object[]{stackTrace.toString()});
    }

    private ActionForward getActionForward(HttpServletRequest request, ActionMapping mapping) {
        ActionForward forward;
        String reqCode = null;
        if (mapping.getParameter() != null) {
            reqCode = request.getParameter(mapping.getParameter()) != null ? request.getParameter(mapping.getParameter()) : (String)request.getAttribute(mapping.getParameter());
        }
        String suffix = "";
        if (reqCode != null && reqCode.length() > 1) {
            suffix = reqCode.substring(0, 1).toUpperCase() + reqCode.substring(1);
        }
        if ((forward = mapping.findForward("error" + suffix)) == null) {
            forward = mapping.findForward("error");
        }
        if (forward == null) {
            forward = mapping.findForward("errorGenerico");
        }
        return forward;
    }

    private void saveMessages(HttpServletRequest request, ActionMessages messages) {
        if (messages == null || messages.isEmpty()) {
            request.removeAttribute("org.apache.struts.action.ACTION_MESSAGE");
            return;
        }
        request.setAttribute("org.apache.struts.action.ACTION_MESSAGE", (Object)messages);
    }
}

