/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.web.util;

import es.capgemini.generalitat.common.i18n.I18nUtil;
import org.apache.commons.lang.StringEscapeUtils;

public class HtmlUtils {
    private HtmlUtils() {
    }

    public static StringBuffer crearTooltip(String icon, String tooltip, String titleKey) {
        String title = I18nUtil.getMessage(titleKey);
        StringBuffer sb = new StringBuffer();
        sb.append("<span class='helpClose'>");
        sb.append("<img src='" + icon + "' class='uihelp' title='" + title + "' alt='" + title + "' />");
        sb.append("<span class='tooltip information'>");
        sb.append(tooltip);
        sb.append("</span>");
        sb.append("</span>");
        return sb;
    }

    public static StringBuffer crearLinea(String key, String value) {
        return HtmlUtils.crearLinea(key, value, true);
    }

    public static StringBuffer crearLinea(String key, String value, boolean isKey) {
        String label = key;
        if (isKey) {
            label = I18nUtil.getMessage(key);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<strong>" + StringEscapeUtils.escapeHtml((String)label) + ": </strong>");
        sb.append(value);
        sb.append("<br />");
        return sb;
    }

    public static StringBuffer crearLinkConIcono(String path, String ico, String titleKey) {
        String title = StringEscapeUtils.escapeHtml((String)I18nUtil.getMessage(titleKey));
        StringBuffer sb = new StringBuffer();
        sb.append("<a href='").append(path).append("'>");
        sb.append("<img src='").append(ico).append("' alt='").append(title).append("' title='").append(title).append("'/></a>");
        return sb;
    }

    public static StringBuffer crearLink(String path, String labelKey) {
        return HtmlUtils.crearLink(path, labelKey, true);
    }

    public static StringBuffer crearLink(String path, String labelKey, boolean isKey) {
        String label = labelKey;
        if (isKey) {
            label = I18nUtil.getMessage(labelKey);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<a href='").append(path).append("'>").append(StringEscapeUtils.escapeHtml((String)label)).append("</a>");
        return sb;
    }

    public static StringBuffer crearListItem(CharSequence str) {
        StringBuffer sb = new StringBuffer();
        sb.append("<li>").append(str).append("</li>");
        return sb;
    }

    public static String crearListaAcciones(StringBuffer str) {
        StringBuffer sb = new StringBuffer();
        sb.append("<ul class='actions'>").append(str).append("</ul>");
        return sb.toString();
    }
}

