/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.web.util;

import es.capgemini.generalitat.common.manager.ManagerCache;

public class IDCAUtil {
    private static ManagerCache managerCache;
    private static String cabecera;
    private static String pie;
    private static String menuVertical;
    private static String menuHorizontal;
    private static final String CABECERA_DEFAULT = "element.default.cap";
    private static final String PIE_DEFAULT = "element.default.peu";
    private static final String MENU_VERTICAL_DEFAULT = "element.default.menuVertical";
    private static final String MENU_HORIZONTAL_DEFAULT = "element.default.menuHorizontal";

    public static String getCabecera() {
        if (cabecera == null) {
            cabecera = CABECERA_DEFAULT;
        }
        return IDCAUtil.validaCache(managerCache.getElement(cabecera), CABECERA_DEFAULT);
    }

    public static String getPie() {
        if (pie == null) {
            pie = PIE_DEFAULT;
        }
        return IDCAUtil.validaCache(managerCache.getElement(pie), PIE_DEFAULT);
    }

    public static String getMenuVertical() {
        if (menuVertical == null) {
            menuVertical = MENU_VERTICAL_DEFAULT;
        }
        return IDCAUtil.validaCache(managerCache.getElement(menuVertical), MENU_VERTICAL_DEFAULT);
    }

    public static String getMenuHorizontal() {
        if (menuHorizontal == null) {
            menuHorizontal = MENU_HORIZONTAL_DEFAULT;
        }
        return IDCAUtil.validaCache(managerCache.getElement(menuHorizontal), MENU_HORIZONTAL_DEFAULT);
    }

    public static String getElement(String path) {
        return managerCache.getElement(path);
    }

    public ManagerCache getManagerCache() {
        return managerCache;
    }

    public void setManagerCache(ManagerCache managerCache) {
        IDCAUtil.managerCache = managerCache;
    }

    public static void setCabecera(String cabecera) {
        IDCAUtil.cabecera = cabecera;
    }

    public static void setPie(String pie) {
        IDCAUtil.pie = pie;
    }

    public static void setMenuVertical(String menuVertical) {
        IDCAUtil.menuVertical = menuVertical;
    }

    public static void setMenuHorizontal(String menuHorizontal) {
        IDCAUtil.menuHorizontal = menuHorizontal;
    }

    private static String validaCache(String cache, String defaultValue) {
        if (cache == null || cache.length() == 0) {
            return managerCache.getElement(defaultValue);
        }
        return cache;
    }
}

