/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.webservices;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import es.capgemini.generalitat.common.webservices.eform.xsd.Annex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtreureAdjunts {
    private ExtreureAdjunts() {
    }

    public static List<Annex> extract(byte[] pdf) {
        try {
            PdfDictionary localPdfDictionary3;
            PdfReader pdfReader = new PdfReader(pdf);
            PdfDictionary localPdfDictionary1 = pdfReader.getCatalog();
            PdfDictionary localPdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)localPdfDictionary1.get(PdfName.NAMES));
            ArrayList<Annex> llistatFitxers = new ArrayList<Annex>();
            if (localPdfDictionary2 != null && (localPdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)localPdfDictionary2.get(new PdfName("EmbeddedFiles")))) != null) {
                HashMap localObject1 = PdfNameTree.readTree((PdfDictionary)localPdfDictionary3);
                Iterator localObject2 = localObject1.values().iterator();
                while (localObject2.hasNext()) {
                    PdfDictionary localPdfDictionary4 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)((PdfObject)localObject2.next()));
                    byte[] fitxer = ExtreureAdjunts.unpackFile(pdfReader, localPdfDictionary4);
                    Annex annex = new Annex();
                    annex.setContingut(fitxer);
                    annex.setNomArxiu(((PdfString)PdfReader.getPdfObject((PdfObject)localPdfDictionary4.get(PdfName.F))).toString());
                    llistatFitxers.add(annex);
                }
                return llistatFitxers;
            }
            for (int i = 1; i <= pdfReader.getNumberOfPages(); ++i) {
                PdfObject localObject3 = PdfReader.getPdfObject((PdfObject)pdfReader.getPageN(i).get(PdfName.ANNOTS));
                if (localObject3 == null) continue;
                ListIterator localObject4 = ((PdfArray)localObject3).listIterator();
                while (localObject4.hasNext()) {
                    PdfDictionary localPdfDictionary4 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)((PdfObject)localObject4.next()));
                    PdfName localPdfName = (PdfName)PdfReader.getPdfObject((PdfObject)localPdfDictionary4.get(PdfName.SUBTYPE));
                    if (!PdfName.FILEATTACHMENT.equals((Object)localPdfName)) continue;
                    PdfDictionary localPdfDictionary5 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)localPdfDictionary4.get(PdfName.FS));
                    Annex annex = new Annex();
                    byte[] fitxer = ExtreureAdjunts.unpackFile(pdfReader, localPdfDictionary5);
                    annex.setContingut(fitxer);
                    annex.setNomArxiu(((PdfString)PdfReader.getPdfObject((PdfObject)localPdfDictionary5.get(PdfName.F))).toString());
                    llistatFitxers.add(annex);
                }
                return llistatFitxers;
            }
        }
        catch (Exception localException) {
            localException.printStackTrace();
        }
        return null;
    }

    private static byte[] unpackFile(PdfReader paramPdfReader, PdfDictionary paramPdfDictionary) throws IOException {
        PdfDictionary localPdfDictionary = (PdfDictionary)PdfReader.getPdfObject((PdfObject)paramPdfDictionary.get(PdfName.EF));
        PdfString localPdfString = (PdfString)PdfReader.getPdfObject((PdfObject)paramPdfDictionary.get(PdfName.F));
        System.out.println("Unpacking file '" + localPdfString);
        PRStream localPRStream = (PRStream)PdfReader.getPdfObject((PdfObject)localPdfDictionary.get(PdfName.F));
        byte[] arrayOfByte = PdfReader.getStreamBytes((PRStream)localPRStream);
        return arrayOfByte;
    }
}

