/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.webservices;

import es.capgemini.generalitat.common.manager.ManagerAbstract;
import es.capgemini.generalitat.common.webservices.ExtreureAdjunts;
import es.capgemini.generalitat.common.webservices.eform.EformException;
import es.capgemini.generalitat.common.webservices.eform.ServeisAdobePortTypeProxy;
import es.capgemini.generalitat.common.webservices.eform.xsd.Annex;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.List;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerEform
extends ManagerAbstract {
    public static final String BEAN_ID = "managerEform";
    private String url;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if (url == null) {
            this.url = "http://10.68.24.81:7001/WSFormsInterior/services/ServeisAdobeSOAP11port_http";
        }
        this.url = url;
    }

    public byte[] renderiza(String ambito, String aplicacion, String formName, File xml, String formato) {
        try {
            return this.renderiza(ambito, aplicacion, formName, FileUtils.readFileToByteArray((File)xml), formato);
        }
        catch (IOException e) {
            this.getLogger().error((Object)("No se puede leer el archivo: " + xml.getName()), (Throwable)e);
            throw new EformException(e, "exception.managerEform.archivo", new Object[]{xml.getName()});
        }
    }

    public byte[] renderiza(String ambito, String aplicacion, String formName, String xml, String formato) {
        return this.renderiza(ambito, aplicacion, formName, xml.getBytes(), formato);
    }

    private byte[] renderiza(String ambito, String aplicacion, String formName, byte[] xml, String formato) {
        byte[] resultat;
        ServeisAdobePortTypeProxy saptp = null;
        try {
            saptp = new ServeisAdobePortTypeProxy(this.url);
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error al Obtener la conexion con el WS", (Throwable)e);
            throw new EformException(e, "exception.managerEform.conexion");
        }
        try {
            this.getLogger().info((Object)"Anem a fer la crida al servei de formularis per renderitzar el formulari");
            resultat = saptp.renderitzarFormulariXDP(ambito, aplicacion, formName, xml, formato).getArxiu();
            this.getLogger().info((Object)"Fi de la crida al servei de formularis per renderitzar el formulari");
            if (resultat == null) {
                this.getLogger().error((Object)"Error al fer la crida al servei de formularis per renderitzar, el resultat es null");
                throw new EformException("exception.managerEform.conexion");
            }
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                this.getLogger().error((Object)"Error al conectarnos al servicio de Eforms", e.getCause());
                throw new EformException(e.getCause(), "exception.managerEform.conexion");
            }
            this.getLogger().error((Object)"Error en la llamada renderitzarFormulariXDP del WS Eform", (Throwable)e);
            throw new EformException(e, "exception.managerEform.rederiza");
        }
        return resultat;
    }

    public File obtenerXMLdelPDF(File pdf) throws IOException {
        byte[] resultado = this.obtenerXMLdelPDF(FileUtils.readFileToByteArray((File)pdf));
        File file = new File(pdf.getName() + ".xml");
        FileUtils.writeByteArrayToFile((File)file, (byte[])resultado);
        return file;
    }

    public byte[] obtenerXMLdelPDF(byte[] pdf) {
        byte[] resultado;
        ServeisAdobePortTypeProxy saptp = null;
        try {
            saptp = new ServeisAdobePortTypeProxy(this.url);
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error al Obtener la conexion con el WS", (Throwable)e);
            throw new EformException(e, "exception.managerEform.conexion");
        }
        try {
            this.getLogger().info((Object)"Anem a fer la crida al servei de formularis per obtenir el XML");
            resultado = saptp.extreureDadesXML(pdf).getArxiu();
            this.getLogger().info((Object)"Fi de la crida al servei de formularis per obtenir el XML");
            if (resultado == null) {
                this.getLogger().error((Object)"Error en la llamada extreureDadesXML del WS Eform, les dades retornades son null");
                throw new EformException("exception.managerEform.extraer");
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error en la llamada extreureDadesXML del WS Eform", (Throwable)e);
            throw new EformException(e, "exception.managerEform.extraer");
        }
        return resultado;
    }

    public List<Annex> obtenerAnexosDelPDF(byte[] pdf) {
        return ExtreureAdjunts.extract(pdf);
    }
}

