/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.webservices;

import cat.gencat.dirip.psis.bean.OptionalInputsOID;
import cat.gencat.dirip.psis.bean.OptionalInputsPDF;
import cat.gencat.dirip.psis.common.UtilsPsis;
import es.capgemini.generalitat.common.manager.ManagerAbstract;
import es.capgemini.generalitat.common.pdf.PdfUtil;
import es.capgemini.generalitat.common.webservices.eform.PsisException;
import java.net.URL;
import java.security.MessageDigest;
import org.apache.axis.types.URI;
import org.w3.www._2000._09.xmldsig.DigestMethodType;
import org.w3.www._2000._09.xmldsig.DigestValueType;
import org.w3.www._2000._09.xmldsig.X509DataType;
import schema.core._0._1.dss.tc.names.oasis.Base64Data;
import schema.core._0._1.dss.tc.names.oasis.Base64Signature;
import schema.core._0._1.dss.tc.names.oasis.DocumentHash;
import schema.core._0._1.dss.tc.names.oasis.DocumentType;
import schema.core._0._1.dss.tc.names.oasis.InputDocuments;
import schema.core._0._1.dss.tc.names.oasis.OptionalInputs;
import schema.core._0._1.dss.tc.names.oasis.Result;
import schema.core._0._1.dss.tc.names.oasis.SignatureObjectType;
import schema.core._0._1.dss.tc.names.oasis.SignatureObjectTypeOther;
import schema.core._0._1.dss.tc.names.oasis.VerifyRequest;
import schema.core._0._1.dss.tc.names.oasis.VerifyResponse;
import wsdl.core._0._1.dss.tc.names.oasis.DigitalSignatureServiceLocator;

public class ManagerPsis
extends ManagerAbstract {
    public String[] validarCertificatPSIS(byte[] certificat, String psisUrl) throws Exception {
        DigitalSignatureServiceLocator locator = new DigitalSignatureServiceLocator();
        VerifyRequest request = new VerifyRequest();
        request.setProfile(new URI("urn:oasis:names:tc:dss:1.0:profiles:XSS"));
        SignatureObjectType signatureObject = new SignatureObjectType();
        request.setSignatureObject(signatureObject);
        SignatureObjectTypeOther any = new SignatureObjectTypeOther();
        signatureObject.setOther(any);
        X509DataType x509data2 = new X509DataType();
        any.setX509Data(x509data2);
        x509data2.setX509Certificate(certificat);
        OptionalInputsOID optional = new OptionalInputsOID();
        request.setOptionalInputs((OptionalInputs)optional);
        this.getLogger().debug((Object)("XML crida PSIS: " + request.toString()));
        VerifyResponse response = locator.getdssPortSoap(new URL(psisUrl)).verify(request);
        this.getLogger().debug((Object)"Fi crida PSIS");
        Result result = response.getResult();
        String major = result.getResultMajor().toString();
        String minor = result.getResultMinor().toString();
        String[] res = null;
        if (major.equalsIgnoreCase("urn:oasis:names:tc:dss:1.0:resultmajor:Success") && response.getOptionalOutputs() != null && response.getOptionalOutputs().getX509CertificateInfo() != null && response.getOptionalOutputs().getX509CertificateInfo().length > 0 && response.getOptionalOutputs().getX509CertificateInfo()[0].length > 0 && minor.contains("urn:oasis:names:tc:dss:1.0:profiles:XSS:resultminor:valid")) {
            res = new String[]{response.getOptionalOutputs().getX509CertificateInfo()[0][0].toString(), response.getOptionalOutputs().getX509CertificateInfo()[1][0].toString(), response.getOptionalOutputs().getX509CertificateInfo()[2][0].toString(), response.getOptionalOutputs().getX509CertificateInfo()[3][0].toString(), response.getOptionalOutputs().getX509CertificateInfo()[4][0].toString()};
        }
        if (res == null) {
            res = new String[5];
            this.getLogger().error((Object)"CERTIFICAT NO V\u00c0LID");
            throw new PsisException("exception.managerPsis.valida");
        }
        this.getLogger().info((Object)("CERTIFICAT V\u00c0LID AMB NIF " + res[1]));
        return res;
    }

    public String validarSignaturaPDFPSIS(byte[] document, String psisUrl) throws Exception {
        DigitalSignatureServiceLocator locator = new DigitalSignatureServiceLocator();
        VerifyRequest request = new VerifyRequest();
        request.setProfile(new URI("urn:oasis:names:tc:dss:1.0:profiles:DSS_PDF"));
        InputDocuments inputDocs = new InputDocuments();
        DocumentType documentType = new DocumentType();
        Base64Data data = new Base64Data();
        data.set_value(document);
        documentType.setBase64Data(data);
        inputDocs.setDocument(documentType);
        request.setInputDocuments(inputDocs);
        OptionalInputsPDF optional = new OptionalInputsPDF();
        request.setOptionalInputs((OptionalInputs)optional);
        VerifyResponse response = null;
        try {
            response = locator.getdssPortSoap(new URL(psisUrl)).verify(request);
        }
        catch (Exception e) {
            this.getLogger().error((Object)"S'ha produit un error en la crida a PSIS per validar la signatura d'un PDF");
            throw new PsisException(e, "exception.psis.conexion");
        }
        Result result = response.getResult();
        String major = result.getResultMajor().toString();
        String minor = result.getResultMinor().toString();
        String res = null;
        if (!major.equalsIgnoreCase("urn:oasis:names:tc:dss:1.0:resultmajor:Success") || !minor.equalsIgnoreCase("urn:oasis:names:tc:dss:1.0:resultminor:valid:signature:onAllDocuments")) {
            this.getLogger().error((Object)"La validaci\u00f3 de la signatura del pdf es incorrecta:");
            this.getLogger().error((Object)("Result major:" + major));
            this.getLogger().error((Object)("Result minor:" + minor));
            throw new PsisException("exception.psis.signatura.pdf.no.valida");
        }
        res = UtilsPsis.toXml((VerifyResponse)response);
        return res;
    }

    public String validarSignaturaPSIS(byte[] document, String psisUrl) throws Exception {
        DigitalSignatureServiceLocator locator = new DigitalSignatureServiceLocator();
        VerifyRequest request = new VerifyRequest();
        request.setProfile(new URI("urn:oasis:names:tc:dss:1.0:profiles:XSS"));
        SignatureObjectType signObject = new SignatureObjectType();
        Base64Signature b64Signature = new Base64Signature();
        byte[] signatura = PdfUtil.extraccioSignaturaCMSDetachedDePDF(document);
        b64Signature.set_value(signatura);
        b64Signature.setType(new URI("urn:ietf:rfc:3369"));
        signObject.setBase64Signature(b64Signature);
        request.setSignatureObject(signObject);
        InputDocuments inputDocs = new InputDocuments();
        DocumentHash documentHash = new DocumentHash();
        DigestMethodType dmt = new DigestMethodType();
        dmt.setAlgorithm(new URI("http://www.w3.org/2000/09/xmldsig#sha1"));
        documentHash.setDigestMethod(dmt);
        byte[] signedData = PdfUtil.extraccioSignedDataDePDF(document);
        byte[] signedDataHash = MessageDigest.getInstance("SHA1", "BC").digest(signedData);
        DigestValueType digestValue = new DigestValueType();
        digestValue.set_value(signedDataHash);
        documentHash.setDigestValue(digestValue);
        inputDocs.setDocumentHash(documentHash);
        request.setInputDocuments(inputDocs);
        OptionalInputsPDF optional = new OptionalInputsPDF();
        request.setOptionalInputs((OptionalInputs)optional);
        VerifyResponse response = null;
        try {
            response = locator.getdssPortSoap(new URL(psisUrl)).verify(request);
        }
        catch (Exception e) {
            this.getLogger().error((Object)("S'ha produit un error en la crida a PSIS per validar la signatura d'un PDF:" + e));
            throw new PsisException(e, "exception.psis.conexion");
        }
        Result result = response.getResult();
        String major = result.getResultMajor().toString();
        String minor = result.getResultMinor().toString();
        String res = null;
        if (!major.equalsIgnoreCase("urn:oasis:names:tc:dss:1.0:resultmajor:Success") || !minor.equalsIgnoreCase("urn:oasis:names:tc:dss:1.0:resultminor:valid:signature:onAllDocuments")) {
            this.getLogger().error((Object)"La validaci\u00f3 de la signatura del pdf es incorrecta:");
            this.getLogger().error((Object)("Result major:" + major));
            this.getLogger().error((Object)("Result minor:" + minor));
            throw new PsisException("exception.psis.signatura.pdf.no.valida");
        }
        res = UtilsPsis.toXml((VerifyResponse)response);
        return res;
    }
}

