/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.webservices;

import es.capgemini.generalitat.common.cryto.CryptoUtil;
import es.capgemini.generalitat.common.manager.ManagerAbstract;
import es.capgemini.generalitat.common.properties.PropertyUtil;
import es.capgemini.generalitat.common.webservices.sarcat.ConfigSarcatBean;
import es.capgemini.generalitat.common.webservices.sarcat.SarcatException;
import es.tsystems.sarcat.schema.AssentamentEntradaSortida_xsd.AltaAssentamentEntradaSortida;
import es.tsystems.sarcat.schema.AssentamentEntradaSortida_xsd.AssentamentEntradaInfo;
import es.tsystems.sarcat.schema.AssentamentEntradaSortida_xsd.AssentamentSortidaInfo;
import es.tsystems.sarcat.schema.AssentamentEntradaSortida_xsd.Info;
import es.tsystems.sarcat.schema.AssentamentRetorn_xsd.AssentamentsRetorn;
import es.tsystems.sarcat.schema.AssentamentRetorn_xsd.AssentamentsRetornAssentamentRetorn;
import es.tsystems.sarcat.schema.Common_xsd.TipusAssentament;
import es.tsystems.sarcat.schema.LlistatTaulaMestraCerca_xsd.TaulaMestraCerca;
import es.tsystems.sarcat.schema.LlistatTaulaMestraCerca_xsd.TaulaMestraCercaOrdreTaulaMestra;
import es.tsystems.sarcat.schema.LlistatTaulaMestraCerca_xsd.TaulaMestraCercaParametresCercaTaulaMestra;
import es.tsystems.sarcat.schema.LlistatTaulaMestraCerca_xsd.TipusTaula;
import es.tsystems.sarcat.schema.LlistatTaulaMestra_xsd.LlistatTaulaMestra;
import es.tsystems.sarcat.schema.LlistatTaulaMestra_xsd.LlistatTaulaMestraTaulaMestra;
import es.tsystems.sarcat.schema.LoginRetorn_xsd.LoginRetorn;
import es.tsystems.sarcat.schema.Login_xsd.LoginInfo;
import es.tsystems.sarcat.schema.NumsRegistre_xsd.NumsRegistreInfo;
import es.tsystems.sarcat.schema.NumsRegistre_xsd.NumsRegistreResponse;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import net.gencat.ctti.canigo.services.configuration.exception.ConfigurationServiceException;
import net.gencat.ctti.canigo.services.webservices.WebServicesService;
import org.openuri.www.ConnectorWSSoap;

public class ManagerSarcat
extends ManagerAbstract {
    private static final String SARCAT_WS_ID = "sarcatWebService";
    private ConfigSarcatBean configSarcatBean;
    private static final int SARCAT_VIA_PRESENTACIO_TELEMATICA = 5;
    private static final int SARCAT_TIPUS_TRAMESA_ENTITAT_JURIDICA = 2;
    private static final int SARCAT_TIPUS_DOCUMENT_SOLICITUD = 1;
    private static final int SARCAT_TIPUS_DOCUMENT_CERTIFICAT = 12;
    private static final int SARCAT_SUPORT_FISIC_ELECTRONIC = 3;
    private static final String SARCAT_ID_POBLACIO_BARCELONA = "080193";
    private static final Long SARCAT_ANNEX_LLIURAT = new Long(1L);
    private static final String SARCAT_ASSUMPTE_CE = "Comunicaci\u00f3 d'empla\u00e7ament de m\u00e0quines recreatives de tipus A i B";
    private static final String SARCAT_ASSUMPTE_AE = "Sol\u00b7licitud d'autoritzaci\u00f3 d'empla\u00e7ament de m\u00e0quines recreatives de tipus A i B";
    private static final String SARCAT_ASSUMPTE_PCE = "Sol\u00b7licitud de perm\u00eds d'explotaci\u00f3 de m\u00e0quines de tipus B amb comunicaci\u00f3 d'empla\u00e7ament";
    private static final String SARCAT_ASSUMPTE_PAE = "Sol\u00b7licitud de perm\u00eds d'explotaci\u00f3 de m\u00e0quines de tipus B amb autoritzaci\u00f3 d'empla\u00e7ament";
    private static final String SARCAT_ASSUMPTE_B = "Sol\u00b7licitud de baixa de m\u00e0quines recreatives de tipus A i B";
    private static final String SARCAT_ASSUMPTE_CAAE = "Comunicaci\u00f3 d'alta de nova m\u00e0quina de tipus A amb autoritzaci\u00f3 d'empla\u00e7ament";
    private static final String SARCAT_ASSUMPTE_CACE = "Comunicaci\u00f3 d'alta de nova m\u00e0quina de tipus A amb comunicaci\u00f3 d'empla\u00e7ament";
    private static final String SARCAT_ASSUMPTE_SORTIDA_CA = "Document d'autoritzaci\u00f3 d'empla\u00e7ament de m\u00e0quines recreatives de tipus A i B";
    private static final String SARCAT_ASSUMPTE_SORTIDA_PE = "Document de perm\u00eds d'explotaci\u00f3 de m\u00e0quines de tipus B";
    private static final String SARCAT_ASSUMPTE_SORTIDA_CAAE = "Document de comunicaci\u00f3 d'alta de nova m\u00e0quina de tipus A";
    private WebServicesService service;

    public ConfigSarcatBean getConfigSarcatBean() {
        return this.configSarcatBean;
    }

    public void setConfigSarcatBean(ConfigSarcatBean configSarcatBean) {
        this.configSarcatBean = configSarcatBean;
    }

    public WebServicesService getService() {
        return this.service;
    }

    public boolean ping() {
        this.getLogger().debug((Object)"SARCAT -> PING");
        ConnectorWSSoap sarcat = this.getConnector();
        try {
            String str = sarcat.ping();
            return str != null && str.startsWith("OK");
        }
        catch (RemoteException e) {
            this.getLogger().error((Object)"Error al fer ping contra s@rcat", (Throwable)e);
            return false;
        }
    }

    public String login() {
        this.getLogger().debug((Object)"SARCAT -> LOGIN");
        LoginRetorn ret = null;
        LoginInfo login = new LoginInfo();
        login.setUser(this.configSarcatBean.getUsuario());
        String pwd = null;
        try {
            pwd = CryptoUtil.descifraTripleDes(this.configSarcatBean.getPassword());
        }
        catch (Exception e) {
            throw new SarcatException(e, "exception.managerSarcat.errorDesencriptarClau");
        }
        login.setPassword(pwd);
        ConnectorWSSoap sarcat = this.getConnector();
        try {
            ret = sarcat.login(login);
            String token = ret.getToken();
            if (token == null || token.length() == 0) {
                this.getLogger().info((Object)"Error a l'intentar fer login contra s@rcat");
                throw new SarcatException("exception.managerSarcat.login");
            }
            return token;
        }
        catch (RemoteException e) {
            this.getLogger().error((Object)"Error a l'intentar fer login contra s@rcat");
            throw new SarcatException(e, "exception.managerSarcat.login");
        }
    }

    public Long getNumeroDeRegistro() {
        this.getLogger().info((Object)"SARCAT -> GET NUMERO REGISTRO");
        String token = this.login();
        NumsRegistreInfo numsRegistreInfo = new NumsRegistreInfo();
        numsRegistreInfo.setToken(token);
        numsRegistreInfo.setUrUsuari(this.configSarcatBean.getUrUsuario());
        numsRegistreInfo.setTipus(TipusAssentament.entrada);
        ConnectorWSSoap sarcat = this.getConnector();
        try {
            NumsRegistreResponse resp = sarcat.getNumsRegistre(numsRegistreInfo);
            this.getLogger().info((Object)("Numero de registro: " + resp.getNumInici()));
            return resp.getNumInici();
        }
        catch (RemoteException e) {
            this.getLogger().error((Object)"Error a l'obtenir el n\u00famero de registre de s@cart.", (Throwable)e);
            throw new SarcatException(e, "exception.managerSarcat.errorNumRegistre");
        }
    }

    public LlistatTaulaMestraTaulaMestra[] listarTablasMaestras(TipusTaula tipoTabla, String codigo, String descripcion) {
        TaulaMestraCerca taulaMestraCerca = new TaulaMestraCerca();
        String token = this.login();
        taulaMestraCerca.setToken(token);
        taulaMestraCerca.setUrUsuari(this.configSarcatBean.getUrUsuario());
        taulaMestraCerca.setOrdreTaulaMestra(TaulaMestraCercaOrdreTaulaMestra.codi);
        TaulaMestraCercaParametresCercaTaulaMestra param = new TaulaMestraCercaParametresCercaTaulaMestra();
        param.setIdTaula(tipoTabla);
        param.setCodi(codigo);
        param.setDescripcio(descripcion);
        param.setMaximRegistres(50);
        taulaMestraCerca.setParametresCercaTaulaMestra(param);
        ConnectorWSSoap sarcat = this.getConnector();
        try {
            LlistatTaulaMestra resp = sarcat.llistarTaulaMestra(taulaMestraCerca);
            return resp.getTaulaMestra();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[] altaRegistroEntrada(String empresa, String tipoTramite) {
        String[] res = new String[2];
        try {
            AssentamentsRetorn retAss;
            Boolean entornoCliente = true;
            try {
                entornoCliente = PropertyUtil.getPropertyAsBoolean("entorno.cliente");
            }
            catch (ConfigurationServiceException e) {
                this.getLogger().error((Object)"Error al obtener la propiedad: entorno.cliente", (Throwable)e);
                throw e;
            }
            if (entornoCliente != null && !entornoCliente.booleanValue()) {
                SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                return new String[]{"RegEntrada" + System.currentTimeMillis(), df.format(new Date())};
            }
            ConnectorWSSoap sarcat = this.getConnector();
            String token = this.login();
            AltaAssentamentEntradaSortida assentament = new AltaAssentamentEntradaSortida();
            assentament.setToken(token);
            assentament.setUrUsuari(this.configSarcatBean.getUrUsuario());
            AssentamentEntradaInfo entrada = this.crearAssentamentEntradaEmpresaTelematic(empresa, tipoTramite);
            AssentamentEntradaInfo[] array = new AssentamentEntradaInfo[]{entrada};
            assentament.setAssentamentEntrada(array);
            try {
                retAss = sarcat.insertarAssentamentEntrada(assentament);
            }
            catch (RemoteException e) {
                this.getLogger().error((Object)"Error a l'insertar l'assentament d'entrada a s@rcat", (Throwable)e);
                throw new SarcatException(e, "exception.managerSarcat.excepcioInsertarAssentamentEntrada");
            }
            if (retAss.getError() != null) {
                this.getLogger().error((Object)("Error a l'insertar l'assentament d'entrada a S@RCAT: " + retAss.getError().getDescripcio() + " amb codi " + retAss.getError().getCodi() + " - descripci\u00f3 extesa: " + retAss.getError().getDescripcioExtesa()));
                throw new SarcatException("exception.managerSarcat.errorInsertarAssentamentEntrada", new Object[]{retAss.getError().getCodi(), retAss.getError().getDescripcio()});
            }
            AssentamentsRetornAssentamentRetorn resultRegistre = retAss.getAssentamentRetorn()[0];
            if (resultRegistre.getErrorAssentament() != null) {
                this.getLogger().error((Object)("Error en l'assentament de retorn de S@RCAT: " + resultRegistre.getErrorAssentament().getDescripcio() + " amb codi " + resultRegistre.getErrorAssentament().getCodi() + " - descripci\u00f3 extesa: " + resultRegistre.getErrorAssentament().getDescripcioExtesa()));
                throw new SarcatException("exception.managerSarcat.errorAssentamentRetorn", new Object[]{resultRegistre.getErrorAssentament().getCodi(), resultRegistre.getErrorAssentament().getDescripcio()});
            }
            long anyPK = resultRegistre.getAnyPK();
            String codiURPK = resultRegistre.getCodiURPK();
            long numPK = resultRegistre.getNumPK();
            if (numPK < 0L) {
                this.getLogger().error((Object)"El n\u00famero de registre retornat es menor que 0");
                throw new SarcatException("exception.managerSarcat.errorFormatInvalid");
            }
            res[0] = codiURPK + "E/" + this.formatNumber(numPK) + "/" + anyPK;
            res[1] = resultRegistre.getDataAlta();
            try {
                sarcat.logout(token);
            }
            catch (RemoteException e) {
                this.getLogger().error((Object)"No s'ha pogut fer logout contra el web service de s@rcat: ", (Throwable)e);
                throw new SarcatException(e, "exception.managerSarcat.errorLogout");
            }
        }
        catch (SarcatException ex) {
            this.getLogger().error((Object)("Error a l'insertar assentament d'entrada a s@rcat: " + ex.getMessage()));
            throw ex;
        }
        catch (Exception ex) {
            this.getLogger().error((Object)("Error a l'insertar assentament d'entrada a s@rcat: " + ex.getMessage()));
            throw new SarcatException(ex, "Error a l'insertar assentament d'entrada a s@rcat: " + ex.getMessage());
        }
        return res;
    }

    public String[] altaRegistroSalida(String empresa, String tramite, String tipoTramite) {
        String[] res = new String[2];
        try {
            AssentamentsRetorn retAss;
            Boolean entornoCliente = true;
            try {
                entornoCliente = PropertyUtil.getPropertyAsBoolean("entorno.cliente");
            }
            catch (ConfigurationServiceException e) {
                this.getLogger().error((Object)"Error al obtener la propiedad: entorno.cliente", (Throwable)e);
                throw e;
            }
            if (entornoCliente != null && !entornoCliente.booleanValue()) {
                SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                return new String[]{"RegSal" + System.currentTimeMillis(), df.format(new Date())};
            }
            ConnectorWSSoap sarcat = this.getConnector();
            String token = this.login();
            AltaAssentamentEntradaSortida assentament = new AltaAssentamentEntradaSortida();
            assentament.setToken(token);
            assentament.setUrUsuari(this.configSarcatBean.getUrUsuario());
            AssentamentSortidaInfo sortida = this.crearAssentamentSortidaEmpresaTelematic(empresa, tramite, tipoTramite);
            AssentamentSortidaInfo[] array = new AssentamentSortidaInfo[]{sortida};
            assentament.setAssentamentSortida(array);
            try {
                retAss = sarcat.insertarAssentamentSortida(assentament);
            }
            catch (RemoteException e) {
                this.getLogger().error((Object)"Error a l'insertar l'assentament de sortida a s@rcat", (Throwable)e);
                throw new SarcatException(e, "exception.managerSarcat.excepcioInsertarAssentamentSortida");
            }
            if (retAss.getError() != null) {
                this.getLogger().error((Object)("Error a l'insertar assentament de sortida a s@rcat: " + retAss.getError().getDescripcio() + " amb codi " + retAss.getError().getCodi() + " - Descripci\u00f3 extesa: " + retAss.getError().getDescripcioExtesa()));
                throw new SarcatException("exception.managerSarcat.errorInsertarAssentamentSortida", new Object[]{retAss.getError().getCodi(), retAss.getError().getDescripcio()});
            }
            AssentamentsRetornAssentamentRetorn resultRegistre = retAss.getAssentamentRetorn()[0];
            if (resultRegistre.getErrorAssentament() != null) {
                this.getLogger().error((Object)("Error en l'assentament de reton de S@RCAT: " + resultRegistre.getErrorAssentament().getDescripcio() + " amb codi " + resultRegistre.getErrorAssentament().getCodi() + " - descripci\u00f3 extesa: " + resultRegistre.getErrorAssentament().getDescripcioExtesa()));
                throw new SarcatException("exception.managerSarcat.errorAssentamentRetorn", new Object[]{resultRegistre.getErrorAssentament().getCodi(), resultRegistre.getErrorAssentament().getDescripcio()});
            }
            long anyPK = resultRegistre.getAnyPK();
            String codiURPK = resultRegistre.getCodiURPK();
            long numPK = resultRegistre.getNumPK();
            if (numPK < 0L) {
                this.getLogger().error((Object)"El n\u00famero de registre de sortida retornat es menor que 0");
                throw new SarcatException("exception.managerSarcat.errorFormatInvalid");
            }
            res[0] = codiURPK + "S/" + this.formatNumber(numPK) + "/" + anyPK;
            res[1] = resultRegistre.getDataAlta();
            try {
                sarcat.logout(token);
            }
            catch (RemoteException e) {
                this.getLogger().error((Object)"No s'ha pogut fer logout contra el web service de s@rcat: ", (Throwable)e);
                throw new SarcatException(e, "exception.managerSarcat.errorLogout");
            }
        }
        catch (SarcatException se) {
            throw se;
        }
        catch (Exception ex) {
            this.getLogger().error((Object)"Error en l'alta del registre de sortida", (Throwable)ex);
            throw new SarcatException(ex, "exception.managerSarcat.errorAltaRegSortida");
        }
        return res;
    }

    private ConnectorWSSoap getConnector() {
        return (ConnectorWSSoap)this.service.getWebService(SARCAT_WS_ID);
    }

    public void setService(WebServicesService service) {
        this.service = service;
    }

    private String formatNumber(long numPk) {
        DecimalFormatSymbols sym = new DecimalFormatSymbols();
        sym.setDecimalSeparator(',');
        sym.setGroupingSeparator('.');
        DecimalFormat nf = new DecimalFormat();
        nf.setDecimalFormatSymbols(sym);
        nf.setGroupingSize(3);
        nf.setMaximumFractionDigits(0);
        nf.setMinimumFractionDigits(0);
        String ret = nf.format(numPk);
        return ret.replace(".", "");
    }

    private AssentamentEntradaInfo crearAssentamentEntradaEmpresaTelematic(String nombreEmpresa, String tipoTramite) {
        AssentamentEntradaInfo aei = new AssentamentEntradaInfo();
        GregorianCalendar ara = new GregorianCalendar();
        aei.setAnyPK((long)ara.get(1));
        aei.setCodiURPK(this.configSarcatBean.getUrUsuario());
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        aei.setDataPresentacio(df.format(new Date()));
        if (tipoTramite.equals("1")) {
            aei.setAssumpte(SARCAT_ASSUMPTE_CE);
            aei.setIdAnnex(-1L);
        } else {
            aei.setIdAnnex(SARCAT_ANNEX_LLIURAT.longValue());
            if (tipoTramite.equals("2")) {
                aei.setAssumpte(SARCAT_ASSUMPTE_AE);
            }
            if (tipoTramite.equals("3")) {
                aei.setAssumpte(SARCAT_ASSUMPTE_PAE);
            }
            if (tipoTramite.equals("4")) {
                aei.setAssumpte(SARCAT_ASSUMPTE_PCE);
            }
            if (tipoTramite.equals("5")) {
                aei.setAssumpte(SARCAT_ASSUMPTE_B);
            }
            if (tipoTramite.equals("6")) {
                aei.setAssumpte(SARCAT_ASSUMPTE_CACE);
            }
            if (tipoTramite.equals("7")) {
                aei.setAssumpte(SARCAT_ASSUMPTE_CAAE);
            }
        }
        aei.setIdViaPresentacio(5L);
        aei.setIdTipusTramesa(2L);
        aei.setIdDocument(1L);
        aei.setDescripcio(nombreEmpresa);
        aei.setIdPoblacioProc(SARCAT_ID_POBLACIO_BARCELONA);
        aei.setIdCentreDestInterna(new Long(PropertyUtil.getProperty("sarcat.idCentre")).longValue());
        aei.setIdSuportFisic(3L);
        aei.setLda(-1);
        aei.setUrgent(-1);
        aei.setAnySort(-1L);
        aei.setIdCategoria(-1L);
        aei.setIdCentreDestExterna(-1L);
        aei.setIdCentreProcedencia(-1L);
        aei.setIdMotiuDiligencia(-1L);
        aei.setIdPlantilla(-1L);
        aei.setIdSubdivEspecifica(-1L);
        aei.setIdSubdivUniforme(-1L);
        aei.setIdVolum(-1L);
        aei.setNumEmergencia(-1L);
        aei.setNumPK(-1L);
        aei.setNumSort(-1L);
        return aei;
    }

    private AssentamentSortidaInfo crearAssentamentSortidaEmpresaTelematic(String nombreEmpresa, String tramite, String tipoTramite) {
        AssentamentSortidaInfo aei = new AssentamentSortidaInfo();
        String idViaTramesaTramitTelematic = PropertyUtil.getProperty("sarcat.id.via.tramesa.tramit.telematic");
        GregorianCalendar ara = new GregorianCalendar();
        Info info = new Info();
        info.setAnyPK((long)ara.get(1));
        info.setCodiURPK(this.configSarcatBean.getUrUsuario());
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        info.setDataPresentacio(df.format(new Date()));
        if (tipoTramite.equals("2")) {
            info.setAssumpte(SARCAT_ASSUMPTE_SORTIDA_CA);
        }
        if (tipoTramite.equals("3") || tipoTramite.equals("4")) {
            info.setAssumpte(SARCAT_ASSUMPTE_SORTIDA_PE);
        }
        if (tipoTramite.equals("6") || tipoTramite.equals("7")) {
            info.setAssumpte(SARCAT_ASSUMPTE_SORTIDA_CAAE);
        }
        info.setIdTipusTramesa(2L);
        info.setIdViaTramesa(new Long(idViaTramesaTramitTelematic).longValue());
        info.setDescripcio(nombreEmpresa);
        info.setCodiPoblacioDest(SARCAT_ID_POBLACIO_BARCELONA);
        info.setIdDocument(12L);
        info.setIdCentreProcedencia(new Long(PropertyUtil.getProperty("sarcat.idCentre")).longValue());
        info.setIdSuportFisic(3L);
        info.setUrgent(-1);
        info.setIdAnnex(-1L);
        info.setIdCategoria(-1L);
        info.setIdMotiuDiligencia(-1L);
        info.setIdPlantilla(-1L);
        info.setIdSubdivEspecifica(-1L);
        info.setIdSubdivUniforme(-1L);
        info.setIdCentreDestinacio(-1L);
        info.setNumPK(-1L);
        aei.setInfo(info);
        return aei;
    }
}

