/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.webservices.sarcat;

import es.capgemini.generalitat.common.webservices.sarcat.FilePropertyRuntimeEnvironmentKeyResolver;
import es.capgemini.generalitat.common.webservices.sarcat.RuntimeEnvironmentKeyResolver;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import net.gencat.ctti.canigo.services.logging.Log;
import net.gencat.ctti.canigo.services.logging.log4j.Log4JServiceImpl;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeEnvironmentPropertiesConfigurer
extends PropertyPlaceholderConfigurer
implements InitializingBean {
    private String defaultEnvironment;
    private RuntimeEnvironmentKeyResolver keyResolver;
    private Set<String> environments = Collections.emptySet();
    private Resource propertyLocation;
    private Log4JServiceImpl loggingService;
    private Log logger;

    public void afterPropertiesSet() throws IOException {
        if (this.keyResolver == null) {
            this.keyResolver = new FilePropertyRuntimeEnvironmentKeyResolver();
        }
        String environment = this.determineEnvironment();
        Resource propertiesLocation = this.createPropertiesResource(environment);
        this.setLocation(propertiesLocation);
    }

    private Resource createPropertiesResource(String environment) {
        String fileName = "sarcat-" + environment.toString().toLowerCase() + ".properties";
        return new ClassPathResource(fileName);
    }

    private String determineEnvironment() {
        String environment = this.keyResolver.resolveRuntimeEnvironmentKey();
        if (environment == null) {
            this.getLogger().warn((Object)("No se puede determinar el entorno en tiempo de ejecuci\u00f3n, usando entorno por defecto '" + this.defaultEnvironment + "'"));
            return this.defaultEnvironment;
        }
        return environment.toLowerCase();
    }

    public String getDefaultEnvironment() {
        return this.defaultEnvironment;
    }

    public void setDefaultEnvironment(String defaultEnvironment) {
        this.defaultEnvironment = defaultEnvironment;
    }

    public RuntimeEnvironmentKeyResolver getKeyResolver() {
        return this.keyResolver;
    }

    public void setKeyResolver(RuntimeEnvironmentKeyResolver keyResolver) {
        this.keyResolver = keyResolver;
    }

    public Set<String> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(Set<String> environments) {
        this.environments = environments;
    }

    public Resource getPropertyLocation() {
        return this.propertyLocation;
    }

    public void setPropertyLocation(Resource propertyLocation) {
        this.propertyLocation = propertyLocation;
    }

    public void setLoggingService(Log4JServiceImpl loggingService) {
        this.loggingService = loggingService;
        this.logger = this.loggingService.getLog(((Object)((Object)this)).getClass());
    }

    public Log getLogger() {
        return this.logger;
    }
}

