CREATE TABLE BATCH_JOB_INSTANCE  (
	JOB_INSTANCE_ID NUMBER(38)  PRIMARY KEY ,  
	VERSION NUMBER(38),  
	JOB_NAME VARCHAR2(100) NOT NULL , 
	JOB_KEY VARCHAR2(2500)
) ;

CREATE TABLE BATCH_JOB_EXECUTION  (
	JOB_EXECUTION_ID NUMBER(38)  PRIMARY KEY ,
	VERSION NUMBER(38),  
	JOB_INSTANCE_ID NUMBER(38) NOT NULL,
	START_TIME TIMESTAMP DEFAULT NULL, 
	END_TIME TIMESTAMP DEFAULT NULL,
	STATUS VARCHAR2(10),
	CONTINUABLE CHAR(1),
	EXIT_CODE VARCHAR2(20),
	EXIT_MESSAGE CLOB,
	constraint JOB_INSTANCE_EXECUTION_FK foreign key (JOB_INSTANCE_ID)
	references BATCH_JOB_INSTANCE(JOB_INSTANCE_ID)
) ;
	
CREATE TABLE BATCH_JOB_PARAMS  (
	JOB_INSTANCE_ID NUMBER(38) NOT NULL ,
    TYPE_CD VARCHAR2(6) NOT NULL ,
	KEY_NAME VARCHAR2(100) NOT NULL , 
	STRING_VAL VARCHAR2(250) , 
	DATE_VAL TIMESTAMP DEFAULT NULL,
	LONG_VAL NUMBER(38) ,
	DOUBLE_VAL NUMBER,
	constraint JOB_INSTANCE_PARAMS_FK foreign key (JOB_INSTANCE_ID)
	references BATCH_JOB_INSTANCE(JOB_INSTANCE_ID)
) ;
	
CREATE TABLE BATCH_STEP_EXECUTION  (
	STEP_EXECUTION_ID NUMBER(38)  PRIMARY KEY ,
	VERSION NUMBER(38) NOT NULL,  
	STEP_NAME VARCHAR2(100) NOT NULL,
	JOB_EXECUTION_ID NUMBER(38) NOT NULL,
	START_TIME TIMESTAMP NOT NULL , 
	END_TIME TIMESTAMP DEFAULT NULL,  
	STATUS VARCHAR2(10),
	COMMIT_COUNT NUMBER(38) , 
	ITEM_COUNT NUMBER(38) , 
	CONTINUABLE CHAR(1),
	EXIT_CODE VARCHAR2(20),
	EXIT_MESSAGE CLOB,
	constraint JOB_EXECUTION_STEP_FK foreign key (JOB_EXECUTION_ID)
	references BATCH_JOB_EXECUTION(JOB_EXECUTION_ID)
) ;
	
CREATE TABLE BATCH_STEP_EXECUTION_CONTEXT  (
	STEP_EXECUTION_ID NUMBER(38) NOT NULL ,
    TYPE_CD VARCHAR2(6) NOT NULL ,
	KEY_NAME VARCHAR2(1000) NOT NULL , 
	STRING_VAL VARCHAR2(1000) , 
	DATE_VAL TIMESTAMP DEFAULT NULL ,
	LONG_VAL NUMBER(38) ,
	DOUBLE_VAL NUMBER ,
    OBJECT_VAL BLOB,
	constraint STEP_EXECUTION_CONTEXT_FK foreign key (STEP_EXECUTION_ID)
	references BATCH_STEP_EXECUTION(STEP_EXECUTION_ID)
) ;

CREATE SEQUENCE BATCH_STEP_EXECUTION_SEQ;
CREATE SEQUENCE BATCH_JOB_EXECUTION_SEQ;
CREATE SEQUENCE BATCH_JOB_SEQ;

CREATE INDEX IX_BATCH_JOB_INSTANCE_NAME_KEY  ON BATCH_JOB_INSTANCE   (JOB_NAME, JOB_KEY);
CREATE INDEX IX_BATCH_JOB_EXECUTION_INSTANC  ON BATCH_JOB_EXECUTION  (JOB_INSTANCE_ID);
CREATE INDEX IX_BATCH_STEP_EXEC_CONT_ID_NAM  ON BATCH_STEP_EXECUTION_CONTEXT (STEP_EXECUTION_ID, KEY_NAME);
CREATE INDEX IX_BATCH_STEP_EXECUTION_VERSIO  ON BATCH_STEP_EXECUTION (VERSION);
CREATE INDEX IX_BATCH_STEP_EXECUTION_ST_JEI ON BATCH_STEP_EXECUTION  (STEP_NAME, JOB_EXECUTION_ID);
