/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.client;

import io.atomix.catalyst.transport.Address;
import io.atomix.copycat.client.ServerSelectionStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum ServerSelectionStrategies implements ServerSelectionStrategy
{
    ANY{

        @Override
        public List<Address> selectConnections(Address leader, List<Address> servers) {
            Collections.shuffle(servers);
            return servers;
        }
    }
    ,
    LEADER{

        @Override
        public List<Address> selectConnections(Address leader, List<Address> servers) {
            if (leader != null) {
                return Collections.singletonList(leader);
            }
            Collections.shuffle(servers);
            return servers;
        }
    }
    ,
    FOLLOWERS{

        @Override
        public List<Address> selectConnections(Address leader, List<Address> servers) {
            Collections.shuffle(servers);
            if (leader != null) {
                ArrayList<Address> results = new ArrayList<Address>(servers.size());
                for (Address address : servers) {
                    if (address.equals((Object)leader)) continue;
                    results.add(address);
                }
                return results;
            }
            return servers;
        }
    };

}

