/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClientConfig;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.Mode;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.security.SslFactory;
import io.confluent.kafka.schemaregistry.utils.BoundedConcurrentHashMap;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedSchemaRegistryClient
implements SchemaRegistryClient {
    private static final Logger log = LoggerFactory.getLogger(CachedSchemaRegistryClient.class);
    private final RestService restService;
    private final int cacheCapacity;
    private final Map<String, Map<ParsedSchema, RegisterSchemaResponse>> schemaToResponseCache;
    private final Map<String, Map<ParsedSchema, Integer>> schemaToIdCache;
    private final Map<String, Map<Integer, ParsedSchema>> idToSchemaCache;
    private final Map<String, Map<ParsedSchema, Integer>> schemaToVersionCache;
    private final Map<String, Map<Integer, Schema>> versionToSchemaCache;
    private final Cache<String, SchemaMetadata> latestVersionCache;
    private final Cache<SubjectAndMetadata, SchemaMetadata> latestWithMetadataCache;
    private final Cache<SubjectAndSchema, Long> missingSchemaCache;
    private final Cache<SubjectAndInt, Long> missingIdCache;
    private final Cache<SubjectAndInt, Long> missingVersionCache;
    private final Map<String, SchemaProvider> providers;
    private final Ticker ticker;
    private static final String NO_SUBJECT = "";
    private static final int HTTP_NOT_FOUND = 404;
    private static final int VERSION_NOT_FOUND_ERROR_CODE = 40402;
    private static final int SCHEMA_NOT_FOUND_ERROR_CODE = 40403;
    public static final Map<String, String> DEFAULT_REQUEST_PROPERTIES = Collections.singletonMap("Content-Type", "application/vnd.schemaregistry.v1+json");

    public CachedSchemaRegistryClient(String baseUrl, int cacheCapacity) {
        this(new RestService(baseUrl), cacheCapacity);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int cacheCapacity) {
        this(new RestService(baseUrls), cacheCapacity);
    }

    public CachedSchemaRegistryClient(RestService restService, int cacheCapacity) {
        this(restService, cacheCapacity, null);
    }

    public CachedSchemaRegistryClient(String baseUrl, int cacheCapacity, Map<String, ?> originals) {
        this(baseUrl, cacheCapacity, originals, null);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int cacheCapacity, Map<String, ?> originals) {
        this(baseUrls, cacheCapacity, originals, null);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int cacheCapacity, List<SchemaProvider> providers, Map<String, ?> originals) {
        this(new RestService(baseUrls), cacheCapacity, providers, originals, null);
    }

    public CachedSchemaRegistryClient(String baseUrls, int identityMapCapacity, List<SchemaProvider> providers, Map<String, ?> originals) {
        this(new RestService(baseUrls), identityMapCapacity, providers, originals, null);
    }

    public CachedSchemaRegistryClient(RestService restService, int cacheCapacity, Map<String, ?> configs) {
        this(restService, cacheCapacity, null, configs, null);
    }

    public CachedSchemaRegistryClient(String baseUrl, int cacheCapacity, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(new RestService(baseUrl), cacheCapacity, null, originals, httpHeaders);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int cacheCapacity, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(new RestService(baseUrls), cacheCapacity, null, originals, httpHeaders);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int cacheCapacity, List<SchemaProvider> providers, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(new RestService(baseUrls), cacheCapacity, providers, originals, httpHeaders);
    }

    public CachedSchemaRegistryClient(RestService restService, int cacheCapacity, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(restService, cacheCapacity, null, originals, httpHeaders);
    }

    public CachedSchemaRegistryClient(RestService restService, int cacheCapacity, List<SchemaProvider> providers, Map<String, ?> configs, Map<String, String> httpHeaders) {
        this(restService, cacheCapacity, providers, configs, httpHeaders, Ticker.systemTicker());
    }

    public CachedSchemaRegistryClient(RestService restService, int cacheCapacity, List<SchemaProvider> providers, Map<String, ?> configs, Map<String, String> httpHeaders, Ticker ticker) {
        this.cacheCapacity = cacheCapacity;
        this.schemaToResponseCache = new BoundedConcurrentHashMap<String, Map<ParsedSchema, RegisterSchemaResponse>>(cacheCapacity);
        this.schemaToIdCache = new BoundedConcurrentHashMap<String, Map<ParsedSchema, Integer>>(cacheCapacity);
        this.idToSchemaCache = new BoundedConcurrentHashMap<String, Map<Integer, ParsedSchema>>(cacheCapacity);
        this.schemaToVersionCache = new BoundedConcurrentHashMap<String, Map<ParsedSchema, Integer>>(cacheCapacity);
        this.versionToSchemaCache = new BoundedConcurrentHashMap<String, Map<Integer, Schema>>(cacheCapacity);
        this.restService = restService;
        this.ticker = ticker;
        long latestTTL = SchemaRegistryClientConfig.getLatestTTL(configs);
        CacheBuilder latestVersionBuilder = CacheBuilder.newBuilder().maximumSize((long)cacheCapacity).ticker(ticker);
        if (latestTTL >= 0L) {
            latestVersionBuilder = latestVersionBuilder.expireAfterWrite(latestTTL, TimeUnit.SECONDS);
        }
        this.latestVersionCache = latestVersionBuilder.build();
        CacheBuilder latestWithMetadataBuilder = CacheBuilder.newBuilder().maximumSize((long)cacheCapacity).ticker(ticker);
        if (latestTTL >= 0L) {
            latestWithMetadataBuilder = latestWithMetadataBuilder.expireAfterWrite(latestTTL, TimeUnit.SECONDS);
        }
        this.latestWithMetadataCache = latestWithMetadataBuilder.build();
        long missingIdTTL = SchemaRegistryClientConfig.getMissingIdTTL(configs);
        long missingVersionTTL = SchemaRegistryClientConfig.getMissingVersionTTL(configs);
        long missingSchemaTTL = SchemaRegistryClientConfig.getMissingSchemaTTL(configs);
        int maxMissingCacheSize = SchemaRegistryClientConfig.getMaxMissingCacheSize(configs);
        this.missingSchemaCache = CacheBuilder.newBuilder().maximumSize((long)maxMissingCacheSize).ticker(ticker).expireAfterWrite(missingSchemaTTL, TimeUnit.SECONDS).build();
        this.missingIdCache = CacheBuilder.newBuilder().maximumSize((long)maxMissingCacheSize).ticker(ticker).expireAfterWrite(missingIdTTL, TimeUnit.SECONDS).build();
        this.missingVersionCache = CacheBuilder.newBuilder().maximumSize((long)maxMissingCacheSize).ticker(ticker).expireAfterWrite(missingVersionTTL, TimeUnit.SECONDS).build();
        this.providers = providers != null && !providers.isEmpty() ? providers.stream().collect(Collectors.toMap(SchemaProvider::schemaType, p -> p)) : Collections.singletonMap("AVRO", new AvroSchemaProvider());
        HashMap<String, CachedSchemaRegistryClient> schemaProviderConfigs = new HashMap<String, CachedSchemaRegistryClient>();
        schemaProviderConfigs.put("schemaVersionFetcher", this);
        for (SchemaProvider provider : this.providers.values()) {
            provider.configure(schemaProviderConfigs);
        }
        if (httpHeaders != null) {
            restService.setHttpHeaders(httpHeaders);
        }
        if (configs != null && !configs.isEmpty()) {
            Map<String, Object> restConfigs = configs.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).startsWith("schema.registry.") ? ((String)e.getKey()).substring("schema.registry.".length()) : (String)e.getKey(), Map.Entry::getValue, (existing, replacement) -> replacement));
            restService.configure(restConfigs);
            Map<String, Object> sslConfigs = configs.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("schema.registry.")).collect(Collectors.toMap(e -> ((String)e.getKey()).substring("schema.registry.".length()), Map.Entry::getValue));
            SslFactory sslFactory = new SslFactory(sslConfigs);
            if (sslFactory.sslContext() != null) {
                restService.setSslSocketFactory(sslFactory.sslContext().getSocketFactory());
                restService.setHostnameVerifier(this.getHostnameVerifier(sslConfigs));
            }
        }
    }

    @Override
    public Ticker ticker() {
        return this.ticker;
    }

    private HostnameVerifier getHostnameVerifier(Map<String, Object> config) {
        String sslEndpointIdentificationAlgo = (String)config.get("ssl.endpoint.identification.algorithm");
        if (sslEndpointIdentificationAlgo == null || sslEndpointIdentificationAlgo.equals("none") || sslEndpointIdentificationAlgo.isEmpty()) {
            return (hostname, session) -> true;
        }
        return null;
    }

    @Override
    public Optional<ParsedSchema> parseSchema(String schemaType, String schemaString, List<SchemaReference> references) {
        SchemaProvider schemaProvider;
        if (schemaType == null) {
            schemaType = "AVRO";
        }
        if ((schemaProvider = this.providers.get(schemaType)) == null) {
            log.error("Invalid schema type {}", (Object)schemaType);
            return Optional.empty();
        }
        return schemaProvider.parseSchema(schemaString, references);
    }

    @Override
    public Optional<ParsedSchema> parseSchema(Schema schema) {
        SchemaProvider schemaProvider;
        String schemaType = schema.getSchemaType();
        if (schemaType == null) {
            schemaType = "AVRO";
        }
        if ((schemaProvider = this.providers.get(schemaType)) == null) {
            log.error("Invalid schema type {}", (Object)schemaType);
            return Optional.empty();
        }
        return schemaProvider.parseSchema(schema, false, false);
    }

    public Map<String, SchemaProvider> getSchemaProviders() {
        return this.providers;
    }

    private RegisterSchemaResponse registerAndGetId(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest(schema);
        return this.restService.registerSchema(request, subject, normalize);
    }

    private RegisterSchemaResponse registerAndGetId(String subject, ParsedSchema schema, int version, int id, boolean normalize) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest(schema);
        request.setVersion(version);
        request.setId(id);
        return this.restService.registerSchema(request, subject, normalize);
    }

    protected ParsedSchema getSchemaByIdFromRegistry(int id, String subject) throws IOException, RestClientException {
        SchemaString restSchema;
        if (this.missingIdCache.getIfPresent((Object)new SubjectAndInt(subject, id)) != null) {
            throw new RestClientException("Schema " + id + " not found", 404, 40403);
        }
        try {
            restSchema = this.restService.getId(id, subject);
        }
        catch (RestClientException rce) {
            if (this.isSchemaNotFoundException(rce)) {
                this.missingIdCache.put((Object)new SubjectAndInt(subject, id), (Object)System.currentTimeMillis());
            }
            throw rce;
        }
        Optional<ParsedSchema> schema = this.parseSchema(new Schema(null, null, null, restSchema));
        return schema.orElseThrow(() -> new IOException("Invalid schema " + restSchema.getSchemaString() + " with refs " + restSchema.getReferences() + " of type " + restSchema.getSchemaType()));
    }

    private int getVersionFromRegistry(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        Schema response;
        this.checkMissingSchemaCache(subject, schema, normalize);
        try {
            RegisterSchemaRequest request = new RegisterSchemaRequest(schema);
            response = this.restService.lookUpSubjectVersion(request, subject, normalize, true);
        }
        catch (RestClientException rce) {
            if (this.isSchemaNotFoundException(rce)) {
                this.missingSchemaCache.put((Object)new SubjectAndSchema(subject, schema, normalize), (Object)System.currentTimeMillis());
            }
            throw rce;
        }
        return response.getVersion();
    }

    private int getIdFromRegistry(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        Schema response;
        this.checkMissingSchemaCache(subject, schema, normalize);
        try {
            RegisterSchemaRequest request = new RegisterSchemaRequest(schema);
            response = this.restService.lookUpSubjectVersion(request, subject, normalize, false);
        }
        catch (RestClientException rce) {
            if (this.isSchemaNotFoundException(rce)) {
                this.missingSchemaCache.put((Object)new SubjectAndSchema(subject, schema, normalize), (Object)System.currentTimeMillis());
            }
            throw rce;
        }
        return response.getId();
    }

    @Override
    public int register(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.register(subject, schema, 0, -1);
    }

    @Override
    public int register(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        return this.registerWithResponse(subject, schema, 0, -1, normalize).getId();
    }

    @Override
    public int register(String subject, ParsedSchema schema, int version, int id) throws IOException, RestClientException {
        return this.registerWithResponse(subject, schema, version, id, false).getId();
    }

    @Override
    public RegisterSchemaResponse registerWithResponse(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        return this.registerWithResponse(subject, schema, 0, -1, normalize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegisterSchemaResponse registerWithResponse(String subject, ParsedSchema schema, int version, int id, boolean normalize) throws IOException, RestClientException {
        Map schemaResponseMap = this.schemaToResponseCache.computeIfAbsent(subject, k -> new BoundedConcurrentHashMap(this.cacheCapacity));
        RegisterSchemaResponse cachedResponse = (RegisterSchemaResponse)schemaResponseMap.get(schema);
        if (cachedResponse != null && (id < 0 || id == cachedResponse.getId())) {
            return cachedResponse;
        }
        CachedSchemaRegistryClient cachedSchemaRegistryClient = this;
        synchronized (cachedSchemaRegistryClient) {
            cachedResponse = (RegisterSchemaResponse)schemaResponseMap.get(schema);
            if (cachedResponse != null && (id < 0 || id == cachedResponse.getId())) {
                return cachedResponse;
            }
            RegisterSchemaResponse retrievedResponse = id >= 0 ? this.registerAndGetId(subject, schema, version, id, normalize) : this.registerAndGetId(subject, schema, normalize);
            schemaResponseMap.put(schema, retrievedResponse);
            String context = CachedSchemaRegistryClient.toQualifiedContext(subject);
            Map idSchemaMap = this.idToSchemaCache.computeIfAbsent(context, k -> new BoundedConcurrentHashMap(this.cacheCapacity));
            idSchemaMap.put(retrievedResponse.getId(), schema);
            return retrievedResponse;
        }
    }

    @Override
    public ParsedSchema getSchemaById(int id) throws IOException, RestClientException {
        return this.getSchemaBySubjectAndId(NO_SUBJECT, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParsedSchema getSchemaBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        Map idSchemaMap;
        ParsedSchema cachedSchema;
        if (subject == null) {
            subject = NO_SUBJECT;
        }
        if ((cachedSchema = (ParsedSchema)(idSchemaMap = this.idToSchemaCache.computeIfAbsent(subject, k -> new BoundedConcurrentHashMap(this.cacheCapacity))).get(id)) != null) {
            return cachedSchema;
        }
        CachedSchemaRegistryClient cachedSchemaRegistryClient = this;
        synchronized (cachedSchemaRegistryClient) {
            cachedSchema = (ParsedSchema)idSchemaMap.get(id);
            if (cachedSchema != null) {
                return cachedSchema;
            }
            ParsedSchema retrievedSchema = this.getSchemaByIdFromRegistry(id, subject);
            idSchemaMap.put(id, retrievedSchema);
            return retrievedSchema;
        }
    }

    @Override
    public List<ParsedSchema> getSchemas(String subjectPrefix, boolean lookupDeletedSchema, boolean latestOnly) throws IOException, RestClientException {
        List<Schema> restSchemas = this.restService.getSchemas(subjectPrefix, lookupDeletedSchema, latestOnly);
        return restSchemas.stream().map(this::parseSchema).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getAllSubjectsById(int id) throws IOException, RestClientException {
        return this.restService.getAllSubjectsById(id);
    }

    @Override
    public Collection<SubjectVersion> getAllVersionsById(int id) throws IOException, RestClientException {
        return this.restService.getAllVersionsById(id);
    }

    @Override
    public Schema getByVersion(String subject, int version, boolean lookupDeletedSchema) {
        try {
            return this.getSchemaByVersion(subject, version, lookupDeletedSchema);
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema getSchemaByVersion(String subject, int version, boolean lookupDeletedSchema) throws IOException, RestClientException {
        Schema cachedSchema;
        Map versionSchemaMap = this.versionToSchemaCache.computeIfAbsent(subject, k -> new BoundedConcurrentHashMap(this.cacheCapacity));
        Schema schema = cachedSchema = lookupDeletedSchema ? (Schema)versionSchemaMap.get(version) : null;
        if (cachedSchema != null) {
            return cachedSchema;
        }
        CachedSchemaRegistryClient cachedSchemaRegistryClient = this;
        synchronized (cachedSchemaRegistryClient) {
            Schema schema2 = cachedSchema = lookupDeletedSchema ? (Schema)versionSchemaMap.get(version) : null;
            if (cachedSchema != null) {
                return cachedSchema;
            }
            Schema retrievedSchema = this.getSchemaByVersionFromRegistry(subject, version, lookupDeletedSchema);
            if (lookupDeletedSchema) {
                versionSchemaMap.put(version, retrievedSchema);
            }
            return retrievedSchema;
        }
    }

    private Schema getSchemaByVersionFromRegistry(String subject, int version, boolean lookupDeletedSchema) throws IOException, RestClientException {
        Schema restSchema;
        if (lookupDeletedSchema && this.missingVersionCache.getIfPresent((Object)new SubjectAndInt(subject, version)) != null) {
            throw new RestClientException("Version " + version + " not found", 404, 40402);
        }
        try {
            restSchema = this.restService.getVersion(subject, version, lookupDeletedSchema);
        }
        catch (RestClientException rce) {
            if (lookupDeletedSchema && this.isVersionNotFoundException(rce)) {
                this.missingVersionCache.put((Object)new SubjectAndInt(subject, version), (Object)System.currentTimeMillis());
            }
            throw rce;
        }
        return restSchema;
    }

    @Override
    public SchemaMetadata getSchemaMetadata(String subject, int version) throws IOException, RestClientException {
        return this.getSchemaMetadata(subject, version, false);
    }

    @Override
    public SchemaMetadata getSchemaMetadata(String subject, int version, boolean lookupDeletedSchema) throws IOException, RestClientException {
        Schema response = this.getSchemaByVersion(subject, version, lookupDeletedSchema);
        return new SchemaMetadata(response);
    }

    @Override
    public SchemaMetadata getLatestSchemaMetadata(String subject) throws IOException, RestClientException {
        SchemaMetadata schema = (SchemaMetadata)this.latestVersionCache.getIfPresent((Object)subject);
        if (schema != null) {
            return schema;
        }
        Schema response = this.restService.getLatestVersion(subject);
        schema = new SchemaMetadata(response);
        this.latestVersionCache.put((Object)subject, (Object)schema);
        return schema;
    }

    @Override
    public SchemaMetadata getLatestWithMetadata(String subject, Map<String, String> metadata, boolean lookupDeletedSchema) throws IOException, RestClientException {
        SubjectAndMetadata subjectAndMetadata = new SubjectAndMetadata(subject, metadata);
        SchemaMetadata schema = (SchemaMetadata)this.latestWithMetadataCache.getIfPresent((Object)subjectAndMetadata);
        if (schema != null) {
            return schema;
        }
        Schema response = this.restService.getLatestWithMetadata(subject, metadata, lookupDeletedSchema);
        schema = new SchemaMetadata(response);
        this.latestWithMetadataCache.put((Object)subjectAndMetadata, (Object)schema);
        return schema;
    }

    @Override
    public int getVersion(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.getVersion(subject, schema, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getVersion(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        Map schemaVersionMap = this.schemaToVersionCache.computeIfAbsent(subject, k -> new BoundedConcurrentHashMap(this.cacheCapacity));
        Integer cachedVersion = (Integer)schemaVersionMap.get(schema);
        if (cachedVersion != null) {
            return cachedVersion;
        }
        CachedSchemaRegistryClient cachedSchemaRegistryClient = this;
        synchronized (cachedSchemaRegistryClient) {
            cachedVersion = (Integer)schemaVersionMap.get(schema);
            if (cachedVersion != null) {
                return cachedVersion;
            }
            int retrievedVersion = this.getVersionFromRegistry(subject, schema, normalize);
            schemaVersionMap.put(schema, retrievedVersion);
            return retrievedVersion;
        }
    }

    @Override
    public List<Integer> getAllVersions(String subject) throws IOException, RestClientException {
        return this.restService.getAllVersions(subject);
    }

    @Override
    public List<Integer> getAllVersions(String subject, boolean lookupDeletedSchema) throws IOException, RestClientException {
        return this.restService.getAllVersions(RestService.DEFAULT_REQUEST_PROPERTIES, subject, lookupDeletedSchema);
    }

    @Override
    public int getId(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.getId(subject, schema, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getId(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        Map schemaIdMap = this.schemaToIdCache.computeIfAbsent(subject, k -> new BoundedConcurrentHashMap(this.cacheCapacity));
        Integer cachedId = (Integer)schemaIdMap.get(schema);
        if (cachedId != null) {
            return cachedId;
        }
        CachedSchemaRegistryClient cachedSchemaRegistryClient = this;
        synchronized (cachedSchemaRegistryClient) {
            cachedId = (Integer)schemaIdMap.get(schema);
            if (cachedId != null) {
                return cachedId;
            }
            int retrievedId = this.getIdFromRegistry(subject, schema, normalize);
            schemaIdMap.put(schema, retrievedId);
            String context = CachedSchemaRegistryClient.toQualifiedContext(subject);
            Map idSchemaMap = this.idToSchemaCache.computeIfAbsent(context, k -> new BoundedConcurrentHashMap(this.cacheCapacity));
            idSchemaMap.put(retrievedId, schema);
            return retrievedId;
        }
    }

    @Override
    public List<Integer> deleteSubject(String subject, boolean isPermanent) throws IOException, RestClientException {
        return this.deleteSubject(DEFAULT_REQUEST_PROPERTIES, subject, isPermanent);
    }

    @Override
    public synchronized List<Integer> deleteSubject(Map<String, String> requestProperties, String subject, boolean isPermanent) throws IOException, RestClientException {
        Objects.requireNonNull(subject, "subject");
        this.schemaToVersionCache.remove(subject);
        if (isPermanent) {
            this.versionToSchemaCache.remove(subject);
        }
        this.idToSchemaCache.remove(subject);
        this.schemaToIdCache.remove(subject);
        this.schemaToResponseCache.remove(subject);
        this.latestVersionCache.invalidate((Object)subject);
        this.latestWithMetadataCache.invalidateAll();
        return this.restService.deleteSubject(requestProperties, subject, isPermanent);
    }

    @Override
    public Integer deleteSchemaVersion(String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        return this.deleteSchemaVersion(DEFAULT_REQUEST_PROPERTIES, subject, version, isPermanent);
    }

    @Override
    public synchronized Integer deleteSchemaVersion(Map<String, String> requestProperties, String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        this.schemaToVersionCache.getOrDefault(subject, Collections.emptyMap()).values().remove(Integer.valueOf(version));
        if (isPermanent) {
            this.versionToSchemaCache.getOrDefault(subject, Collections.emptyMap()).remove(Integer.valueOf(version));
        }
        this.latestVersionCache.invalidate((Object)subject);
        this.latestWithMetadataCache.invalidateAll();
        return this.restService.deleteSchemaVersion(requestProperties, subject, version, isPermanent);
    }

    @Override
    public boolean testCompatibility(String subject, ParsedSchema schema) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest(schema);
        return this.restService.testCompatibility(request, subject, "latest", false, false).isEmpty();
    }

    @Override
    public List<String> testCompatibilityVerbose(String subject, ParsedSchema schema) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest(schema);
        return this.restService.testCompatibility(request, subject, "latest", false, true);
    }

    @Override
    public List<String> testCompatibilityVerbose(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest(schema);
        return this.restService.testCompatibility(request, subject, "latest", normalize, true);
    }

    @Override
    public Config updateConfig(String subject, Config config) throws IOException, RestClientException {
        ConfigUpdateRequest response = this.restService.updateConfig(new ConfigUpdateRequest(config), subject);
        return new Config(response);
    }

    @Override
    public Config getConfig(String subject) throws IOException, RestClientException {
        return this.restService.getConfig(subject);
    }

    @Override
    public void deleteConfig(String subject) throws IOException, RestClientException {
        this.restService.deleteConfig(subject);
    }

    @Override
    public String setMode(String mode) throws IOException, RestClientException {
        ModeUpdateRequest response = this.restService.setMode(mode);
        return response.getMode();
    }

    @Override
    public String setMode(String mode, String subject) throws IOException, RestClientException {
        ModeUpdateRequest response = this.restService.setMode(mode, subject);
        return response.getMode();
    }

    @Override
    public String setMode(String mode, String subject, boolean force) throws IOException, RestClientException {
        ModeUpdateRequest response = this.restService.setMode(mode, subject, force);
        return response.getMode();
    }

    @Override
    public String getMode() throws IOException, RestClientException {
        Mode response = this.restService.getMode();
        return response.getMode();
    }

    @Override
    public String getMode(String subject) throws IOException, RestClientException {
        Mode response = this.restService.getMode(subject);
        return response.getMode();
    }

    @Override
    public void deleteMode(String subject) throws IOException, RestClientException {
        this.restService.deleteSubjectMode(subject);
    }

    @Override
    public Collection<String> getAllContexts() throws IOException, RestClientException {
        return this.restService.getAllContexts();
    }

    @Override
    public Collection<String> getAllSubjects() throws IOException, RestClientException {
        return this.restService.getAllSubjects();
    }

    @Override
    public Collection<String> getAllSubjects(boolean lookupDeletedSubject) throws IOException, RestClientException {
        return this.restService.getAllSubjects(lookupDeletedSubject);
    }

    @Override
    public Collection<String> getAllSubjectsByPrefix(String subjectPrefix) throws IOException, RestClientException {
        return this.restService.getAllSubjects(subjectPrefix, false);
    }

    @Override
    public synchronized void reset() {
        this.schemaToResponseCache.clear();
        this.schemaToIdCache.clear();
        this.idToSchemaCache.clear();
        this.schemaToVersionCache.clear();
        this.versionToSchemaCache.clear();
        this.latestVersionCache.invalidateAll();
        this.latestWithMetadataCache.invalidateAll();
        this.missingSchemaCache.invalidateAll();
        this.missingIdCache.invalidateAll();
        this.missingVersionCache.invalidateAll();
    }

    @Override
    public void close() throws IOException {
        if (this.restService != null) {
            this.restService.close();
        }
    }

    private void checkMissingSchemaCache(String subject, ParsedSchema schema, boolean normalize) throws RestClientException {
        if (this.missingSchemaCache.getIfPresent((Object)new SubjectAndSchema(subject, schema, normalize)) != null) {
            throw new RestClientException("Schema not found", 404, 40403);
        }
    }

    private boolean isVersionNotFoundException(RestClientException rce) {
        return rce.getStatus() == 404 && rce.getErrorCode() == 40402;
    }

    private boolean isSchemaNotFoundException(RestClientException rce) {
        return rce.getStatus() == 404 && rce.getErrorCode() == 40403;
    }

    private static String toQualifiedContext(String subject) {
        QualifiedSubject qualifiedSubject = QualifiedSubject.create("default", subject);
        return qualifiedSubject != null ? qualifiedSubject.toQualifiedContext() : NO_SUBJECT;
    }

    static class SubjectAndMetadata {
        private final String subject;
        private final Map<String, String> metadata;

        public SubjectAndMetadata(String subject, Map<String, String> metadata) {
            this.subject = subject;
            this.metadata = ImmutableMap.copyOf(metadata);
        }

        public String subject() {
            return this.subject;
        }

        public Map<String, String> metadata() {
            return this.metadata;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubjectAndMetadata that = (SubjectAndMetadata)o;
            return Objects.equals(this.subject, that.subject) && Objects.equals(this.metadata, that.metadata);
        }

        public int hashCode() {
            return Objects.hash(this.subject, this.metadata);
        }

        public String toString() {
            return "SubjectAndMetadata{subject='" + this.subject + '\'' + ", metadata=" + this.metadata + '}';
        }
    }

    static class SubjectAndInt {
        private final String subject;
        private final int id;

        public SubjectAndInt(String subject, int id) {
            this.subject = subject;
            this.id = id;
        }

        public String subject() {
            return this.subject;
        }

        public int id() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubjectAndInt that = (SubjectAndInt)o;
            return Objects.equals(this.subject, that.subject) && this.id == that.id;
        }

        public int hashCode() {
            return Objects.hash(this.subject, this.id);
        }

        public String toString() {
            return "SubjectAndId{subject='" + this.subject + '\'' + ", id=" + this.id + '}';
        }
    }

    static class SubjectAndSchema {
        private final String subject;
        private final ParsedSchema schema;
        private final boolean normalize;

        public SubjectAndSchema(String subject, ParsedSchema schema, boolean normalize) {
            this.subject = subject;
            this.schema = schema;
            this.normalize = normalize;
        }

        public String subject() {
            return this.subject;
        }

        public ParsedSchema schema() {
            return this.schema;
        }

        public boolean normalize() {
            return this.normalize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubjectAndSchema that = (SubjectAndSchema)o;
            return Objects.equals(this.subject, that.subject) && this.schema.equals(that.schema) && this.normalize == that.normalize;
        }

        public int hashCode() {
            return Objects.hash(this.subject, this.schema, this.normalize);
        }

        public String toString() {
            return "SubjectAndSchema{subject='" + this.subject + '\'' + ", schema=" + this.schema + ", normalize=" + this.normalize + '}';
        }
    }
}

