/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.data.jpa;

import io.crnk.core.engine.information.bean.BeanAttributeInformation;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.internal.utils.PropertyUtils;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.registry.ResourceRegistryAware;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.IncludeFieldSpec;
import io.crnk.core.queryspec.IncludeRelationSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.ResourceRepository;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.core.resource.meta.HasMoreResourcesMetaInformation;
import io.crnk.core.resource.meta.MetaInformation;
import io.crnk.core.resource.meta.PagedMetaInformation;
import io.crnk.data.jpa.JpaRepositoryConfig;
import io.crnk.data.jpa.internal.JpaRepositoryBase;
import io.crnk.data.jpa.internal.JpaRepositoryUtils;
import io.crnk.data.jpa.internal.JpaRequestContext;
import io.crnk.data.jpa.mapping.JpaMapper;
import io.crnk.data.jpa.meta.internal.JpaMetaUtils;
import io.crnk.data.jpa.query.ComputedAttributeRegistry;
import io.crnk.data.jpa.query.JpaQuery;
import io.crnk.data.jpa.query.JpaQueryExecutor;
import io.crnk.data.jpa.query.JpaQueryFactory;
import io.crnk.data.jpa.query.Tuple;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;

public class JpaEntityRepositoryBase<T, I>
extends JpaRepositoryBase<T>
implements ResourceRepository<T, I>,
ResourceRegistryAware {
    private final BeanAttributeInformation primaryKeyAttribute;
    private ResourceRegistry resourceRegistry;

    public JpaEntityRepositoryBase(Class<T> entityClass) {
        this(JpaRepositoryConfig.create(entityClass));
    }

    public JpaEntityRepositoryBase(JpaRepositoryConfig<T> config) {
        super(config);
        this.primaryKeyAttribute = JpaMetaUtils.getUniquePrimaryKey(config.getEntityClass());
    }

    public JpaQueryFactory getQueryFactory() {
        return this.repositoryConfig.getQueryFactory();
    }

    public T findOne(I id, QuerySpec querySpec) {
        String idField = this.getIdField().getUnderlyingName();
        QuerySpec idQuerySpec = querySpec.clone();
        idQuerySpec.addFilter(new FilterSpec(Arrays.asList(idField), FilterOperator.EQ, id));
        ResourceList<T> results = this.findAll(idQuerySpec);
        return this.getUnique(results, id);
    }

    public ResourceList<T> findAll(Collection<I> ids, QuerySpec querySpec) {
        String idField = this.getIdField().getUnderlyingName();
        QuerySpec idQuerySpec = querySpec.clone();
        idQuerySpec.addFilter(new FilterSpec(Arrays.asList(idField), FilterOperator.EQ, ids));
        return this.findAll(idQuerySpec);
    }

    public ResourceList<T> findAll(QuerySpec querySpec) {
        Class<?> entityClass = this.repositoryConfig.getEntityClass();
        QuerySpec filteredQuerySpec = JpaRepositoryUtils.filterQuerySpec(this.repositoryConfig, this, querySpec);
        QuerySpec optimizedQuerySpec = this.optimizeQuerySpec(filteredQuerySpec);
        JpaQueryFactory queryFactory = this.repositoryConfig.getQueryFactory();
        JpaQuery<?> query = queryFactory.query(entityClass);
        query.setPrivateData(new JpaRequestContext(this, querySpec));
        this.configureQuery(query);
        ComputedAttributeRegistry computedAttributesRegistry = queryFactory.getComputedAttributes();
        Set<String> computedAttrs = computedAttributesRegistry.getForType(entityClass);
        JpaRepositoryUtils.prepareQuery(query, optimizedQuerySpec, computedAttrs);
        query = JpaRepositoryUtils.filterQuery(this.repositoryConfig, this, optimizedQuerySpec, query);
        JpaQueryExecutor<?> executor = this.createExecutor(query, optimizedQuerySpec);
        boolean fetchNext = this.isNextFetched(optimizedQuerySpec);
        boolean fetchTotal = this.isTotalFetched(optimizedQuerySpec);
        int limit = executor.getLimit();
        if (fetchNext) {
            executor.setLimit(limit + 1);
        }
        executor = JpaRepositoryUtils.filterExecutor(this.repositoryConfig, this, optimizedQuerySpec, executor);
        List<Tuple> tuples = executor.getResultTuples();
        Boolean hasNext = null;
        if (fetchNext && (hasNext = Boolean.valueOf((long)tuples.size() == querySpec.getLimit() + 1L)).booleanValue()) {
            tuples = tuples.subList(0, querySpec.getLimit().intValue());
        }
        tuples = JpaRepositoryUtils.filterTuples(this.repositoryConfig, this, optimizedQuerySpec, tuples);
        DefaultResourceList resources = this.repositoryConfig.newResultList();
        MetaInformation metaInfo = resources.getMeta();
        JpaRepositoryUtils.fillResourceList(this.repositoryConfig, tuples, resources);
        resources = JpaRepositoryUtils.filterResults(this.repositoryConfig, this, optimizedQuerySpec, resources);
        if (fetchTotal) {
            ((PagedMetaInformation)metaInfo).setTotalResourceCount(this.computeTotalCount(executor, tuples));
        }
        if (fetchNext) {
            ((HasMoreResourcesMetaInformation)metaInfo).setHasMoreResources(hasNext);
        }
        return resources;
    }

    protected Long computeTotalCount(JpaQueryExecutor<?> executor, List<Tuple> tuples) {
        int limit = executor.getLimit();
        int offset = executor.getOffset();
        if (limit == -1 || tuples.size() < limit) {
            return (long)offset + (long)tuples.size();
        }
        return executor.getTotalRowCount();
    }

    protected boolean isNextFetched(QuerySpec querySpec) {
        return this.repositoryConfig.isNextFetched(querySpec);
    }

    protected boolean isTotalFetched(QuerySpec querySpec) {
        return this.repositoryConfig.isTotalFetched(querySpec);
    }

    protected JpaQueryExecutor<?> createExecutor(JpaQuery<?> query, QuerySpec querySpec) {
        JpaQueryExecutor<?> executor = query.buildExecutor();
        if (this.optimizeForInclusion(querySpec)) {
            IncludeRelationSpec includedRelationSpec = (IncludeRelationSpec)querySpec.getIncludedRelations().get(0);
            executor.fetch(includedRelationSpec.getAttributePath());
        }
        JpaRepositoryUtils.prepareExecutor(executor, querySpec, this.fetchRelations());
        return executor;
    }

    protected void configureQuery(JpaQuery<?> query) {
    }

    protected QuerySpec optimizeQuerySpec(QuerySpec filteredQuerySpec) {
        QuerySpec clone = filteredQuerySpec.clone();
        String resourceType = filteredQuerySpec.getResourceType();
        RegistryEntry entry = resourceType != null ? this.resourceRegistry.getEntry(resourceType) : this.resourceRegistry.getEntry(filteredQuerySpec.getResourceClass());
        ResourceInformation resourceInformation = entry.getResourceInformation();
        List filters = clone.getFilters();
        for (FilterSpec filter : filters) {
            PathSpec path = filter.getPath();
            if (path == null || path.getElements().size() < 2) continue;
            List elements = path.getElements();
            String attr1 = (String)elements.get(elements.size() - 2);
            String attr2 = (String)elements.get(elements.size() - 1);
            ResourceField firstField = resourceInformation.findFieldByUnderlyingName(attr1);
            if (firstField == null || firstField.getResourceFieldType() != ResourceFieldType.RELATIONSHIP || !firstField.hasIdField() || !this.isRequestingOppositeId(firstField, attr2)) continue;
            PathSpec optimizedPath = PathSpec.of(elements.subList(0, elements.size() - 2)).append(firstField.getIdName());
            filter.setPath(optimizedPath);
        }
        return clone;
    }

    private boolean isRequestingOppositeId(ResourceField firstField, String requestedField) {
        String oppositeResourceType = firstField.getOppositeResourceType();
        ResourceInformation oppositeInformation = this.resourceRegistry.getEntry(oppositeResourceType).getResourceInformation();
        ResourceField oppositeField = oppositeInformation.findFieldByUnderlyingName(requestedField);
        return oppositeField.getResourceFieldType() == ResourceFieldType.ID;
    }

    private boolean optimizeForInclusion(QuerySpec querySpec) {
        ResourceField idField = this.getIdField();
        return querySpec.getIncludedRelations().size() == 1 && querySpec.getIncludedFields().size() == 1 && idField.getUnderlyingName().equals(((IncludeFieldSpec)querySpec.getIncludedFields().get(0)).getPath().toString());
    }

    protected boolean fetchRelations() {
        return false;
    }

    public <S extends T> S create(S resource) {
        return this.saveInternal(resource);
    }

    public <S extends T> S save(S resource) {
        return this.saveInternal(resource);
    }

    private <S extends T> S saveInternal(S resource) {
        JpaMapper mapper = this.repositoryConfig.getMapper();
        Object entity = mapper.unmap(resource);
        EntityManager em = this.getEntityManager();
        em.persist(entity);
        QuerySpec querySpec = new QuerySpec(this.repositoryConfig.getResourceClass());
        ResourceField idField = this.getIdField();
        Object id = idField.getAccessor().getValue(resource);
        if (id == null) {
            id = this.getIdFromEntity(em, entity, idField);
        }
        PreconditionUtil.verify((id != null ? 1 : 0) != 0, (String)"id not available for entity %s", (Object[])new Object[]{resource});
        return (S)this.findOne(id, querySpec);
    }

    protected I getIdFromEntity(EntityManager em, Object entity, ResourceField idField) {
        Object pk = em.getEntityManagerFactory().getPersistenceUnitUtil().getIdentifier(entity);
        PreconditionUtil.verify((pk != null ? 1 : 0) != 0, (String)"pk not available for entity %s", (Object[])new Object[]{entity});
        if (pk != null && this.primaryKeyAttribute.getName().equals(idField.getUnderlyingName()) && idField.getElementType().isAssignableFrom(pk.getClass())) {
            return (I)pk;
        }
        return null;
    }

    public void delete(I id) {
        Object pk;
        ResourceField idField = this.getIdField();
        if (idField.getUnderlyingName().equals(this.primaryKeyAttribute.getName())) {
            pk = id;
        } else {
            T resource = this.findOne(id, new QuerySpec(this.getResourceClass()));
            pk = PropertyUtils.getProperty(resource, (String)this.primaryKeyAttribute.getName());
            if (pk == null) {
                throw new IllegalStateException("no primary key available for type=" + this.getResourceClass().getSimpleName() + " id=" + id);
            }
        }
        EntityManager em = this.getEntityManager();
        Object object = em.find(this.repositoryConfig.getEntityClass(), pk);
        if (object != null) {
            em.remove(object);
        }
    }

    public Class<T> getResourceClass() {
        return this.repositoryConfig.getResourceClass();
    }

    public Class<?> getEntityClass() {
        return this.repositoryConfig.getEntityClass();
    }

    public void setResourceRegistry(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
    }

    public ResourceField getIdField() {
        RegistryEntry entry = this.resourceRegistry.getEntry(this.getResourceClass());
        ResourceInformation resourceInformation = entry.getResourceInformation();
        return resourceInformation.getIdField();
    }
}

