/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.data.jpa.internal;

import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.error.ErrorResponse;
import io.crnk.core.engine.error.ExceptionMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.exception.ConstraintViolationException;

public class HibernateConstraintViolationExceptionMapper
implements ExceptionMapper<ConstraintViolationException> {
    private static final String META_TYPE_KEY = "type";
    private static final String HIBERNATE_CONSTRAINT_VIOLATION_EXCEPTION = "HibernateConstraintViolation";

    public ErrorResponse toErrorResponse(ConstraintViolationException cve) {
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put(META_TYPE_KEY, HIBERNATE_CONSTRAINT_VIOLATION_EXCEPTION);
        ErrorData error = ErrorData.builder().setMeta(meta).setStatus(Integer.toString(422)).setCode(cve.getConstraintName()).setDetail(cve.getCause() != null ? cve.getCause().getMessage() : cve.getMessage()).build();
        return ErrorResponse.builder().setStatus(422).setSingleErrorData(error).build();
    }

    public ConstraintViolationException fromErrorResponse(ErrorResponse errorResponse) {
        Collection errors = errorResponse.getErrors();
        ErrorData error = (ErrorData)errors.iterator().next();
        String msg = error.getDetail();
        String constraintName = error.getCode();
        return new ConstraintViolationException(msg, null, constraintName);
    }

    public boolean accepts(ErrorResponse errorResponse) {
        if (errorResponse.getHttpStatus() != 422) {
            return false;
        }
        Collection errors = errorResponse.getErrors();
        Iterator iterator = errors.iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        ErrorData errorData = (ErrorData)iterator.next();
        Map meta = errorData.getMeta();
        return meta != null && HIBERNATE_CONSTRAINT_VIOLATION_EXCEPTION.equals(meta.get(META_TYPE_KEY));
    }
}

