/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.data.jpa.internal;

import com.fasterxml.jackson.databind.JsonNode;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.information.bean.BeanAttributeInformation;
import io.crnk.core.engine.information.bean.BeanInformation;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccess;
import io.crnk.core.engine.information.resource.ResourceFieldInformationProvider;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.information.resource.ResourceInformationProviderContext;
import io.crnk.core.engine.information.resource.ResourceInstanceBuilder;
import io.crnk.core.engine.information.resource.ResourceValidator;
import io.crnk.core.engine.internal.information.resource.DefaultResourceFieldInformationProvider;
import io.crnk.core.engine.internal.information.resource.DefaultResourceInstanceBuilder;
import io.crnk.core.engine.internal.information.resource.ResourceFieldImpl;
import io.crnk.core.engine.internal.information.resource.ResourceInformationProviderBase;
import io.crnk.core.engine.internal.jackson.JacksonResourceFieldInformationProvider;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.parser.StringMapper;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.properties.NullPropertiesProvider;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.queryspec.pagingspec.OffsetLimitPagingSpec;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import io.crnk.core.utils.Prioritizable;
import io.crnk.data.jpa.internal.JpaResourceFieldInformationProvider;
import io.crnk.data.jpa.meta.JpaMetaProvider;
import io.crnk.data.jpa.meta.MetaEntity;
import io.crnk.data.jpa.meta.MetaJpaDataObject;
import io.crnk.data.jpa.meta.MetaMappedSuperclass;
import io.crnk.data.jpa.meta.internal.JpaMetaUtils;
import io.crnk.meta.MetaLookupImpl;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaPrimaryKey;
import io.crnk.meta.model.MetaType;
import io.crnk.meta.provider.MetaProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EmbeddedId;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OptimisticLockException;

public class JpaResourceInformationProvider
extends ResourceInformationProviderBase
implements Prioritizable {
    private static final String ENTITY_NAME_SUFFIX = "Entity";
    private final JpaMetaProvider metaProvider = new JpaMetaProvider(Collections.emptySet());

    public JpaResourceInformationProvider() {
        this((PropertiesProvider)new NullPropertiesProvider());
    }

    public JpaResourceInformationProvider(PropertiesProvider propertiesProvider) {
        super(propertiesProvider, Arrays.asList(new ResourceFieldInformationProvider[]{new DefaultResourceFieldInformationProvider(), new JpaResourceFieldInformationProvider(), new JacksonResourceFieldInformationProvider()}));
        MetaLookupImpl lookup = new MetaLookupImpl();
        lookup.addProvider((MetaProvider)this.metaProvider);
        lookup.initialize();
    }

    public boolean accept(Class<?> resourceClass) {
        Object meta;
        if (JpaMetaUtils.isJpaType(resourceClass) && ((meta = this.metaProvider.discoverMeta(resourceClass)) instanceof MetaEntity || meta instanceof MetaMappedSuperclass && resourceClass.getAnnotation(JsonApiResource.class) != null)) {
            MetaJpaDataObject metaEntity = (MetaJpaDataObject)((Object)meta);
            MetaPrimaryKey primaryKey = metaEntity.getPrimaryKey();
            return primaryKey != null && primaryKey.getElements().size() == 1;
        }
        return false;
    }

    public ResourceInformation build(Class<?> resourceClass) {
        String resourceType = this.getResourceType(resourceClass);
        String resourcePath = this.getResourcePath(resourceClass);
        MetaDataObject meta = this.metaProvider.discoverMeta(resourceClass).asDataObject();
        DefaultResourceInstanceBuilder instanceBuilder = new DefaultResourceInstanceBuilder(resourceClass);
        BeanInformation beanInformation = BeanInformation.get(resourceClass);
        ResourceFieldAccess resourceAccess = this.getResourceAccess(resourceClass);
        List fields = this.getResourceFields(resourceClass, resourceAccess, false);
        this.handleIdOverride(resourceClass, fields);
        Class<?> superclass = resourceClass.getSuperclass();
        String superResourceType = superclass != Object.class && superclass.getAnnotation(MappedSuperclass.class) == null ? this.context.getResourceType(superclass) : null;
        TypeParser typeParser = this.context.getTypeParser();
        ResourceInformation information = new ResourceInformation(typeParser, resourceClass, resourceType, resourcePath, superResourceType, (ResourceInstanceBuilder)instanceBuilder, fields, OffsetLimitPagingSpec.class);
        information.setValidator((ResourceValidator)new JpaOptimisticLockingValidator(meta));
        information.setAccess(resourceAccess);
        information.setVersionRange(this.getVersionRange(resourceClass));
        ResourceField idField = information.getIdField();
        BeanAttributeInformation idAttr = beanInformation.getAttribute(idField.getUnderlyingName());
        if (idAttr.getAnnotation(EmbeddedId.class).isPresent()) {
            information.setIdStringMapper((StringMapper)new JpaIdMapper(meta));
        }
        return information;
    }

    private void handleIdOverride(Class<?> resourceClass, List<ResourceField> fields) {
        List idFields = fields.stream().filter(field -> field.getResourceFieldType() == ResourceFieldType.ID).collect(Collectors.toList());
        if (idFields.size() == 2) {
            ResourceField field0 = (ResourceField)idFields.get(0);
            ResourceField field1 = (ResourceField)idFields.get(1);
            BeanInformation beanInformation = BeanInformation.get(resourceClass);
            BeanAttributeInformation attr0 = beanInformation.getAttribute(field0.getUnderlyingName());
            BeanAttributeInformation attr1 = beanInformation.getAttribute(field1.getUnderlyingName());
            boolean jsonApiId0 = attr0.getAnnotation(JsonApiId.class).isPresent();
            boolean jsonApiId1 = attr1.getAnnotation(JsonApiId.class).isPresent();
            if (jsonApiId0 && !jsonApiId1) {
                ((ResourceFieldImpl)field1).setResourceFieldType(ResourceFieldType.ATTRIBUTE);
                ((ResourceFieldImpl)field1).setJsonName(this.getJsonName(attr1, ResourceFieldType.ATTRIBUTE));
            } else if (!jsonApiId0 && jsonApiId1) {
                ((ResourceFieldImpl)field0).setResourceFieldType(ResourceFieldType.ATTRIBUTE);
                ((ResourceFieldImpl)field0).setJsonName(this.getJsonName(attr0, ResourceFieldType.ATTRIBUTE));
            }
        }
    }

    public String getResourceType(Class<?> entityClass) {
        JsonApiResource annotation1 = entityClass.getAnnotation(JsonApiResource.class);
        if (annotation1 != null) {
            return annotation1.type();
        }
        if (entityClass.getAnnotation(MappedSuperclass.class) != null) {
            return null;
        }
        String name = entityClass.getSimpleName();
        if (name.endsWith(ENTITY_NAME_SUFFIX)) {
            name = name.substring(0, name.length() - ENTITY_NAME_SUFFIX.length());
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public String getResourcePath(Class<?> entityClass) {
        JsonApiResource annotation1 = entityClass.getAnnotation(JsonApiResource.class);
        if (annotation1 != null && !"".equals(annotation1.resourcePath())) {
            return annotation1.resourcePath();
        }
        return this.getResourceType(entityClass);
    }

    protected LookupIncludeBehavior getDefaultLookupIncludeBehavior(BeanAttributeInformation attr) {
        return LookupIncludeBehavior.AUTOMATICALLY_ALWAYS;
    }

    protected RelationshipRepositoryBehavior getDefaultRelationshipRepositoryBehavior(BeanAttributeInformation attributeDesc) {
        Optional oneToOne = attributeDesc.getAnnotation(OneToOne.class);
        Optional oneToMany = attributeDesc.getAnnotation(OneToMany.class);
        Optional manyToOne = attributeDesc.getAnnotation(ManyToOne.class);
        Optional manyToMany = attributeDesc.getAnnotation(ManyToMany.class);
        if (oneToOne.isPresent() || manyToOne.isPresent() || oneToMany.isPresent() || manyToMany.isPresent()) {
            Optional mappedBy = this.getMappedBy(attributeDesc);
            if (mappedBy.isPresent() && ((String)mappedBy.get()).length() > 0) {
                return RelationshipRepositoryBehavior.FORWARD_OPPOSITE;
            }
            return RelationshipRepositoryBehavior.FORWARD_OWNER;
        }
        return RelationshipRepositoryBehavior.DEFAULT;
    }

    public void init(ResourceInformationProviderContext context) {
        super.init(context);
    }

    public int getPriority() {
        return 90;
    }

    class JpaIdMapper
    implements StringMapper {
        private MetaDataObject jpaMeta;

        public JpaIdMapper(MetaDataObject jpaMeta) {
            this.jpaMeta = jpaMeta;
        }

        public String toString(Object input) {
            return this.jpaMeta.getPrimaryKey().toKeyString(input);
        }

        public Object parse(String input) {
            MetaPrimaryKey primaryKey = this.jpaMeta.getPrimaryKey();
            MetaAttribute attr = primaryKey.getUniqueElement();
            return this.fromKeyString(attr.getType(), input);
        }

        private Object fromKeyString(MetaType type, String idString) {
            if (type instanceof MetaDataObject && !JpaResourceInformationProvider.this.context.getTypeParser().supports(type.getImplementationClass())) {
                return this.parseEmbeddableString((MetaDataObject)type, idString);
            }
            return JpaResourceInformationProvider.this.context.getTypeParser().parse(idString, type.getImplementationClass());
        }

        private Object parseEmbeddableString(MetaDataObject embType, String idString) {
            String[] keyElements = idString.split("-");
            Object id = ClassUtils.newInstance((Class)embType.getImplementationClass());
            List embAttrs = embType.getAttributes();
            if (keyElements.length != embAttrs.size()) {
                throw new UnsupportedOperationException("failed to parse " + idString + " for " + embType.getId());
            }
            for (int i = 0; i < keyElements.length; ++i) {
                MetaAttribute embAttr = (MetaAttribute)embAttrs.get(i);
                Object idElement = this.fromKeyString(embAttr.getType(), keyElements[i]);
                embAttr.setValue(id, idElement);
            }
            return id;
        }
    }

    class JpaOptimisticLockingValidator
    implements ResourceValidator {
        private MetaDataObject jpaMeta;

        public JpaOptimisticLockingValidator(MetaDataObject jpaMeta) {
            this.jpaMeta = jpaMeta;
        }

        public void validate(Object entity, Document requestDocument) {
            this.checkOptimisticLocking(entity, (Resource)requestDocument.getSingleData().get());
        }

        private void checkOptimisticLocking(Object entity, Resource resource) {
            JsonNode versionNode;
            MetaAttribute versionAttr = this.jpaMeta.getVersionAttribute();
            if (versionAttr != null && (versionNode = (JsonNode)resource.getAttributes().get(versionAttr.getName())) != null) {
                Object requestVersion = JpaResourceInformationProvider.this.context.getTypeParser().parse(versionNode.asText(), versionAttr.getType().getImplementationClass());
                Object currentVersion = versionAttr.getValue(entity);
                if (!currentVersion.equals(requestVersion)) {
                    throw new OptimisticLockException(resource.getId() + " changed from version " + requestVersion + " to " + currentVersion);
                }
            }
        }
    }
}

