/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.data.jpa.internal;

import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.error.ErrorResponse;
import io.crnk.core.engine.error.ExceptionMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.persistence.OptimisticLockException;

public class OptimisticLockExceptionMapper
implements ExceptionMapper<OptimisticLockException> {
    private static final String META_TYPE_KEY = "type";
    private static final String JPA_OPTIMISTIC_LOCK_EXCEPTION_TYPE = "OptimisticLockException";
    private static final String ERROR_TYPE = "conflict";

    public ErrorResponse toErrorResponse(OptimisticLockException cve) {
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put(META_TYPE_KEY, JPA_OPTIMISTIC_LOCK_EXCEPTION_TYPE);
        ErrorData error = ErrorData.builder().setMeta(meta).setCode(ERROR_TYPE).setStatus(Integer.toString(409)).setDetail(cve.getMessage()).build();
        return ErrorResponse.builder().setStatus(409).setSingleErrorData(error).build();
    }

    public OptimisticLockException fromErrorResponse(ErrorResponse errorResponse) {
        Collection errors = errorResponse.getErrors();
        ErrorData error = (ErrorData)errors.iterator().next();
        String msg = error.getDetail();
        return new OptimisticLockException(msg);
    }

    public boolean accepts(ErrorResponse errorResponse) {
        if (errorResponse.getHttpStatus() != 409) {
            return false;
        }
        Collection errors = errorResponse.getErrors();
        Iterator iterator = errors.iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        ErrorData errorData = (ErrorData)iterator.next();
        Map meta = errorData.getMeta();
        return meta != null && JPA_OPTIMISTIC_LOCK_EXCEPTION_TYPE.equals(meta.get(META_TYPE_KEY));
    }
}

