/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.data.jpa.internal.query;

import io.crnk.core.queryspec.Direction;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.SortSpec;
import io.crnk.data.jpa.internal.query.AbstractJpaQueryImpl;
import io.crnk.data.jpa.internal.query.QueryUtil;
import io.crnk.data.jpa.internal.query.backend.JpaQueryBackend;
import io.crnk.data.jpa.meta.MetaEmbeddable;
import io.crnk.data.jpa.query.AnyTypeObject;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaAttributeFinder;
import io.crnk.meta.model.MetaAttributePath;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.model.MetaMapType;
import io.crnk.meta.model.MetaPrimaryKey;
import io.crnk.meta.model.MetaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.JoinType;

public class QuerySortBuilder<T, E, O> {
    protected JpaQueryBackend<?, O, ?, E> backend;
    protected AbstractJpaQueryImpl<T, ?> query;
    private MetaAttributeFinder attributeFinder;

    public QuerySortBuilder(AbstractJpaQueryImpl<T, ?> query, JpaQueryBackend<?, O, ?, E> backend, MetaAttributeFinder attributeFinder) {
        this.backend = backend;
        this.query = query;
        this.attributeFinder = attributeFinder;
    }

    public void applySortSpec() {
        List<SortSpec> sortSpecs = this.query.getSortSpecs();
        if (!sortSpecs.isEmpty()) {
            this.backend.setOrder(this.sortSpecListToArray());
        }
        Set<PathSpec> existingPaths = sortSpecs.stream().map(it -> it.getPath()).collect(Collectors.toSet());
        if (this.query.getEnsureTotalOrder() && !QueryUtil.hasTotalOrder(this.query.getMeta(), sortSpecs)) {
            List<O> totalOrderList = this.backend.getOrderList();
            MetaPrimaryKey primaryKey = this.query.getMeta().getPrimaryKey();
            if (primaryKey != null) {
                List primaryKeyElements = primaryKey.getElements();
                for (MetaAttribute primaryKeyElement : primaryKeyElements) {
                    this.sortSpecToOrder(new MetaAttributePath(new MetaAttribute[]{primaryKeyElement}), Direction.ASC, totalOrderList, existingPaths);
                }
            }
            this.backend.setOrder(totalOrderList);
        }
    }

    protected List<O> sortSpecListToArray() {
        ArrayList<O> orderList = new ArrayList<O>();
        for (SortSpec sortSpec : this.query.getSortSpecs()) {
            orderList.addAll(this.sortSpecToOrder(sortSpec));
        }
        return orderList;
    }

    private List<O> sortSpecToOrder(SortSpec sortSpec) {
        ArrayList orders = new ArrayList();
        MetaAttributePath path = this.query.getMeta().resolvePath(sortSpec.getAttributePath(), this.attributeFinder);
        this.sortSpecToOrder(path, sortSpec.getDirection(), orders, null);
        return orders;
    }

    private void sortSpecToOrder(MetaAttributePath path, Direction direction, List<O> orders, Set<PathSpec> existingPaths) {
        boolean anyType;
        PathSpec pathSpec = PathSpec.of((String)path.toString());
        if (existingPaths != null && existingPaths.contains(pathSpec)) {
            return;
        }
        MetaAttribute attr = path.getLast();
        MetaType valueType = attr.getType();
        if (valueType instanceof MetaMapType) {
            valueType = valueType.getElementType();
        }
        if (anyType = AnyTypeObject.class.isAssignableFrom(valueType.getImplementationClass())) {
            MetaDataObject anyMeta = valueType.asDataObject();
            for (MetaAttribute anyAttr : anyMeta.getAttributes()) {
                if (anyAttr.isDerived()) continue;
                E expr = this.backend.getAttribute(path.concat(new MetaAttribute[]{anyAttr}), JoinType.LEFT);
                orders.add(this.backend.newSort(expr, direction));
            }
        } else if (valueType instanceof MetaEmbeddable) {
            MetaEmbeddable embeddable = (MetaEmbeddable)valueType;
            ArrayList attributes = embeddable.getAttributes();
            if (this.query.alphabeticEmbeddableElementOrder) {
                attributes = new ArrayList(attributes);
                Collections.sort(attributes, Comparator.comparing(MetaElement::getName));
            }
            for (MetaAttribute embeddableAttr : attributes) {
                this.sortSpecToOrder(path.concat(new MetaAttribute[]{embeddableAttr}), direction, orders, existingPaths);
            }
        } else {
            E expr = this.backend.getAttribute(path, JoinType.LEFT);
            orders.add(this.backend.newSort(expr, direction));
        }
    }
}

