/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.data.jpa.internal.query.backend.criteria;

import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.queryspec.Direction;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.data.jpa.internal.query.JoinRegistry;
import io.crnk.data.jpa.internal.query.MetaComputedAttribute;
import io.crnk.data.jpa.internal.query.QueryUtil;
import io.crnk.data.jpa.internal.query.backend.JpaQueryBackend;
import io.crnk.data.jpa.internal.query.backend.criteria.JpaCriteriaQueryImpl;
import io.crnk.data.jpa.query.criteria.JpaCriteriaExpressionFactory;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaAttributePath;
import io.crnk.meta.model.MetaDataObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class JpaCriteriaQueryBackend<T>
implements JpaQueryBackend<From<?, ?>, Order, Predicate, Expression<?>> {
    private final String parentKey;
    protected CriteriaBuilder cb;
    private CriteriaQuery<T> criteriaQuery;
    private JoinRegistry<From<?, ?>, Expression<?>> joinHelper;
    private From<T, T> root;
    private Root<?> parentFrom;
    private JpaCriteriaQueryImpl<T> queryImpl;

    public JpaCriteriaQueryBackend(JpaCriteriaQueryImpl<T> query, EntityManager em, Class<T> clazz, MetaDataObject parentMeta, MetaAttribute parentAttr, String parentKey, boolean parentIdSelection) {
        this.queryImpl = query;
        this.parentKey = parentKey;
        this.cb = em.getCriteriaBuilder();
        this.criteriaQuery = this.cb.createQuery();
        if (parentMeta != null) {
            this.parentFrom = this.criteriaQuery.from(parentMeta.getImplementationClass());
            this.root = this.parentFrom.join(parentAttr.getName());
            this.joinHelper = new JoinRegistry(this, query);
            this.joinHelper.putJoin(new MetaAttributePath(new MetaAttribute[0]), this.root);
            if (parentIdSelection) {
                Expression<?> parentIdExpr = this.getParentIdExpression(parentAttr, parentKey);
                this.criteriaQuery.multiselect(Arrays.asList(parentIdExpr, this.root));
            } else {
                this.criteriaQuery.select(this.root);
            }
        } else {
            this.root = this.criteriaQuery.from(clazz);
            this.joinHelper = new JoinRegistry(this, query);
            this.joinHelper.putJoin(new MetaAttributePath(new MetaAttribute[0]), this.root);
            this.criteriaQuery.select(this.root);
        }
    }

    private Expression<?> getParentIdExpression(MetaAttribute parentAttr, String parentKey) {
        MetaDataObject parentEntity = parentAttr.getParent();
        return this.parentFrom.get(parentKey);
    }

    @Override
    public Expression<?> getAttribute(MetaAttributePath attrPath) {
        return this.joinHelper.getEntityAttribute(attrPath);
    }

    @Override
    public Expression<?> getAttribute(MetaAttributePath attrPath, JoinType defaultJoinType) {
        return this.joinHelper.getEntityAttribute(attrPath, defaultJoinType);
    }

    @Override
    public void addPredicate(Predicate predicate) {
        Predicate restriction = this.criteriaQuery.getRestriction();
        if (restriction != null) {
            this.criteriaQuery.where(new Predicate[]{restriction, predicate});
        } else {
            this.criteriaQuery.where((Expression)predicate);
        }
    }

    @Override
    public From<?, ?> getRoot() {
        return this.root;
    }

    @Override
    public void setOrder(List<Order> list) {
        this.criteriaQuery.orderBy(list);
    }

    @Override
    public List<Order> getOrderList() {
        List orderedList = this.criteriaQuery.getOrderList();
        if (orderedList != null) {
            return new ArrayList<Order>(this.criteriaQuery.getOrderList());
        }
        return new ArrayList<Order>();
    }

    @Override
    public Order newSort(Expression<?> expr, Direction dir) {
        if (dir == Direction.ASC) {
            return this.cb.asc(expr);
        }
        return this.cb.desc(expr);
    }

    @Override
    public void distinct() {
        this.criteriaQuery.distinct(true);
    }

    public CriteriaQuery<T> getCriteriaQuery() {
        return this.criteriaQuery;
    }

    @Override
    public void addParentPredicate(MetaAttribute primaryKeyAttr) {
        List parentIds = this.queryImpl.getParentIds();
        Path parentIdPath = this.parentFrom.get(this.parentKey);
        this.addPredicate(parentIdPath.in(new ArrayList(parentIds)));
    }

    @Override
    public boolean hasManyRootsFetchesOrJoins() {
        return QueryUtil.hasManyRootsFetchesOrJoins(this.criteriaQuery);
    }

    @Override
    public void addSelection(Expression<?> expression, String name) {
        Selection selection = this.criteriaQuery.getSelection();
        ArrayList<Object> newSelection = new ArrayList<Object>();
        if (selection != null) {
            if (selection.isCompoundSelection()) {
                newSelection.addAll(selection.getCompoundSelectionItems());
            } else {
                newSelection.add(selection);
            }
        }
        newSelection.add(expression);
        this.criteriaQuery.multiselect(newSelection);
    }

    @Override
    public Expression<?> getExpression(Order order) {
        return order.getExpression();
    }

    @Override
    public boolean containsRelation(Expression<?> expression) {
        return QueryUtil.containsRelation(expression);
    }

    public Predicate ilike(Expression<String> expr, String val) {
        return this.cb.like(this.cb.lower(expr), val.toLowerCase());
    }

    private Predicate negateIfNeeded(Predicate p, FilterOperator fc) {
        if (fc.equals((Object)FilterOperator.NEQ)) {
            return this.cb.not((Expression)p);
        }
        return p;
    }

    @Override
    public Predicate buildPredicate(FilterOperator operator, MetaAttributePath attrPath, Object value) {
        Expression<?> attr = this.getAttribute(attrPath);
        return this.buildPredicate(operator, attr, value);
    }

    public Predicate buildPredicate(FilterOperator operator, Expression<?> expressionObj, Object value) {
        Expression<?> expression = expressionObj;
        expression = this.handleConversions(expression, operator);
        return this.handle(expression, operator, value);
    }

    private Predicate handle(Expression expression, FilterOperator operator, Object value) {
        if (operator == FilterOperator.EQ || operator == FilterOperator.NEQ) {
            return this.handleEquals(expression, operator, value);
        }
        if (value instanceof Collection) {
            ArrayList<Predicate> pred = new ArrayList<Predicate>();
            for (Object element : (Collection)value) {
                pred.add(this.handle(expression, operator, element));
            }
            return this.or((List<Predicate>)pred);
        }
        if (operator == FilterOperator.LIKE) {
            return this.ilike((Expression<String>)expression, value.toString());
        }
        if (operator == FilterOperator.GT) {
            return this.cb.greaterThan(expression, (Comparable)value);
        }
        if (operator == FilterOperator.LT) {
            return this.cb.lessThan(expression, (Comparable)value);
        }
        if (operator == FilterOperator.GE) {
            return this.cb.greaterThanOrEqualTo(expression, (Comparable)value);
        }
        PreconditionUtil.verify((operator == FilterOperator.LE ? 1 : 0) != 0, (String)"unexpected operator %s", (Object[])new Object[]{operator});
        return this.cb.lessThanOrEqualTo(expression, (Comparable)value);
    }

    private Predicate handleEquals(Expression<?> expression, FilterOperator operator, Object value) {
        if (value instanceof List) {
            Predicate p = expression.in(((List)value).toArray());
            return this.negateIfNeeded(p, operator);
        }
        if (Collection.class.isAssignableFrom(expression.getJavaType())) {
            Predicate p = this.cb.literal(value).in(new Expression[]{expression});
            return this.negateIfNeeded(p, operator);
        }
        if (expression instanceof MapJoin) {
            Predicate p = this.cb.literal(value).in((Expression)((MapJoin)expression).value());
            return this.negateIfNeeded(p, operator);
        }
        if (value == null) {
            return this.negateIfNeeded(this.cb.isNull(expression), operator);
        }
        return this.negateIfNeeded(this.cb.equal(expression, value), operator);
    }

    private Expression<?> handleConversions(Expression<?> expression, FilterOperator operator) {
        if (expression.getJavaType() != String.class && operator == FilterOperator.LIKE) {
            return expression.as(String.class);
        }
        return expression;
    }

    @Override
    public Predicate and(List<Predicate> predicates) {
        return this.cb.and(predicates.toArray(new Predicate[predicates.size()]));
    }

    @Override
    public Predicate not(Predicate predicate) {
        return this.cb.not((Expression)predicate);
    }

    @Override
    public Predicate or(List<Predicate> predicates) {
        return this.cb.or(predicates.toArray(new Predicate[predicates.size()]));
    }

    @Override
    public Expression<?> joinMapValue(Expression<?> currentCriteriaPath, MetaAttribute pathElement, Object key) {
        MapJoin mapJoin = ((From)currentCriteriaPath).joinMap(pathElement.getName(), JoinType.LEFT);
        Predicate mapJoinCondition = this.cb.equal((Expression)mapJoin.key(), key);
        Predicate nullCondition = this.cb.isNull((Expression)mapJoin.key());
        this.addPredicate(this.cb.or((Expression)mapJoinCondition, (Expression)nullCondition));
        return mapJoin;
    }

    @Override
    public From joinMapRelation(From currentCriteriaPath, MetaAttribute pathElement, Object key) {
        MapJoin mapJoin = currentCriteriaPath.joinMap(pathElement.getName(), JoinType.LEFT);
        Predicate mapJoinCondition = this.cb.equal((Expression)mapJoin.key(), key);
        Predicate nullCondition = this.cb.isNull((Expression)mapJoin.key());
        this.addPredicate(this.cb.or((Expression)mapJoinCondition, (Expression)nullCondition));
        return mapJoin;
    }

    @Override
    public Class<?> getJavaElementType(Expression<?> currentCriteriaPath) {
        return currentCriteriaPath.getJavaType();
    }

    @Override
    public Expression<?> getAttribute(Expression<?> currentCriteriaPath, MetaAttribute pathElement) {
        if (pathElement instanceof MetaComputedAttribute) {
            MetaComputedAttribute projAttr = (MetaComputedAttribute)pathElement;
            JpaCriteriaExpressionFactory expressionFactory = (JpaCriteriaExpressionFactory)this.queryImpl.getComputedAttrs().get(projAttr);
            From from = (From)currentCriteriaPath;
            return expressionFactory.getExpression(from, this.getCriteriaQuery());
        }
        return ((Path)currentCriteriaPath).get(pathElement.getName());
    }

    @Override
    public Expression<?> joinSubType(Expression<?> currentCriteriaPath, Class<?> entityType) {
        return this.cb.treat((Path)currentCriteriaPath, entityType);
    }

    @Override
    public From<?, ?> doJoin(MetaAttribute targetAttr, JoinType joinType, From<?, ?> parent) {
        if (targetAttr instanceof MetaComputedAttribute) {
            MetaComputedAttribute projAttr = (MetaComputedAttribute)targetAttr;
            JpaCriteriaExpressionFactory expressionFactory = (JpaCriteriaExpressionFactory)this.queryImpl.getComputedAttrs().get(projAttr);
            return (From)expressionFactory.getExpression(parent, this.getCriteriaQuery());
        }
        return parent.join(targetAttr.getName(), joinType);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.cb;
    }
}

