/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.data.jpa.internal.query.backend.querydsl;

import io.crnk.data.jpa.query.criteria.JpaCriteriaTuple;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.persistence.TupleElement;

public class ObjectArrayTupleImpl
implements JpaCriteriaTuple {
    private Object[] data;
    private int numEntriesToIgnore;
    private Map<String, Integer> selectionBindings;

    public ObjectArrayTupleImpl(Object entity, Map<String, Integer> selectionBindings) {
        this.selectionBindings = selectionBindings;
        this.data = entity instanceof Object[] ? (Object[])entity : new Object[]{entity};
    }

    @Override
    public <T> T get(int index, Class<T> type) {
        return (T)this.data[index + this.numEntriesToIgnore];
    }

    public int size() {
        return this.data.length - this.numEntriesToIgnore;
    }

    public Object[] toArray() {
        if (this.numEntriesToIgnore > 0) {
            return Arrays.copyOfRange(this.data, this.numEntriesToIgnore, this.data.length);
        }
        return this.data;
    }

    @Override
    public <T> T get(String name, Class<T> clazz) {
        int index = this.selectionBindings.get(name);
        return this.get(index, clazz);
    }

    public <X> X get(TupleElement<X> element) {
        throw new UnsupportedOperationException();
    }

    public Object get(String name) {
        throw new UnsupportedOperationException();
    }

    public Object get(int index) {
        return this.get(index, Object.class);
    }

    public List<TupleElement<?>> getElements() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reduce(int numEntriesToIgnore) {
        this.numEntriesToIgnore = numEntriesToIgnore;
    }
}

