/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.data.jpa.meta;

import io.crnk.data.jpa.meta.MetaEmbeddable;
import io.crnk.data.jpa.meta.MetaEmbeddableAttribute;
import io.crnk.data.jpa.meta.MetaEntity;
import io.crnk.data.jpa.meta.MetaEntityAttribute;
import io.crnk.data.jpa.meta.MetaJpaDataObject;
import io.crnk.data.jpa.meta.MetaMappedSuperclass;
import io.crnk.data.jpa.meta.internal.JpaMetaFilter;
import io.crnk.data.jpa.meta.internal.JpaMetaPartition;
import io.crnk.meta.internal.MetaIdProvider;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.provider.MetaFilter;
import io.crnk.meta.provider.MetaPartition;
import io.crnk.meta.provider.MetaProviderBase;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;

public class JpaMetaProvider
extends MetaProviderBase {
    private final JpaMetaPartition partition;

    public JpaMetaProvider(Set<Class> jpaTypes) {
        this.partition = new JpaMetaPartition(jpaTypes, new MetaIdProvider());
    }

    public JpaMetaProvider(EntityManagerFactory entityManagerFactory) {
        this(JpaMetaProvider.toTypes(entityManagerFactory));
    }

    private static Set<Class> toTypes(EntityManagerFactory entityManagerFactory) {
        HashSet<Class> set = new HashSet<Class>();
        Set embeddables = entityManagerFactory.getMetamodel().getEmbeddables();
        for (EmbeddableType embeddable : embeddables) {
            set.add(embeddable.getJavaType());
        }
        Set entities = entityManagerFactory.getMetamodel().getEntities();
        for (EntityType entity : entities) {
            set.add(entity.getJavaType());
        }
        return set;
    }

    public Collection<MetaFilter> getFilters() {
        return Arrays.asList(new MetaFilter[]{new JpaMetaFilter(this.partition, this.context)});
    }

    public Collection<MetaPartition> getPartitions() {
        return Arrays.asList(new MetaPartition[]{this.partition});
    }

    public Set<Class<? extends MetaElement>> getMetaTypes() {
        HashSet<Class<? extends MetaElement>> set = new HashSet<Class<? extends MetaElement>>();
        set.add(MetaEntity.class);
        set.add(MetaEmbeddable.class);
        set.add(MetaMappedSuperclass.class);
        set.add(MetaEntityAttribute.class);
        set.add(MetaEmbeddableAttribute.class);
        set.add(MetaJpaDataObject.class);
        return set;
    }

    public boolean hasMeta(Class<?> clazz) {
        return this.partition.hasMeta(clazz);
    }

    public <T extends MetaElement> T getMeta(Class<?> clazz) {
        return (T)this.partition.getMeta(clazz);
    }

    public JpaMetaPartition getPartition() {
        return this.partition;
    }

    public <T extends MetaElement> T discoverMeta(final Class<?> clazz) {
        if (this.hasMeta(clazz)) {
            return this.getMeta(clazz);
        }
        return (T)((MetaElement)this.context.runDiscovery(new Callable<T>(){

            @Override
            public T call() {
                return (MetaElement)JpaMetaProvider.this.partition.allocateMetaElement(clazz).get();
            }
        }));
    }
}

