/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.service;

import io.fabric8.maven.docker.access.AuthConfig;
import io.fabric8.maven.docker.access.AuthConfigList;
import io.fabric8.maven.docker.access.CreateImageOptions;
import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.ImagePullPolicy;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.service.BuildXService;
import io.fabric8.maven.docker.service.ImagePullManager;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.helper.BuildArgResolver;
import io.fabric8.maven.docker.util.AuthConfigFactory;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.MojoParameters;
import io.fabric8.maven.docker.util.ProjectPaths;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Settings;

public class RegistryService {
    private final DockerAccess docker;
    private final QueryService queryService;
    private final BuildXService buildXService;
    private final Logger log;

    RegistryService(DockerAccess docker, QueryService queryService, BuildXService buildXService, Logger log) {
        this.docker = docker;
        this.queryService = queryService;
        this.buildXService = buildXService;
        this.log = log;
    }

    public void pushImages(ProjectPaths projectPaths, Collection<ImageConfiguration> imageConfigs, int retries, RegistryConfig registryConfig, boolean skipTag, BuildService.BuildContext buildContext) throws DockerAccessException, MojoExecutionException {
        for (ImageConfiguration imageConfig : imageConfigs) {
            BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
            if (buildConfig == null || buildConfig.skipPush()) {
                this.log.info("%s : Skipped pushing", imageConfig.getDescription());
                continue;
            }
            String name = imageConfig.getName();
            ImageName imageName = new ImageName(name);
            String configuredRegistry = EnvUtil.firstRegistryOf(imageName.getRegistry(), imageConfig.getRegistry(), registryConfig.getRegistry());
            BuildArgResolver buildArgResolver = new BuildArgResolver(this.log);
            Map<String, String> buildArgsFromExternalSources = buildArgResolver.resolveBuildArgs(buildContext);
            AuthConfig authConfigForLegacyPush = this.createAuthConfig(true, imageName.getUser(), configuredRegistry, registryConfig);
            AuthConfigList authConfigListForBuildXPush = RegistryService.createCompleteAuthConfigList(true, imageConfig, registryConfig, buildContext.getMojoParameters(), buildArgsFromExternalSources);
            if (imageConfig.isBuildX()) {
                this.buildXService.push(projectPaths, imageConfig, configuredRegistry, authConfigListForBuildXPush);
                continue;
            }
            this.dockerPush(retries, skipTag, buildConfig, name, configuredRegistry, authConfigForLegacyPush);
        }
    }

    private void dockerPush(int retries, boolean skipTag, BuildImageConfiguration buildConfig, String name, String configuredRegistry, AuthConfig authConfig) throws DockerAccessException {
        long start = System.currentTimeMillis();
        this.docker.pushImage(name, authConfig, configuredRegistry, retries);
        this.log.info("Pushed %s in %s", name, EnvUtil.formatDurationTill(start));
        if (!skipTag) {
            for (String tag : buildConfig.getTags()) {
                if (tag == null) continue;
                this.docker.pushImage(new ImageName(name, tag).getFullName(), authConfig, configuredRegistry, retries);
            }
        }
    }

    public void pullImageWithPolicy(String image, ImagePullManager pullManager, RegistryConfig registryConfig, BuildImageConfiguration buildImageConfiguration) throws DockerAccessException, MojoExecutionException {
        if (pullManager.hasAlreadyPulled(image)) {
            return;
        }
        if (!this.imageRequiresPull(this.queryService.hasImage(image), pullManager.getImagePullPolicy(), image)) {
            return;
        }
        ImageName imageName = new ImageName(image);
        long pullStartTime = System.currentTimeMillis();
        String actualRegistry = EnvUtil.firstRegistryOf(imageName.getRegistry(), registryConfig.getRegistry());
        CreateImageOptions createImageOptions = new CreateImageOptions(buildImageConfiguration != null ? buildImageConfiguration.getCreateImageOptions() : Collections.emptyMap()).fromImage(imageName.getNameWithoutTag(actualRegistry)).tag(imageName.getDigest() != null ? imageName.getDigest() : imageName.getTag());
        this.docker.pullImage(imageName.getFullName(), this.createAuthConfig(false, null, actualRegistry, registryConfig), actualRegistry, createImageOptions);
        this.log.info("Pulled %s in %s", imageName.getFullName(), EnvUtil.formatDurationTill(pullStartTime));
        pullManager.pulled(image);
        if (actualRegistry != null && !imageName.hasRegistry()) {
            this.docker.tag(imageName.getFullName(actualRegistry), image, false);
        }
    }

    public static AuthConfigList createCompleteAuthConfigList(boolean isPush, ImageConfiguration imageConfig, RegistryConfig registryConfig, MojoParameters mojoParameters, Map<String, String> buildArgsFromExternalSources) throws MojoExecutionException {
        ImageName imageName = new ImageName(imageConfig.getName());
        String configuredRegistry = EnvUtil.firstRegistryOf(imageName.getRegistry(), imageConfig.getRegistry(), registryConfig.getRegistry());
        AuthConfig authConfig = registryConfig.createAuthConfig(isPush, imageName.getUser(), configuredRegistry);
        AuthConfigList authConfigList = RegistryService.createAuthConfigListForBaseImages(imageConfig.getBuildConfiguration(), mojoParameters, configuredRegistry, registryConfig, buildArgsFromExternalSources);
        if (authConfig != null) {
            authConfigList.addAuthConfig(authConfig);
        }
        return authConfigList;
    }

    public static AuthConfigList createAuthConfigListForBaseImages(BuildImageConfiguration buildConfig, MojoParameters mojoParameters, String configuredRegistry, RegistryConfig registryConfig, Map<String, String> buildArgsFromExternalSources) throws MojoExecutionException {
        AuthConfigList authConfigList = new AuthConfigList();
        Set<String> fromRegistries = RegistryService.getRegistriesForPull(buildConfig, mojoParameters, buildArgsFromExternalSources);
        for (String fromRegistry : fromRegistries) {
            if (StringUtils.isNotBlank((CharSequence)configuredRegistry) && configuredRegistry.equalsIgnoreCase(fromRegistry)) continue;
            registryConfig.registry = fromRegistry;
            AuthConfig additionalAuth = registryConfig.createAuthConfig(false, null, fromRegistry);
            if (additionalAuth == null) continue;
            authConfigList.addAuthConfig(additionalAuth);
        }
        return authConfigList;
    }

    private static Set<String> getRegistriesForPull(BuildImageConfiguration buildConfig, MojoParameters mojoParameters, Map<String, String> buildArgsFromExternalSources) {
        HashSet<String> registries = new HashSet<String>();
        List<String> fromImages = BuildService.extractBaseFromDockerfile(buildConfig, mojoParameters, BuildService.prepareBuildArgs(buildArgsFromExternalSources, buildConfig));
        for (String fromImage : fromImages) {
            ImageName imageName = new ImageName(fromImage);
            if (!imageName.hasRegistry()) continue;
            registries.add(imageName.getRegistry());
        }
        return registries;
    }

    private boolean imageRequiresPull(boolean hasImage, ImagePullPolicy pullPolicy, String imageName) throws MojoExecutionException {
        if (pullPolicy == ImagePullPolicy.Never) {
            if (!hasImage) {
                throw new MojoExecutionException(String.format("No image '%s' found and pull policy 'Never' is set. Please chose another pull policy or pull the image yourself)", imageName));
            }
            return false;
        }
        if (!hasImage) {
            return true;
        }
        return pullPolicy == ImagePullPolicy.Always;
    }

    private AuthConfig createAuthConfig(boolean isPush, String user, String registry, RegistryConfig config) throws MojoExecutionException {
        return config.createAuthConfig(isPush, user, registry);
    }

    public static class RegistryConfig
    implements Serializable {
        private String registry;
        private Settings settings;
        private AuthConfigFactory authConfigFactory;
        private boolean skipExtendedAuth;
        private Map authConfig;

        public String getRegistry() {
            return this.registry;
        }

        public Settings getSettings() {
            return this.settings;
        }

        public AuthConfigFactory getAuthConfigFactory() {
            return this.authConfigFactory;
        }

        public boolean isSkipExtendedAuth() {
            return this.skipExtendedAuth;
        }

        public Map getAuthConfig() {
            return this.authConfig;
        }

        public AuthConfig createAuthConfig(boolean isPush, String user, String registry) throws MojoExecutionException {
            return this.authConfigFactory.createAuthConfig(isPush, this.skipExtendedAuth, this.authConfig, this.settings, user, registry);
        }

        public static class Builder {
            private RegistryConfig context;

            public Builder() {
                this.context = new RegistryConfig();
            }

            public Builder(RegistryConfig context) {
                this.context = context;
            }

            public Builder registry(String registry) {
                this.context.registry = registry;
                return this;
            }

            public Builder settings(Settings settings) {
                this.context.settings = settings;
                return this;
            }

            public Builder authConfigFactory(AuthConfigFactory authConfigFactory) {
                this.context.authConfigFactory = authConfigFactory;
                return this;
            }

            public Builder skipExtendedAuth(boolean skipExtendedAuth) {
                this.context.skipExtendedAuth = skipExtendedAuth;
                return this;
            }

            public Builder authConfig(Map authConfig) {
                this.context.authConfig = authConfig;
                return this;
            }

            public RegistryConfig build() {
                return this.context;
            }
        }
    }
}

