/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.service;

import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.assembly.DockerAssemblyManager;
import io.fabric8.maven.docker.log.LogOutputSpecFactory;
import io.fabric8.maven.docker.service.ContainerTracker;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.project.MavenProject;

@Singleton
@Named
public class ServiceHubFactory {
    private final ContainerTracker containerTracker = new ContainerTracker();
    @Inject
    protected BuildPluginManager pluginManager;
    @Inject
    protected DockerAssemblyManager dockerAssemblyManager;
    private LogOutputSpecFactory logOutputSpecFactory;

    public ServiceHub createServiceHub(MavenProject project, MavenSession session, DockerAccess access, Logger log, LogOutputSpecFactory logSpecFactory) {
        this.logOutputSpecFactory = logSpecFactory;
        return new ServiceHub(access, this.containerTracker, this.pluginManager, this.dockerAssemblyManager, project, session, log, logSpecFactory);
    }

    public LogOutputSpecFactory getLogOutputSpecFactory() {
        return this.logOutputSpecFactory;
    }
}

