/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.app.RunResult;
import io.gatling.app.RunResultProcessor;
import io.gatling.app.Runner;
import io.gatling.app.Runner$;
import io.gatling.app.cli.ArgsParser;
import io.gatling.app.cli.StatusCode;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.config.GatlingConfiguration$;
import io.gatling.core.scenario.Simulation;
import io.gatling.netty.util.Transports;
import io.netty.channel.EventLoopGroup;
import java.nio.file.FileSystems;
import java.util.concurrent.TimeUnit;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.collection.mutable.Map;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class Gatling$
implements StrictLogging {
    public static Gatling$ MODULE$;
    private final Logger logger;

    static {
        new Gatling$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void main(String[] args) {
        throw scala.sys.package$.MODULE$.exit(this.fromArgs(args, (Option<Class<Simulation>>)None$.MODULE$));
    }

    public int fromMap(Map<String, ?> overrides) {
        return this.start(overrides, (Option<Class<Simulation>>)None$.MODULE$);
    }

    public int fromArgs(String[] args, Option<Class<Simulation>> selectedSimulationClass) {
        int n;
        Either<Map<String, ?>, StatusCode> either = new ArgsParser(args).parseArguments();
        if (either instanceof Left) {
            Left left = (Left)either;
            Map overrides = (Map)left.value();
            n = this.start(overrides, selectedSimulationClass);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            StatusCode statusCode = (StatusCode)right.value();
            n = statusCode.code();
        } else {
            throw new MatchError(either);
        }
        return n;
    }

    private void terminateActorSystem(ActorSystem system, FiniteDuration timeout) {
        try {
            Future whenTerminated = system.terminate();
            Await$.MODULE$.result((Awaitable)whenTerminated, (Duration)timeout);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Could not terminate ActorSystem", e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            throw throwable;
        }
    }

    public int start(Map<String, ?> overrides, Option<Class<Simulation>> selectedSimulationClass) {
        int n;
        try {
            RunResult runResult;
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Starting");
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            FileSystems.getDefault();
            GatlingConfiguration configuration = GatlingConfiguration$.MODULE$.load(overrides);
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Configuration loaded");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            ActorSystem system = ActorSystem$.MODULE$.apply("GatlingSystem", GatlingConfiguration$.MODULE$.loadActorSystemConfiguration());
            EventLoopGroup eventLoopGroup = Transports.newEventLoopGroup((boolean)configuration.netty().useNativeTransport(), (int)0, (String)"gatling");
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("ActorSystem instantiated");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            try {
                try {
                    BoxedUnit boxedUnit4;
                    Runner runner = Runner$.MODULE$.apply(system, eventLoopGroup, configuration);
                    if (this.logger().underlying().isTraceEnabled()) {
                        this.logger().underlying().trace("Runner instantiated");
                        boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    runResult = runner.run(selectedSimulationClass);
                }
                catch (Throwable e) {
                    BoxedUnit boxedUnit5;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Run crashed", e);
                        boxedUnit5 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit5 = BoxedUnit.UNIT;
                    }
                    throw e;
                }
            }
            finally {
                eventLoopGroup.shutdownGracefully(0L, configuration.core().shutdownTimeout(), TimeUnit.MILLISECONDS);
                this.terminateActorSystem(system, new package.DurationLong(package$.MODULE$.DurationLong(configuration.core().shutdownTimeout())).milliseconds());
            }
            RunResult runResult2 = runResult;
            n = new RunResultProcessor(configuration).processRunResult(runResult2).code();
        }
        catch (Throwable throwable) {
            block30: {
                ILoggerFactory factory = LoggerFactory.getILoggerFactory();
                try {
                    factory.getClass().getMethod("stop", new Class[0]).invoke((Object)factory, new Object[0]);
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    if (throwable3 instanceof NoSuchMethodException) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block30;
                    }
                    Option option = NonFatal$.MODULE$.unapply(throwable3);
                    if (!option.isEmpty()) {
                        BoxedUnit boxedUnit;
                        Throwable ex = (Throwable)option.get();
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Logback failed to shutdown.", ex);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit6 = boxedUnit;
                        break block30;
                    }
                    throw throwable2;
                }
            }
            throw throwable;
        }
        int n2 = n;
        ILoggerFactory factory = LoggerFactory.getILoggerFactory();
        try {
            factory.getClass().getMethod("stop", new Class[0]).invoke((Object)factory, new Object[0]);
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (throwable4 instanceof NoSuchMethodException) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable4);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable ex = (Throwable)option.get();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Logback failed to shutdown.", ex);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit7 = boxedUnit;
            }
            throw throwable;
        }
        return n2;
    }

    private Gatling$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
    }
}

