/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import io.gatling.app.RunResult;
import io.gatling.app.cli.StatusCode;
import io.gatling.app.cli.StatusCode$AssertionsFailed$;
import io.gatling.app.cli.StatusCode$Success$;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.ReportsGenerator;
import io.gatling.charts.stats.LogFileReader;
import io.gatling.commons.stats.GeneralStatsSource;
import io.gatling.commons.stats.assertion.AssertionResult;
import io.gatling.commons.stats.assertion.AssertionValidator$;
import io.gatling.core.config.GatlingConfiguration;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001-4A\u0001C\u0005\u0007!!Aq\u0003\u0001B\u0001B\u0003%\u0001\u0004C\u0003!\u0001\u0011\u0005\u0011\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u00033\u0001\u0011%1\u0007C\u0003A\u0001\u0011%\u0011\tC\u0003F\u0001\u0011%a\tC\u0003S\u0001\u0011%1K\u0001\nSk:\u0014Vm];miB\u0013xnY3tg>\u0014(B\u0001\u0006\f\u0003\r\t\u0007\u000f\u001d\u0006\u0003\u00195\tqaZ1uY&twMC\u0001\u000f\u0003\tIwn\u0001\u0001\u0014\u0005\u0001\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g-A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u00033yi\u0011A\u0007\u0006\u00037q\taaY8oM&<'BA\u000f\f\u0003\u0011\u0019wN]3\n\u0005}Q\"\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003E\u0011\u0002\"a\t\u0001\u000e\u0003%AQa\u0006\u0002A\u0002a\t\u0001\u0003\u001d:pG\u0016\u001c8OU;o%\u0016\u001cX\u000f\u001c;\u0015\u0005\u001dj\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\n\u0003\r\u0019G.[\u0005\u0003Y%\u0012!b\u0015;biV\u001c8i\u001c3f\u0011\u0015q3\u00011\u00010\u0003%\u0011XO\u001c*fgVdG\u000f\u0005\u0002$a%\u0011\u0011'\u0003\u0002\n%Vt'+Z:vYR\f\u0011#\u001b8ji2{wMR5mKJ+\u0017\rZ3s)\t!t\bE\u0002\u0013k]J!AN\n\u0003\r=\u0003H/[8o!\tAT(D\u0001:\u0015\tQ4(A\u0003ti\u0006$8O\u0003\u0002=\u0017\u000511\r[1siNL!AP\u001d\u0003\u001b1{wMR5mKJ+\u0017\rZ3s\u0011\u0015qC\u00011\u00010\u0003a\u0011X\r]8siN<UM\\3sCRLwN\\#oC\ndW\rZ\u000b\u0002\u0005B\u0011!cQ\u0005\u0003\tN\u0011qAQ8pY\u0016\fg.A\bhK:,'/\u0019;f%\u0016\u0004xN\u001d;t)\t9%\n\u0005\u0002\u0013\u0011&\u0011\u0011j\u0005\u0002\u0005+:LG\u000fC\u0003L\r\u0001\u0007A*A\fsKB|'\u000f^:HK:,'/\u0019;j_:Le\u000e];ugB\u0011Q\nU\u0007\u0002\u001d*\u0011qjO\u0001\u0007e\u0016\u0004xN\u001d;\n\u0005Es%a\u0006*fa>\u0014Ho]$f]\u0016\u0014\u0018\r^5p]&s\u0007/\u001e;t\u0003%\u0011XO\\*uCR,8\u000f\u0006\u0002()\")Qk\u0002a\u0001-\u0006\u0001\u0012m]:feRLwN\u001c*fgVdGo\u001d\t\u0004/~\u0013gB\u0001-^\u001d\tIF,D\u0001[\u0015\tYv\"\u0001\u0004=e>|GOP\u0005\u0002)%\u0011alE\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0017M\u0001\u0003MSN$(B\u00010\u0014!\t\u0019\u0017.D\u0001e\u0015\t)g-A\u0005bgN,'\u000f^5p]*\u0011!h\u001a\u0006\u0003Q.\tqaY8n[>t7/\u0003\u0002kI\ny\u0011i]:feRLwN\u001c*fgVdG\u000f")
public final class RunResultProcessor {
    private final GatlingConfiguration configuration;

    public StatusCode processRunResult(RunResult runResult) {
        StatusCode statusCode;
        Option<LogFileReader> option = this.initLogFileReader(runResult);
        if (option instanceof Some) {
            Some some = (Some)option;
            LogFileReader reader = (LogFileReader)some.value();
            List assertionResults = AssertionValidator$.MODULE$.validateAssertions((GeneralStatsSource)reader);
            if (this.reportsGenerationEnabled()) {
                ReportsGenerationInputs reportsGenerationInputs = new ReportsGenerationInputs(runResult.runId(), reader, assertionResults);
                this.generateReports(reportsGenerationInputs);
            }
            statusCode = this.runStatus((List<AssertionResult>)assertionResults);
        } else {
            statusCode = StatusCode$Success$.MODULE$;
        }
        return statusCode;
    }

    private Option<LogFileReader> initLogFileReader(RunResult runResult) {
        None$ none$;
        if (this.reportsGenerationEnabled() || runResult.hasAssertions()) {
            Predef$.MODULE$.println((Object)"Parsing log file(s)...");
            LogFileReader logFileReader = new LogFileReader(runResult.runId(), this.configuration);
            Predef$.MODULE$.println((Object)"Parsing log file(s) done");
            none$ = new Some((Object)logFileReader);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private boolean reportsGenerationEnabled() {
        return this.configuration.core().directory().reportsOnly().isDefined() || this.configuration.data().fileDataWriterEnabled() && !this.configuration.charting().noReports();
    }

    private void generateReports(ReportsGenerationInputs reportsGenerationInputs) {
        Predef$.MODULE$.println((Object)"Generating reports...");
        long start = System.currentTimeMillis();
        Path indexFile = new ReportsGenerator(this.configuration).generateFor(reportsGenerationInputs);
        Predef$.MODULE$.println((Object)new StringBuilder(23).append("Reports generated in ").append((System.currentTimeMillis() - start) / 1000L).append("s.").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(32).append("Please open the following file: ").append(indexFile.toFile()).toString());
    }

    private StatusCode runStatus(List<AssertionResult> assertionResults) {
        boolean consolidatedAssertionResult = BoxesRunTime.unboxToBoolean((Object)assertionResults.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable & scala.Serializable)(isValid, assertionResult) -> BoxesRunTime.boxToBoolean((boolean)RunResultProcessor.$anonfun$runStatus$1(BoxesRunTime.unboxToBoolean((Object)isValid), assertionResult))));
        return consolidatedAssertionResult ? StatusCode$Success$.MODULE$ : StatusCode$AssertionsFailed$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$runStatus$1(boolean isValid, AssertionResult assertionResult) {
        Predef$.MODULE$.println((Object)new StringBuilder(3).append(assertionResult.message()).append(" : ").append(assertionResult.result()).toString());
        return isValid && assertionResult.result();
    }

    public RunResultProcessor(GatlingConfiguration configuration) {
        this.configuration = configuration;
    }
}

