/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.http;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.internal.ConfigUtil;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.ExporterBuilderUtil;
import io.opentelemetry.exporter.internal.TlsConfigHelper;
import io.opentelemetry.exporter.internal.auth.Authenticator;
import io.opentelemetry.exporter.internal.http.HttpExporter;
import io.opentelemetry.exporter.internal.http.HttpSender;
import io.opentelemetry.exporter.internal.http.HttpSenderProvider;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.sdk.common.export.RetryPolicy;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class HttpExporterBuilder<T extends Marshaler> {
    public static final long DEFAULT_TIMEOUT_SECS = 10L;
    private static final Logger LOGGER = Logger.getLogger(HttpExporterBuilder.class.getName());
    private final String exporterName;
    private final String type;
    private String endpoint;
    private long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);
    private boolean compressionEnabled = false;
    private boolean exportAsJson = false;
    @Nullable
    private Map<String, String> headers;
    private final TlsConfigHelper tlsConfigHelper = new TlsConfigHelper();
    @Nullable
    private RetryPolicy retryPolicy;
    private Supplier<MeterProvider> meterProviderSupplier = GlobalOpenTelemetry::getMeterProvider;
    @Nullable
    private Authenticator authenticator;

    public HttpExporterBuilder(String exporterName, String type, String defaultEndpoint) {
        this.exporterName = exporterName;
        this.type = type;
        this.endpoint = defaultEndpoint;
    }

    public HttpExporterBuilder<T> setTimeout(long timeout, TimeUnit unit) {
        this.timeoutNanos = unit.toNanos(timeout);
        return this;
    }

    public HttpExporterBuilder<T> setTimeout(Duration timeout) {
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public HttpExporterBuilder<T> setEndpoint(String endpoint) {
        URI uri = ExporterBuilderUtil.validateEndpoint(endpoint);
        this.endpoint = uri.toString();
        return this;
    }

    public HttpExporterBuilder<T> setCompression(String compressionMethod) {
        this.compressionEnabled = compressionMethod.equals("gzip");
        return this;
    }

    public HttpExporterBuilder<T> addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
        return this;
    }

    public HttpExporterBuilder<T> setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public HttpExporterBuilder<T> setTrustManagerFromCerts(byte[] trustedCertificatesPem) {
        this.tlsConfigHelper.setTrustManagerFromCerts(trustedCertificatesPem);
        return this;
    }

    public HttpExporterBuilder<T> setKeyManagerFromCerts(byte[] privateKeyPem, byte[] certificatePem) {
        this.tlsConfigHelper.setKeyManagerFromCerts(privateKeyPem, certificatePem);
        return this;
    }

    public HttpExporterBuilder<T> setSslContext(SSLContext sslContext, X509TrustManager trustManager) {
        this.tlsConfigHelper.setSslContext(sslContext, trustManager);
        return this;
    }

    public HttpExporterBuilder<T> setMeterProvider(MeterProvider meterProvider) {
        this.meterProviderSupplier = () -> meterProvider;
        return this;
    }

    public HttpExporterBuilder<T> setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public HttpExporterBuilder<T> exportAsJson() {
        this.exportAsJson = true;
        return this;
    }

    public HttpExporter<T> build() {
        Map<Object, Object> headers = this.headers == null ? Collections.emptyMap() : this.headers;
        Supplier<Map<String, String>> headerSupplier = () -> headers;
        HttpSenderProvider httpSenderProvider = HttpExporterBuilder.resolveHttpSenderProvider();
        HttpSender httpSender = httpSenderProvider.createSender(this.endpoint, this.compressionEnabled, this.exportAsJson ? "application/json" : "application/x-protobuf", this.timeoutNanos, headerSupplier, this.authenticator, this.retryPolicy, this.tlsConfigHelper.getSslContext(), this.tlsConfigHelper.getTrustManager());
        LOGGER.log(Level.FINE, "Using HttpSender: " + httpSender.getClass().getName());
        return new HttpExporter(this.exporterName, this.type, httpSender, this.meterProviderSupplier, this.exportAsJson);
    }

    private static HttpSenderProvider resolveHttpSenderProvider() {
        HashMap<String, HttpSenderProvider> httpSenderProviders = new HashMap<String, HttpSenderProvider>();
        for (HttpSenderProvider spi : ServiceLoader.load(HttpSenderProvider.class, HttpExporterBuilder.class.getClassLoader())) {
            httpSenderProviders.put(spi.getClass().getName(), spi);
        }
        if (httpSenderProviders.isEmpty()) {
            throw new IllegalStateException("No HttpSenderProvider found on classpath. Please add dependency on opentelemetry-exporter-sender-okhttp or opentelemetry-exporter-sender-jdk");
        }
        if (httpSenderProviders.size() == 1) {
            return (HttpSenderProvider)httpSenderProviders.values().stream().findFirst().get();
        }
        String configuredSender = ConfigUtil.getString((String)"io.opentelemetry.exporter.internal.http.HttpSenderProvider", (String)"");
        if (configuredSender.isEmpty()) {
            LOGGER.log(Level.WARNING, "Multiple HttpSenderProvider found. Please include only one, or specify preference setting io.opentelemetry.exporter.internal.http.HttpSenderProvider to the FQCN of the preferred provider.");
            return (HttpSenderProvider)httpSenderProviders.values().stream().findFirst().get();
        }
        if (httpSenderProviders.containsKey(configuredSender)) {
            return (HttpSenderProvider)httpSenderProviders.get(configuredSender);
        }
        throw new IllegalStateException("No HttpSenderProvider matched configured io.opentelemetry.exporter.internal.http.HttpSenderProvider: " + configuredSender);
    }
}

