/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jms.common;

import io.opentracing.propagation.TextMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;

public class JmsTextMapExtractAdapter
implements TextMap {
    private final Map<String, String> map = new HashMap<String, String>();

    public JmsTextMapExtractAdapter(Message message) {
        if (message == null) {
            return;
        }
        try {
            Enumeration enumeration = message.getPropertyNames();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    Object value = message.getObjectProperty(key);
                    if (!(value instanceof String)) continue;
                    this.map.put(this.decodeDash(key), (String)value);
                }
            }
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        return this.map.entrySet().iterator();
    }

    public void put(String key, String value) {
        throw new UnsupportedOperationException("JmsTextMapExtractAdapter should only be used with Tracer.extract()");
    }

    private String decodeDash(String key) {
        return key.replace("_$dash$_", "-");
    }
}

