/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jms.common;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.jms.common.TracingMessageUtils;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.slf4j.MDC;

public class TracingMessageListener
implements MessageListener {
    private final MessageListener messageListener;
    private final Tracer tracer;
    private final boolean traceInLog;

    public TracingMessageListener(MessageListener messageListener, Tracer tracer) {
        this(messageListener, tracer, false);
    }

    public TracingMessageListener(MessageListener messageListener, Tracer tracer, boolean traceInLog) {
        this.messageListener = messageListener;
        this.tracer = tracer;
        this.traceInLog = traceInLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        Span span = TracingMessageUtils.buildFollowingSpan(message, this.tracer);
        if (this.traceInLog && span != null) {
            MDC.put((String)"spanId", (String)span.context().toSpanId());
            MDC.put((String)"traceId", (String)span.context().toTraceId());
        }
        try (Scope ignored = this.tracer.activateSpan(span);){
            if (this.messageListener != null) {
                this.messageListener.onMessage(message);
            }
        }
        finally {
            span.finish();
            if (this.traceInLog) {
                MDC.remove((String)"spanId");
                MDC.remove((String)"traceId");
            }
        }
    }
}

