/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.spring.data2.connection;

import io.opentracing.contrib.redis.common.TracingConfiguration;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.spring.data2.connection.TracingRedisConnection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.data.redis.connection.ClusterInfo;
import org.springframework.data.redis.connection.RedisClusterCommands;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisClusterServerCommands;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.RedisClientInfo;

public class TracingRedisClusterConnection
extends TracingRedisConnection
implements RedisClusterConnection {
    private final RedisClusterConnection connection;
    private final TracingHelper helper;

    public TracingRedisClusterConnection(RedisClusterConnection connection, TracingConfiguration tracingConfiguration) {
        super((RedisConnection)connection, tracingConfiguration);
        this.connection = connection;
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public RedisClusterServerCommands serverCommands() {
        return this.connection.serverCommands();
    }

    public Iterable<RedisClusterNode> clusterGetNodes() {
        return (Iterable)this.helper.doInScope("CLUSTER NODES", () -> this.connection.clusterGetNodes());
    }

    public Collection<RedisClusterNode> clusterGetSlaves(RedisClusterNode master) {
        return (Collection)this.helper.doInScope("CLUSTER SLAVES", () -> this.connection.clusterGetSlaves(master));
    }

    public Map<RedisClusterNode, Collection<RedisClusterNode>> clusterGetMasterSlaveMap() {
        return (Map)this.helper.doInScope("CLUSTER MASTER-SLAVE-MAP", () -> this.connection.clusterGetMasterSlaveMap());
    }

    public Integer clusterGetSlotForKey(byte[] key) {
        return (Integer)this.helper.doInScope("CLUSTER KEYSLOT", () -> this.connection.clusterGetSlotForKey(key));
    }

    public RedisClusterNode clusterGetNodeForSlot(int slot) {
        return (RedisClusterNode)this.helper.doInScope("CLUSTER_NODE_FOR_SLOT", () -> this.connection.clusterGetNodeForSlot(slot));
    }

    public RedisClusterNode clusterGetNodeForKey(byte[] key) {
        return (RedisClusterNode)this.helper.doInScope("CLUSTER_NODE_FOR_KEY", () -> this.connection.clusterGetNodeForKey(key));
    }

    public ClusterInfo clusterGetClusterInfo() {
        return (ClusterInfo)this.helper.doInScope("CLUSTER INFO", () -> this.connection.clusterGetClusterInfo());
    }

    public void clusterAddSlots(RedisClusterNode node, int ... slots) {
        this.helper.doInScope("CLUSTER ADDSLOTS", () -> this.connection.clusterAddSlots(node, slots));
    }

    public void clusterAddSlots(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        this.helper.doInScope("CLUSTER ADDSLOTS", () -> this.connection.clusterAddSlots(node, range));
    }

    public Long clusterCountKeysInSlot(int slot) {
        return (Long)this.helper.doInScope("CLUSTER COUNTKEYSINSLOT", () -> this.connection.clusterCountKeysInSlot(slot));
    }

    public void clusterDeleteSlots(RedisClusterNode node, int ... slots) {
        this.helper.doInScope("CLUSTER DELSLOTS", () -> this.connection.clusterDeleteSlots(node, slots));
    }

    public void clusterDeleteSlotsInRange(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        this.helper.doInScope("CLUSTER DELSLOTS", () -> this.connection.clusterDeleteSlotsInRange(node, range));
    }

    public void clusterForget(RedisClusterNode node) {
        this.helper.doInScope("CLUSTER FORGET", () -> this.connection.clusterForget(node));
    }

    public void clusterMeet(RedisClusterNode node) {
        this.helper.doInScope("CLUSTER MEET", () -> this.connection.clusterMeet(node));
    }

    public void clusterSetSlot(RedisClusterNode node, int slot, RedisClusterCommands.AddSlots mode) {
        this.helper.doInScope("CLUSTER SETSLOT", () -> this.connection.clusterSetSlot(node, slot, mode));
    }

    public List<byte[]> clusterGetKeysInSlot(int slot, Integer count) {
        return (List)this.helper.doInScope("CLUSTER GETKEYSINSLOT", () -> this.connection.clusterGetKeysInSlot(slot, count));
    }

    public void clusterReplicate(RedisClusterNode master, RedisClusterNode slave) {
        this.helper.doInScope("CLUSTER REPLICATE", () -> this.connection.clusterReplicate(master, slave));
    }

    public String ping(RedisClusterNode node) {
        return (String)this.helper.doInScope("PING", () -> this.connection.ping(node));
    }

    public void bgReWriteAof(RedisClusterNode node) {
        this.helper.doInScope("BGREWRITEAOF", () -> this.connection.bgReWriteAof(node));
    }

    public void bgSave(RedisClusterNode node) {
        this.helper.doInScope("BGSAVE", () -> this.connection.bgSave(node));
    }

    public Long lastSave(RedisClusterNode node) {
        return (Long)this.helper.doInScope("LASTSAVE", () -> this.connection.lastSave(node));
    }

    public void save(RedisClusterNode node) {
        this.helper.doInScope("SAVE", () -> this.connection.save(node));
    }

    public Long dbSize(RedisClusterNode node) {
        return (Long)this.helper.doInScope("DBSIZE", () -> this.connection.dbSize(node));
    }

    public void flushDb(RedisClusterNode node) {
        this.helper.doInScope("FLUSHDB", () -> this.connection.flushDb(node));
    }

    public void flushAll(RedisClusterNode node) {
        this.helper.doInScope("FLUSHALL", () -> this.connection.flushAll(node));
    }

    public Properties info(RedisClusterNode node) {
        return (Properties)this.helper.doInScope("INFO", () -> this.connection.info(node));
    }

    public Properties info(RedisClusterNode node, String section) {
        return (Properties)this.helper.doInScope("INFO", () -> this.connection.info(node, section));
    }

    public Set<byte[]> keys(RedisClusterNode node, byte[] pattern) {
        return (Set)this.helper.doInScope("KEYS", () -> this.connection.keys(node, pattern));
    }

    public Cursor<byte[]> scan(RedisClusterNode node, ScanOptions options) {
        return (Cursor)this.helper.doInScope("SCAN", () -> this.connection.scan(node, options));
    }

    public byte[] randomKey(RedisClusterNode node) {
        return (byte[])this.helper.doInScope("RANDOMKEY", () -> this.connection.randomKey(node));
    }

    public <T> T execute(String command, byte[] key, Collection<byte[]> args) {
        return (T)this.helper.doInScope("EXECUTE", () -> this.connection.execute(command, key, args));
    }

    public void shutdown(RedisClusterNode node) {
        this.helper.doInScope("SHUTDOWN", () -> this.connection.shutdown(node));
    }

    public Properties getConfig(RedisClusterNode node, String pattern) {
        return (Properties)this.helper.doInScope("CONFIG GET", () -> this.connection.getConfig(node, pattern));
    }

    public void setConfig(RedisClusterNode node, String param, String value) {
        this.helper.doInScope("CONFIG SET", () -> this.connection.setConfig(node, param, value));
    }

    public void resetConfigStats(RedisClusterNode node) {
        this.helper.doInScope("CONFIG RESETSTAT", () -> this.connection.resetConfigStats(node));
    }

    public Long time(RedisClusterNode node) {
        return (Long)this.helper.doInScope("TIME", () -> this.connection.time(node));
    }

    public List<RedisClientInfo> getClientList(RedisClusterNode node) {
        return (List)this.helper.doInScope("CLIENT LIST", () -> this.connection.getClientList(node));
    }
}

