/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.spring.data2.connection;

import io.opentracing.contrib.redis.common.TracingConfiguration;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.spring.data2.connection.TracingRedisSentinelConnection;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataAccessException;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.RedisClientInfo;

public class TracingRedisConnection
implements RedisConnection {
    private final RedisConnection connection;
    private final TracingConfiguration tracingConfiguration;
    private final TracingHelper helper;

    public TracingRedisConnection(RedisConnection connection, TracingConfiguration tracingConfiguration) {
        this.connection = connection;
        this.tracingConfiguration = tracingConfiguration;
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public RedisGeoCommands geoCommands() {
        return this.connection.geoCommands();
    }

    public RedisHashCommands hashCommands() {
        return this.connection.hashCommands();
    }

    public RedisHyperLogLogCommands hyperLogLogCommands() {
        return this.connection.hyperLogLogCommands();
    }

    public RedisKeyCommands keyCommands() {
        return this.connection.keyCommands();
    }

    public RedisListCommands listCommands() {
        return this.connection.listCommands();
    }

    public RedisSetCommands setCommands() {
        return this.connection.setCommands();
    }

    public RedisScriptingCommands scriptingCommands() {
        return this.connection.scriptingCommands();
    }

    public RedisServerCommands serverCommands() {
        return this.connection.serverCommands();
    }

    public RedisStringCommands stringCommands() {
        return this.connection.stringCommands();
    }

    public RedisZSetCommands zSetCommands() {
        return this.connection.zSetCommands();
    }

    public void close() throws DataAccessException {
        this.connection.close();
    }

    public boolean isClosed() {
        return this.connection.isClosed();
    }

    public Object getNativeConnection() {
        return this.connection.getNativeConnection();
    }

    public boolean isQueueing() {
        return this.connection.isQueueing();
    }

    public boolean isPipelined() {
        return this.connection.isPipelined();
    }

    public void openPipeline() {
        this.connection.openPipeline();
    }

    public List<Object> closePipeline() throws RedisPipelineException {
        return this.connection.closePipeline();
    }

    public boolean isSubscribed() {
        return this.connection.isSubscribed();
    }

    public Subscription getSubscription() {
        return this.connection.getSubscription();
    }

    public RedisSentinelConnection getSentinelConnection() {
        return new TracingRedisSentinelConnection(this.connection.getSentinelConnection(), this.tracingConfiguration);
    }

    public Object execute(String command, byte[] ... args) {
        return this.helper.doInScope(command, () -> this.connection.execute(command, args));
    }

    public Boolean exists(byte[] key) {
        return (Boolean)this.helper.doInScope("EXISTS", key, () -> this.connection.exists(key));
    }

    public Long exists(byte[] ... keys) {
        return (Long)this.helper.doInScope("EXISTS", keys, () -> this.connection.exists((byte[][])new byte[0][]));
    }

    public Long del(byte[] ... keys) {
        return (Long)this.helper.doInScope("DEL", keys, () -> this.connection.del(keys));
    }

    public Long unlink(byte[] ... keys) {
        return (Long)this.helper.doInScope("UNLINK", keys, () -> this.connection.unlink((byte[][])new byte[0][]));
    }

    public DataType type(byte[] key) {
        return (DataType)this.helper.doInScope("TYPE", key, () -> this.connection.type(key));
    }

    public Long touch(byte[] ... keys) {
        return (Long)this.helper.doInScope("TOUCH", keys, () -> this.connection.touch((byte[][])new byte[0][]));
    }

    public Set<byte[]> keys(byte[] pattern) {
        return (Set)this.helper.doInScope("KEYS", () -> this.connection.keys(pattern));
    }

    public Cursor<byte[]> scan(ScanOptions options) {
        return (Cursor)this.helper.doInScope("SCAN", () -> this.connection.scan(options));
    }

    public byte[] randomKey() {
        return (byte[])this.helper.doInScope("RANDOMKEY", () -> this.connection.randomKey());
    }

    public void rename(byte[] sourceKey, byte[] targetKey) {
        this.helper.doInScope("RENAME", sourceKey, () -> this.connection.rename(sourceKey, targetKey));
    }

    public Boolean renameNX(byte[] sourceKey, byte[] targetKey) {
        return (Boolean)this.helper.doInScope("RENAMENX", sourceKey, () -> this.connection.renameNX(sourceKey, targetKey));
    }

    public Boolean expire(byte[] key, long seconds) {
        return (Boolean)this.helper.doInScope("EXPIRE", key, () -> this.connection.expire(key, seconds));
    }

    public Boolean pExpire(byte[] key, long millis) {
        return (Boolean)this.helper.doInScope("PEXPIRE", key, () -> this.connection.pExpire(key, millis));
    }

    public Boolean expireAt(byte[] key, long unixTime) {
        return (Boolean)this.helper.doInScope("EXPIREAT", key, () -> this.connection.expireAt(key, unixTime));
    }

    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        return (Boolean)this.helper.doInScope("PEXPIREAT", key, () -> this.connection.pExpireAt(key, unixTimeInMillis));
    }

    public Boolean persist(byte[] key) {
        return (Boolean)this.helper.doInScope("PERSIST", key, () -> this.connection.persist(key));
    }

    public Boolean move(byte[] key, int dbIndex) {
        return (Boolean)this.helper.doInScope("MOVE", key, () -> this.connection.move(key, dbIndex));
    }

    public Long ttl(byte[] key) {
        return (Long)this.helper.doInScope("TTL", key, () -> this.connection.ttl(key));
    }

    public Long ttl(byte[] key, TimeUnit timeUnit) {
        return (Long)this.helper.doInScope("TTL", key, () -> this.connection.ttl(key, timeUnit));
    }

    public Long pTtl(byte[] key) {
        return (Long)this.helper.doInScope("PTTL", key, () -> this.connection.pTtl(key));
    }

    public Long pTtl(byte[] key, TimeUnit timeUnit) {
        return (Long)this.helper.doInScope("PTTL", key, () -> this.connection.pTtl(key, timeUnit));
    }

    public List<byte[]> sort(byte[] key, SortParameters params) {
        return (List)this.helper.doInScope("SORT", key, () -> this.connection.sort(key, params));
    }

    public Long sort(byte[] key, SortParameters params, byte[] storeKey) {
        return (Long)this.helper.doInScope("SORT", key, () -> this.connection.sort(key, params, storeKey));
    }

    public byte[] dump(byte[] key) {
        return (byte[])this.helper.doInScope("DUMP", key, () -> this.connection.dump(key));
    }

    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue) {
        this.helper.doInScope("RESTORE", key, () -> this.connection.restore(key, ttlInMillis, serializedValue));
    }

    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue, boolean replace) {
        this.helper.doInScope("RESTORE", key, () -> this.connection.restore(key, ttlInMillis, serializedValue, replace));
    }

    public ValueEncoding encodingOf(byte[] key) {
        return (ValueEncoding)this.helper.doInScope("ENCODING", key, () -> this.connection.encodingOf(key));
    }

    public Duration idletime(byte[] key) {
        return (Duration)this.helper.doInScope("IDLETIME", key, () -> this.connection.idletime(key));
    }

    public Long refcount(byte[] key) {
        return (Long)this.helper.doInScope("REFCOUNT", key, () -> this.connection.refcount(key));
    }

    public byte[] get(byte[] key) {
        return (byte[])this.helper.doInScope("GET", key, () -> this.connection.get(key));
    }

    public byte[] getSet(byte[] key, byte[] value) {
        return (byte[])this.helper.doInScope("GETSET", key, () -> this.connection.getSet(key, value));
    }

    public List<byte[]> mGet(byte[] ... keys) {
        return (List)this.helper.doInScope("MGET", keys, () -> this.connection.mGet(keys));
    }

    public Boolean set(byte[] key, byte[] value) {
        return (Boolean)this.helper.doInScope("SET", key, () -> this.connection.set(key, value));
    }

    public Boolean set(byte[] key, byte[] value, Expiration expiration, RedisStringCommands.SetOption option) {
        return (Boolean)this.helper.doInScope("SET", key, () -> this.connection.set(key, value, expiration, option));
    }

    public Boolean setNX(byte[] key, byte[] value) {
        return (Boolean)this.helper.doInScope("SETNX", key, () -> this.connection.setNX(key, value));
    }

    public Boolean setEx(byte[] key, long seconds, byte[] value) {
        return (Boolean)this.helper.doInScope("SETEX", key, () -> this.connection.setEx(key, seconds, value));
    }

    public Boolean pSetEx(byte[] key, long milliseconds, byte[] value) {
        return (Boolean)this.helper.doInScope("PSETEX", key, () -> this.connection.pSetEx(key, milliseconds, value));
    }

    public Boolean mSet(Map<byte[], byte[]> tuple) {
        return (Boolean)this.helper.doInScope("MSET", () -> this.connection.mSet(tuple));
    }

    public Boolean mSetNX(Map<byte[], byte[]> tuple) {
        return (Boolean)this.helper.doInScope("MSETNX", () -> this.connection.mSetNX(tuple));
    }

    public Long incr(byte[] key) {
        return (Long)this.helper.doInScope("INCR", key, () -> this.connection.incr(key));
    }

    public Long incrBy(byte[] key, long value) {
        return (Long)this.helper.doInScope("INCRBY", key, () -> this.connection.incrBy(key, value));
    }

    public Double incrBy(byte[] key, double value) {
        return (Double)this.helper.doInScope("INCRBY", key, () -> this.connection.incrBy(key, value));
    }

    public Long decr(byte[] key) {
        return (Long)this.helper.doInScope("DECR", key, () -> this.connection.decr(key));
    }

    public Long decrBy(byte[] key, long value) {
        return (Long)this.helper.doInScope("DECRBY", key, () -> this.connection.decrBy(key, value));
    }

    public Long append(byte[] key, byte[] value) {
        return (Long)this.helper.doInScope("APPEND", key, () -> this.connection.append(key, value));
    }

    public byte[] getRange(byte[] key, long begin, long end) {
        return (byte[])this.helper.doInScope("GETRANGE", key, () -> this.connection.getRange(key, begin, end));
    }

    public void setRange(byte[] key, byte[] value, long offset) {
        this.helper.doInScope("SETRANGE", key, () -> this.connection.setRange(key, value, offset));
    }

    public Boolean getBit(byte[] key, long offset) {
        return (Boolean)this.helper.doInScope("GETBIT", key, () -> this.connection.getBit(key, offset));
    }

    public Boolean setBit(byte[] key, long offset, boolean value) {
        return (Boolean)this.helper.doInScope("SETBIT", key, () -> this.connection.setBit(key, offset, value));
    }

    public Long bitCount(byte[] key) {
        return (Long)this.helper.doInScope("BITCOUNT", key, () -> this.connection.bitCount(key));
    }

    public Long bitCount(byte[] key, long begin, long end) {
        return (Long)this.helper.doInScope("BITCOUNT", key, () -> this.connection.bitCount(key, begin, end));
    }

    public List<Long> bitField(byte[] key, BitFieldSubCommands subCommands) {
        return (List)this.helper.doInScope("BITFIELD", key, () -> this.connection.bitField(key, subCommands));
    }

    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        return (Long)this.helper.doInScope("BITOP", keys, () -> this.connection.bitOp(op, destination, keys));
    }

    public Long bitPos(byte[] key, boolean bit, Range<Long> range) {
        return (Long)this.helper.doInScope("BITPOS", key, () -> this.connection.bitPos(key, bit, range));
    }

    public Long strLen(byte[] key) {
        return (Long)this.helper.doInScope("STRLEN", key, () -> this.connection.strLen(key));
    }

    public Long rPush(byte[] key, byte[] ... values) {
        return (Long)this.helper.doInScope("RPUSH", key, () -> this.connection.rPush(key, values));
    }

    public Long lPush(byte[] key, byte[] ... values) {
        return (Long)this.helper.doInScope("LPUSH", key, () -> this.connection.lPush(key, values));
    }

    public Long rPushX(byte[] key, byte[] value) {
        return (Long)this.helper.doInScope("RPUSHX", key, () -> this.connection.rPushX(key, value));
    }

    public Long lPushX(byte[] key, byte[] value) {
        return (Long)this.helper.doInScope("LPUSHX", key, () -> this.connection.lPushX(key, value));
    }

    public Long lLen(byte[] key) {
        return (Long)this.helper.doInScope("LLEN", key, () -> this.connection.lLen(key));
    }

    public List<byte[]> lRange(byte[] key, long start, long end) {
        return (List)this.helper.doInScope("LRANGE", key, () -> this.connection.lRange(key, start, end));
    }

    public void lTrim(byte[] key, long start, long end) {
        this.helper.doInScope("LTRIM", key, () -> this.connection.lTrim(key, start, end));
    }

    public byte[] lIndex(byte[] key, long index) {
        return (byte[])this.helper.doInScope("LINDEX", key, () -> this.connection.lIndex(key, index));
    }

    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        return (Long)this.helper.doInScope("LINSERT", key, () -> this.connection.lInsert(key, where, pivot, value));
    }

    public void lSet(byte[] key, long index, byte[] value) {
        this.helper.doInScope("LSET", key, () -> this.connection.lSet(key, index, value));
    }

    public Long lRem(byte[] key, long count, byte[] value) {
        return (Long)this.helper.doInScope("LREM", key, () -> this.connection.lRem(key, count, value));
    }

    public byte[] lPop(byte[] key) {
        return (byte[])this.helper.doInScope("LPOP", key, () -> this.connection.lPop(key));
    }

    public byte[] rPop(byte[] key) {
        return (byte[])this.helper.doInScope("RPOP", key, () -> this.connection.rPop(key));
    }

    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        return (List)this.helper.doInScope("BLPOP", keys, () -> this.connection.bLPop(timeout, keys));
    }

    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        return (List)this.helper.doInScope("BRPOP", keys, () -> this.connection.bRPop(timeout, keys));
    }

    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        return (byte[])this.helper.doInScope("RPOPLPUSH", srcKey, () -> this.connection.rPopLPush(srcKey, dstKey));
    }

    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        return (byte[])this.helper.doInScope("BRPOPLPUSH", srcKey, () -> this.connection.bRPopLPush(timeout, srcKey, dstKey));
    }

    public Long sAdd(byte[] key, byte[] ... values) {
        return (Long)this.helper.doInScope("SADD", key, () -> this.connection.sAdd(key, values));
    }

    public Long sRem(byte[] key, byte[] ... values) {
        return (Long)this.helper.doInScope("SREM", key, () -> this.connection.sRem(key, values));
    }

    public byte[] sPop(byte[] key) {
        return (byte[])this.helper.doInScope("SPOP", key, () -> this.connection.sPop(key));
    }

    public List<byte[]> sPop(byte[] key, long count) {
        return (List)this.helper.doInScope("SPOP", key, () -> this.connection.sPop(key, count));
    }

    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        return (Boolean)this.helper.doInScope("SMOVE", srcKey, () -> this.connection.sMove(srcKey, destKey, value));
    }

    public Long sCard(byte[] key) {
        return (Long)this.helper.doInScope("SCARD", key, () -> this.connection.sCard(key));
    }

    public Boolean sIsMember(byte[] key, byte[] value) {
        return (Boolean)this.helper.doInScope("SISMEMBER", key, () -> this.connection.sIsMember(key, value));
    }

    public Set<byte[]> sInter(byte[] ... keys) {
        return (Set)this.helper.doInScope("SINTER", keys, () -> this.connection.sInter(keys));
    }

    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        return (Long)this.helper.doInScope("SINTERSTORE", keys, () -> this.connection.sInterStore(destKey, keys));
    }

    public Set<byte[]> sUnion(byte[] ... keys) {
        return (Set)this.helper.doInScope("SUNION", keys, () -> this.connection.sUnion(keys));
    }

    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        return (Long)this.helper.doInScope("SUNIONSTORE", keys, () -> this.connection.sUnionStore(destKey, keys));
    }

    public Set<byte[]> sDiff(byte[] ... keys) {
        return (Set)this.helper.doInScope("SDIFF", keys, () -> this.connection.sDiff(keys));
    }

    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        return (Long)this.helper.doInScope("SDIFFSTORE", keys, () -> this.connection.sDiffStore(destKey, keys));
    }

    public Set<byte[]> sMembers(byte[] key) {
        return (Set)this.helper.doInScope("SMEMBERS", key, () -> this.connection.sMembers(key));
    }

    public byte[] sRandMember(byte[] key) {
        return (byte[])this.helper.doInScope("SRANDMEMBER", key, () -> this.connection.sRandMember(key));
    }

    public List<byte[]> sRandMember(byte[] key, long count) {
        return (List)this.helper.doInScope("SRANDMEMBER", key, () -> this.connection.sRandMember(key, count));
    }

    public Cursor<byte[]> sScan(byte[] key, ScanOptions options) {
        return (Cursor)this.helper.doInScope("SSCAN", key, () -> this.connection.sScan(key, options));
    }

    public Boolean zAdd(byte[] key, double score, byte[] value) {
        return (Boolean)this.helper.doInScope("ZADD", key, () -> this.connection.zAdd(key, score, value));
    }

    public Long zAdd(byte[] key, Set<RedisZSetCommands.Tuple> tuples) {
        return (Long)this.helper.doInScope("ZADD", key, () -> this.connection.zAdd(key, tuples));
    }

    public Long zRem(byte[] key, byte[] ... values) {
        return (Long)this.helper.doInScope("ZREM", key, () -> this.connection.zRem(key, values));
    }

    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        return (Double)this.helper.doInScope("ZINCRBY", key, () -> this.connection.zIncrBy(key, increment, value));
    }

    public Long zRank(byte[] key, byte[] value) {
        return (Long)this.helper.doInScope("ZRANK", key, () -> this.connection.zRank(key, value));
    }

    public Long zRevRank(byte[] key, byte[] value) {
        return (Long)this.helper.doInScope("ZREVRANK", key, () -> this.connection.zRevRank(key, value));
    }

    public Set<byte[]> zRange(byte[] key, long start, long end) {
        return (Set)this.helper.doInScope("ZRANGE", key, () -> this.connection.zRange(key, start, end));
    }

    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        return (Set)this.helper.doInScope("ZREVRANGE", key, () -> this.connection.zRevRange(key, start, end));
    }

    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        return (Set)this.helper.doInScope("ZREVRANGE WITHSCORES", key, () -> this.connection.zRevRangeWithScores(key, start, end));
    }

    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        return (Set)this.helper.doInScope("ZRANGE WITHSCORES", key, () -> this.connection.zRangeWithScores(key, start, end));
    }

    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        return (Set)this.helper.doInScope("ZRANGEBYSCORE", key, () -> this.connection.zRangeByScore(key, min, max));
    }

    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return (Set)this.helper.doInScope("ZRANGEBYSCORE", key, () -> this.connection.zRangeByScore(key, min, max, offset, count));
    }

    public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        return (Set)this.helper.doInScope("ZRANGEBYSCORE", key, () -> this.connection.zRangeByScore(key, min, max));
    }

    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        return (Set)this.helper.doInScope("ZRANGEBYSCORE", key, () -> this.connection.zRangeByScore(key, range));
    }

    public Set<byte[]> zRangeByScore(byte[] key, String min, String max, long offset, long count) {
        return (Set)this.helper.doInScope("ZRANGEBYSCORE", key, () -> this.connection.zRangeByScore(key, min, max, offset, count));
    }

    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return (Set)this.helper.doInScope("ZRANGEBYSCORE", key, () -> this.connection.zRangeByScore(key, range, limit));
    }

    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range) {
        return (Set)this.helper.doInScope("ZRANGEBYSCORE WITHSCORES", key, () -> this.connection.zRangeByScoreWithScores(key, range));
    }

    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        return (Set)this.helper.doInScope("ZRANGEBYSCORE WITHSCORES", key, () -> this.connection.zRangeByScoreWithScores(key, min, max));
    }

    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return (Set)this.helper.doInScope("ZRANGEBYSCORE WITHSCORES", key, () -> this.connection.zRangeByScoreWithScores(key, min, max, offset, count));
    }

    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return (Set)this.helper.doInScope("ZRANGEBYSCORE WITHSCORES", key, () -> this.connection.zRangeByScoreWithScores(key, range, limit));
    }

    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        return (Set)this.helper.doInScope("ZREVRANGEBYSCORE", key, () -> this.connection.zRevRangeByScore(key, min, max));
    }

    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        return (Set)this.helper.doInScope("ZREVRANGEBYSCORE", key, () -> this.connection.zRevRangeByScore(key, range));
    }

    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return (Set)this.helper.doInScope("ZREVRANGEBYSCORE", key, () -> this.connection.zRevRangeByScore(key, min, max, offset, count));
    }

    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return (Set)this.helper.doInScope("ZREVRANGEBYSCORE", key, () -> this.connection.zRevRangeByScore(key, range, limit));
    }

    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        return (Set)this.helper.doInScope("ZREVRANGEBYSCORE WITHSCORES", key, () -> this.connection.zRevRangeByScoreWithScores(key, min, max));
    }

    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return (Set)this.helper.doInScope("ZREVRANGEBYSCORE WITHSCORES", key, () -> this.connection.zRevRangeByScoreWithScores(key, min, max, offset, count));
    }

    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range) {
        return (Set)this.helper.doInScope("ZREVRANGEBYSCORE WITHSCORES", key, () -> this.connection.zRevRangeByScoreWithScores(key, range));
    }

    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return (Set)this.helper.doInScope("ZREVRANGEBYSCORE WITHSCORES", key, () -> this.connection.zRevRangeByScoreWithScores(key, range, limit));
    }

    public Long zCount(byte[] key, double min, double max) {
        return (Long)this.helper.doInScope("ZCOUNT", key, () -> this.connection.zCount(key, min, max));
    }

    public Long zCount(byte[] key, RedisZSetCommands.Range range) {
        return (Long)this.helper.doInScope("ZCOUNT", key, () -> this.connection.zCount(key, range));
    }

    public Long zCard(byte[] key) {
        return (Long)this.helper.doInScope("ZCARD", key, () -> this.connection.zCard(key));
    }

    public Double zScore(byte[] key, byte[] value) {
        return (Double)this.helper.doInScope("ZSCORE", key, () -> this.connection.zScore(key, value));
    }

    public Long zRemRange(byte[] key, long start, long end) {
        return (Long)this.helper.doInScope("ZREMRANGE", key, () -> this.connection.zRemRange(key, start, end));
    }

    public Long zRemRangeByScore(byte[] key, double min, double max) {
        return (Long)this.helper.doInScope("ZREMRANGEBYSCORE", key, () -> this.connection.zRemRangeByScore(key, min, max));
    }

    public Long zRemRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        return (Long)this.helper.doInScope("ZREMRANGEBYSCORE", key, () -> this.connection.zRemRangeByScore(key, range));
    }

    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        return (Long)this.helper.doInScope("ZUNIONSTORE", () -> this.connection.zUnionStore(destKey, sets));
    }

    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        return (Long)this.helper.doInScope("ZUNIONSTORE", destKey, () -> this.connection.zUnionStore(destKey, aggregate, weights, sets));
    }

    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, byte[] ... sets) {
        return (Long)this.helper.doInScope("ZUNIONSTORE", destKey, () -> this.connection.zUnionStore(destKey, aggregate, weights, sets));
    }

    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        return (Long)this.helper.doInScope("ZINTERSTORE", destKey, () -> this.connection.zInterStore(destKey, sets));
    }

    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        return (Long)this.helper.doInScope("ZINTERSTORE", destKey, () -> this.connection.zInterStore(destKey, aggregate, weights, sets));
    }

    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, byte[] ... sets) {
        return (Long)this.helper.doInScope("ZINTERSTORE", destKey, () -> this.connection.zInterStore(destKey, aggregate, weights, sets));
    }

    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, ScanOptions options) {
        return (Cursor)this.helper.doInScope("ZSCAN", key, () -> this.connection.zScan(key, options));
    }

    public Set<byte[]> zRangeByLex(byte[] key) {
        return (Set)this.helper.doInScope("ZRANGEBYLEX", key, () -> this.connection.zRangeByLex(key));
    }

    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range) {
        return (Set)this.helper.doInScope("ZRANGEBYLEX", key, () -> this.connection.zRangeByLex(key, range));
    }

    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return (Set)this.helper.doInScope("ZRANGEBYLEX", key, () -> this.connection.zRangeByLex(key, range, limit));
    }

    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        return (Boolean)this.helper.doInScope("HSET", key, () -> this.connection.hSet(key, field, value));
    }

    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        return (Boolean)this.helper.doInScope("HSETNX", key, () -> this.connection.hSetNX(key, field, value));
    }

    public byte[] hGet(byte[] key, byte[] field) {
        return (byte[])this.helper.doInScope("HGET", key, () -> this.connection.hGet(key, field));
    }

    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        return (List)this.helper.doInScope("HMGET", key, () -> this.connection.hMGet(key, fields));
    }

    public void hMSet(byte[] key, Map<byte[], byte[]> hashes) {
        this.helper.doInScope("HMSET", key, () -> this.connection.hMSet(key, hashes));
    }

    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        return (Long)this.helper.doInScope("HINCRBY", key, () -> this.connection.hIncrBy(key, field, delta));
    }

    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        return (Double)this.helper.doInScope("HINCRBY", key, () -> this.connection.hIncrBy(key, field, delta));
    }

    public Boolean hExists(byte[] key, byte[] field) {
        return (Boolean)this.helper.doInScope("HEXISTS", key, () -> this.connection.hExists(key, field));
    }

    public Long hDel(byte[] key, byte[] ... fields) {
        return (Long)this.helper.doInScope("HDEL", key, () -> this.connection.hDel(key, fields));
    }

    public Long hLen(byte[] key) {
        return (Long)this.helper.doInScope("HLEN", key, () -> this.connection.hLen(key));
    }

    public Set<byte[]> hKeys(byte[] key) {
        return (Set)this.helper.doInScope("HKEYS", key, () -> this.connection.hKeys(key));
    }

    public List<byte[]> hVals(byte[] key) {
        return (List)this.helper.doInScope("HVALS", key, () -> this.connection.hVals(key));
    }

    public Map<byte[], byte[]> hGetAll(byte[] key) {
        return (Map)this.helper.doInScope("HGETALL", key, () -> this.connection.hGetAll(key));
    }

    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, ScanOptions options) {
        return (Cursor)this.helper.doInScope("HSCAN", key, () -> this.connection.hScan(key, options));
    }

    public Long hStrLen(byte[] key, byte[] field) {
        return (Long)this.helper.doInScope("HSTRLEN", key, () -> this.connection.hStrLen(key, field));
    }

    public void multi() {
        this.helper.doInScope("MULTI", () -> this.connection.multi());
    }

    public List<Object> exec() {
        return (List)this.helper.doInScope("EXEC", () -> this.connection.exec());
    }

    public void discard() {
        this.helper.doInScope("DISCARD", () -> this.connection.discard());
    }

    public void watch(byte[] ... keys) {
        this.helper.doInScope("WATCH", () -> this.connection.watch(keys));
    }

    public void unwatch() {
        this.helper.doInScope("UNWATCH", () -> this.connection.unwatch());
    }

    public Long publish(byte[] channel, byte[] message) {
        return (Long)this.helper.doInScope("PUBLISH", () -> this.connection.publish(channel, message));
    }

    public void subscribe(MessageListener listener, byte[] ... channels) {
        this.helper.doInScope("SUBSCRIBE", () -> this.connection.subscribe(listener, channels));
    }

    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        this.helper.doInScope("PSUBSCRIBE", () -> this.connection.pSubscribe(listener, patterns));
    }

    public void select(int dbIndex) {
        this.helper.doInScope("SELECT", () -> this.connection.select(dbIndex));
    }

    public byte[] echo(byte[] message) {
        return (byte[])this.helper.doInScope("ECHO", () -> this.connection.echo(message));
    }

    public String ping() {
        return (String)this.helper.doInScope("PING", () -> this.connection.ping());
    }

    public void bgWriteAof() {
        this.helper.doInScope("BGWRITEAOF", () -> this.connection.bgWriteAof());
    }

    public void bgReWriteAof() {
        this.helper.doInScope("BGREWRITEAOF", () -> this.connection.bgReWriteAof());
    }

    public void bgSave() {
        this.helper.doInScope("BGSAVE", () -> this.connection.bgSave());
    }

    public Long lastSave() {
        return (Long)this.helper.doInScope("LASTSAVE", () -> this.connection.lastSave());
    }

    public void save() {
        this.helper.doInScope("SAVE", () -> this.connection.save());
    }

    public Long dbSize() {
        return (Long)this.helper.doInScope("DBSIZE", () -> this.connection.dbSize());
    }

    public void flushDb() {
        this.helper.doInScope("FLUSHDB", () -> this.connection.flushDb());
    }

    public void flushAll() {
        this.helper.doInScope("FLUSHALL", () -> this.connection.flushAll());
    }

    public Properties info() {
        return (Properties)this.helper.doInScope("INFO", () -> this.connection.info());
    }

    public Properties info(String section) {
        return (Properties)this.helper.doInScope("INFO", () -> this.connection.info(section));
    }

    public void shutdown() {
        this.helper.doInScope("SHUTDOWN", () -> this.connection.shutdown());
    }

    public void shutdown(RedisServerCommands.ShutdownOption option) {
        this.helper.doInScope("SHUTDOWN", () -> this.connection.shutdown(option));
    }

    public Properties getConfig(String pattern) {
        return (Properties)this.helper.doInScope("CONFIG GET", () -> this.connection.getConfig(pattern));
    }

    public void setConfig(String param, String value) {
        this.helper.doInScope("CONFIG SET", () -> this.connection.setConfig(param, value));
    }

    public void resetConfigStats() {
        this.helper.doInScope("CONFIG RESETSTAT", () -> this.connection.resetConfigStats());
    }

    public Long time() {
        return (Long)this.helper.doInScope("TIME", () -> this.connection.time());
    }

    public void killClient(String host, int port) {
        this.helper.doInScope("CLIENT KILL", () -> this.connection.killClient(host, port));
    }

    public void setClientName(byte[] name) {
        this.helper.doInScope("CLIENT SETNAME", () -> this.connection.setClientName(name));
    }

    public String getClientName() {
        return (String)this.helper.doInScope("CLIENT GETNAME", () -> this.connection.getClientName());
    }

    public List<RedisClientInfo> getClientList() {
        return (List)this.helper.doInScope("CLIENT LIST", () -> this.connection.getClientList());
    }

    public void slaveOf(String host, int port) {
        this.helper.doInScope("SLAVEOF", () -> this.connection.slaveOf(host, port));
    }

    public void slaveOfNoOne() {
        this.helper.doInScope("SLAVEOFNOONE", () -> this.connection.slaveOfNoOne());
    }

    public void migrate(byte[] key, RedisNode target, int dbIndex, RedisServerCommands.MigrateOption option) {
        this.helper.doInScope("MIGRATE", key, () -> this.connection.migrate(key, target, dbIndex, option));
    }

    public void migrate(byte[] key, RedisNode target, int dbIndex, RedisServerCommands.MigrateOption option, long timeout) {
        this.helper.doInScope("MIGRATE", key, () -> this.connection.migrate(key, target, dbIndex, option, timeout));
    }

    public void scriptFlush() {
        this.helper.doInScope("SCRIPT FLUSH", () -> this.connection.scriptFlush());
    }

    public void scriptKill() {
        this.helper.doInScope("SCRIPT KILL", () -> this.connection.scriptKill());
    }

    public String scriptLoad(byte[] script) {
        return (String)this.helper.doInScope("SCRIPT LOAD", () -> this.connection.scriptLoad(script));
    }

    public List<Boolean> scriptExists(String ... scriptShas) {
        return (List)this.helper.doInScope("SCRIPT EXISTS", () -> this.connection.scriptExists(scriptShas));
    }

    public <T> T eval(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        return (T)this.helper.doInScope("EVAL", () -> this.connection.eval(script, returnType, numKeys, keysAndArgs));
    }

    public <T> T evalSha(String scriptSha, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        return (T)this.helper.doInScope("EVALSHA", () -> this.connection.evalSha(scriptSha, returnType, numKeys, keysAndArgs));
    }

    public <T> T evalSha(byte[] scriptSha, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        return (T)this.helper.doInScope("EVALSHA", () -> this.connection.evalSha(scriptSha, returnType, numKeys, keysAndArgs));
    }

    public Long geoAdd(byte[] key, Point point, byte[] member) {
        return (Long)this.helper.doInScope("GEOADD", key, () -> this.connection.geoAdd(key, point, member));
    }

    public Long geoAdd(byte[] key, RedisGeoCommands.GeoLocation<byte[]> location) {
        return (Long)this.helper.doInScope("GEOADD", key, () -> this.connection.geoAdd(key, location));
    }

    public Long geoAdd(byte[] key, Map<byte[], Point> memberCoordinateMap) {
        return (Long)this.helper.doInScope("GEOADD", key, () -> this.connection.geoAdd(key, memberCoordinateMap));
    }

    public Long geoAdd(byte[] key, Iterable<RedisGeoCommands.GeoLocation<byte[]>> locations) {
        return (Long)this.helper.doInScope("GEOADD", key, () -> this.connection.geoAdd(key, locations));
    }

    public Distance geoDist(byte[] key, byte[] member1, byte[] member2) {
        return (Distance)this.helper.doInScope("GEODIST", key, () -> this.connection.geoDist(key, member1, member2));
    }

    public Distance geoDist(byte[] key, byte[] member1, byte[] member2, Metric metric) {
        return (Distance)this.helper.doInScope("GEODIST", key, () -> this.connection.geoDist(key, member1, member2, metric));
    }

    public List<String> geoHash(byte[] key, byte[] ... members) {
        return (List)this.helper.doInScope("GEOHASH", key, () -> this.connection.geoHash(key, members));
    }

    public List<Point> geoPos(byte[] key, byte[] ... members) {
        return (List)this.helper.doInScope("GEOPOS", key, () -> this.connection.geoPos(key, members));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within) {
        return (GeoResults)this.helper.doInScope("GEORADIUS", key, () -> this.connection.geoRadius(key, within));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return (GeoResults)this.helper.doInScope("GEORADIUS", key, () -> this.connection.geoRadius(key, within, args));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, double radius) {
        return (GeoResults)this.helper.doInScope("GEORADIUSBYMEMBER", key, () -> this.connection.geoRadiusByMember(key, member, radius));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius) {
        return (GeoResults)this.helper.doInScope("GEORADIUSBYMEMBER", key, () -> this.connection.geoRadiusByMember(key, member, radius));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return (GeoResults)this.helper.doInScope("GEORADIUSBYMEMBER", key, () -> this.connection.geoRadiusByMember(key, member, radius, args));
    }

    public Long geoRemove(byte[] key, byte[] ... members) {
        return (Long)this.helper.doInScope("GEOREMOVE", key, () -> this.connection.geoRemove(key, members));
    }

    public Long pfAdd(byte[] key, byte[] ... values) {
        return (Long)this.helper.doInScope("PFADD", key, () -> this.connection.pfAdd(key, values));
    }

    public Long pfCount(byte[] ... keys) {
        return (Long)this.helper.doInScope("PFCOUNT", keys, () -> this.connection.pfCount(keys));
    }

    public void pfMerge(byte[] destinationKey, byte[] ... sourceKeys) {
        this.helper.doInScope("PFMERGE", () -> this.connection.pfMerge(destinationKey, sourceKeys));
    }
}

