/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.spring.data2.connection;

import io.opentracing.contrib.redis.common.TracingConfiguration;
import io.opentracing.contrib.redis.spring.data2.connection.TracingReactiveRedisClusterConnection;
import io.opentracing.contrib.redis.spring.data2.connection.TracingReactiveRedisConnection;
import io.opentracing.contrib.redis.spring.data2.connection.TracingRedisClusterConnection;
import io.opentracing.contrib.redis.spring.data2.connection.TracingRedisConnection;
import io.opentracing.contrib.redis.spring.data2.connection.TracingRedisSentinelConnection;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.ReactiveRedisClusterConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConnection;

public class TracingRedisConnectionFactory
implements RedisConnectionFactory,
ReactiveRedisConnectionFactory {
    private final RedisConnectionFactory delegate;
    private final TracingConfiguration tracingConfiguration;

    public TracingRedisConnectionFactory(RedisConnectionFactory delegate, TracingConfiguration tracingConfiguration) {
        this.delegate = delegate;
        this.tracingConfiguration = tracingConfiguration;
    }

    public RedisConnection getConnection() {
        RedisConnection connection = this.delegate.getConnection();
        if (connection instanceof RedisClusterConnection) {
            return new TracingRedisClusterConnection((RedisClusterConnection)connection, this.tracingConfiguration);
        }
        return new TracingRedisConnection(connection, this.tracingConfiguration);
    }

    public RedisClusterConnection getClusterConnection() {
        return new TracingRedisClusterConnection(this.delegate.getClusterConnection(), this.tracingConfiguration);
    }

    public boolean getConvertPipelineAndTxResults() {
        return this.delegate.getConvertPipelineAndTxResults();
    }

    public RedisSentinelConnection getSentinelConnection() {
        return new TracingRedisSentinelConnection(this.delegate.getSentinelConnection(), this.tracingConfiguration);
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException e) {
        return this.delegate.translateExceptionIfPossible(e);
    }

    public ReactiveRedisConnection getReactiveConnection() {
        if (this.delegate instanceof ReactiveRedisConnectionFactory) {
            ReactiveRedisConnectionFactory connectionFactory = (ReactiveRedisConnectionFactory)this.delegate;
            ReactiveRedisConnection connection = connectionFactory.getReactiveConnection();
            if (connection instanceof ReactiveRedisClusterConnection) {
                return new TracingReactiveRedisClusterConnection((ReactiveRedisClusterConnection)connection, this.tracingConfiguration);
            }
            return new TracingReactiveRedisConnection(connectionFactory.getReactiveConnection(), this.tracingConfiguration);
        }
        return null;
    }

    public ReactiveRedisClusterConnection getReactiveClusterConnection() {
        if (this.delegate instanceof ReactiveRedisConnectionFactory) {
            return ((ReactiveRedisConnectionFactory)this.delegate).getReactiveClusterConnection();
        }
        return null;
    }
}

