/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.feign;

import feign.Client;
import feign.Request;
import feign.opentracing.FeignSpanDecorator;
import feign.opentracing.TracingClient;
import feign.opentracing.hystrix.TracingConcurrencyStrategy;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.cloud.feign.FeignContextBeanPostProcessor;
import io.opentracing.contrib.spring.cloud.feign.TracingClientBuilder;
import io.opentracing.contrib.spring.tracer.configuration.TracerAutoConfiguration;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ConditionalOnClass(value={Client.class})
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={TracerAutoConfiguration.class})
@AutoConfigureBefore(name={"org.springframework.cloud.openfeign.FeignAutoConfiguration"})
@ConditionalOnProperty(name={"opentracing.spring.cloud.feign.enabled"}, havingValue="true", matchIfMissing=true)
public class FeignTracingAutoConfiguration {
    @Autowired
    @Lazy
    private Tracer tracer;
    @Autowired(required=false)
    @Lazy
    private List<FeignSpanDecorator> spanDecorators;

    @Bean
    @ConditionalOnClass(name={"org.springframework.cloud.openfeign.FeignContext"})
    FeignContextBeanPostProcessor feignContextBeanPostProcessor(BeanFactory beanFactory) {
        return new FeignContextBeanPostProcessor(this.tracer, beanFactory, this.spanDecorators);
    }

    @Bean
    public TracingAspect tracingAspect() {
        return new TracingAspect();
    }

    @Aspect
    class TracingAspect {
        TracingAspect() {
        }

        @Around(value="execution (* feign.Client.*(..)) && !within(is(FinalType))")
        public Object feignClientWasCalled(ProceedingJoinPoint pjp) throws Throwable {
            Object bean = pjp.getTarget();
            if (!(bean instanceof TracingClient)) {
                Object[] args = pjp.getArgs();
                return new TracingClientBuilder((Client)bean, FeignTracingAutoConfiguration.this.tracer).withFeignSpanDecorators(FeignTracingAutoConfiguration.this.spanDecorators).build().execute((Request)args[0], (Request.Options)args[1]);
            }
            return pjp.proceed();
        }
    }

    @Configuration
    @ConditionalOnClass(name={"com.netflix.hystrix.HystrixCommand", "feign.hystrix.HystrixFeign"})
    @ConditionalOnProperty(name={"feign.hystrix.enabled"}, havingValue="true")
    public static class HystrixFeign {
        @Autowired
        public HystrixFeign(Tracer tracer) {
            TracingConcurrencyStrategy.register((Tracer)tracer);
        }
    }
}

