/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.jdbc;

import io.opentracing.contrib.common.WrapperProxy;
import io.opentracing.contrib.jdbc.ConnectionInfo;
import io.opentracing.contrib.jdbc.TracingConnection;
import io.opentracing.contrib.jdbc.parser.URLParser;
import io.opentracing.util.GlobalTracer;
import java.sql.Connection;
import java.util.Set;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class JdbcAspect {
    private final boolean withActiveSpanOnly;
    private final Set<String> ignoredStatements;

    public JdbcAspect(boolean withActiveSpanOnly, Set<String> ignoredStatements) {
        this.withActiveSpanOnly = withActiveSpanOnly;
        this.ignoredStatements = ignoredStatements;
    }

    @Around(value="execution(java.sql.Connection *.getConnection(..)) && target(javax.sql.DataSource)")
    public Object getConnection(ProceedingJoinPoint pjp) throws Throwable {
        Connection conn = (Connection)pjp.proceed();
        if (WrapperProxy.isWrapper((Object)conn, TracingConnection.class)) {
            return conn;
        }
        String url = conn.getMetaData().getURL();
        ConnectionInfo connectionInfo = URLParser.parser((String)url);
        return WrapperProxy.wrap((Object)conn, (Object)new TracingConnection(conn, connectionInfo, this.withActiveSpanOnly, this.ignoredStatements, GlobalTracer.get()));
    }
}

