/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.java.spring.jaeger.starter;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;

@ConfigurationProperties(value="opentracing.jaeger")
public class JaegerConfigurationProperties {
    private final RemoteReporter remoteReporter = new RemoteReporter();
    private final HttpSender httpSender = new HttpSender();
    private final UdpSender udpSender = new UdpSender();
    private final ConstSampler constSampler = new ConstSampler();
    private final ProbabilisticSampler probabilisticSampler = new ProbabilisticSampler();
    private final RateLimitingSampler rateLimitingSampler = new RateLimitingSampler();
    private final RemoteControlledSampler remoteControlledSampler = new RemoteControlledSampler();
    private boolean enabled = true;
    @Value(value="${jaeger.service-name:${spring.application.name:unknown-spring-boot}}")
    private String serviceName;
    private boolean logSpans = true;
    private boolean enableB3Propagation = false;
    private boolean enable128BitTraces = false;
    private boolean expandExceptionLogs = false;
    private Map<String, String> tags = new HashMap<String, String>();
    private boolean includeJaegerEnvTags = false;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public boolean isLogSpans() {
        return this.logSpans;
    }

    public void setLogSpans(boolean logSpans) {
        this.logSpans = logSpans;
    }

    public boolean isEnableB3Propagation() {
        return this.enableB3Propagation;
    }

    public void setEnableB3Propagation(boolean enableB3Propagation) {
        this.enableB3Propagation = enableB3Propagation;
    }

    public boolean isEnable128BitTraces() {
        return this.enable128BitTraces;
    }

    public void setEnable128BitTraces(boolean enable128BitTraces) {
        this.enable128BitTraces = enable128BitTraces;
    }

    public boolean isExpandExceptionLogs() {
        return this.expandExceptionLogs;
    }

    public void setExpandExceptionLogs(boolean expandExceptionLogs) {
        this.expandExceptionLogs = expandExceptionLogs;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Map<String, String> determineTags() {
        if (!this.includeJaegerEnvTags) {
            return this.tags;
        }
        HashMap<String, String> result = new HashMap<String, String>(this.tags);
        result.putAll(this.tracerTagsFromEnv());
        return result;
    }

    private Map<String, String> tracerTagsFromEnv() {
        HashMap<String, String> tracerTagMaps = new HashMap<String, String>();
        String tracerTags = this.getProperty("JAEGER_TAGS");
        if (tracerTags != null) {
            String[] tags;
            for (String tag : tags = tracerTags.split("\\s*,\\s*")) {
                String[] tagValue = tag.split("\\s*=\\s*");
                if (tagValue.length != 2) continue;
                tracerTagMaps.put(tagValue[0], tagValue[1]);
            }
        }
        return tracerTagMaps;
    }

    private String getProperty(String name) {
        return System.getProperty(name, System.getenv(name));
    }

    public boolean isIncludeJaegerEnvTags() {
        return this.includeJaegerEnvTags;
    }

    public void setIncludeJaegerEnvTags(boolean includeJaegerEnvTags) {
        this.includeJaegerEnvTags = includeJaegerEnvTags;
    }

    public HttpSender getHttpSender() {
        return this.httpSender;
    }

    public RemoteReporter getRemoteReporter() {
        return this.remoteReporter;
    }

    public UdpSender getUdpSender() {
        return this.udpSender;
    }

    public ConstSampler getConstSampler() {
        return this.constSampler;
    }

    public ProbabilisticSampler getProbabilisticSampler() {
        return this.probabilisticSampler;
    }

    public RateLimitingSampler getRateLimitingSampler() {
        return this.rateLimitingSampler;
    }

    public RemoteControlledSampler getRemoteControlledSampler() {
        return this.remoteControlledSampler;
    }

    public static class RemoteControlledSampler {
        private String hostPort;
        private String host;
        private int port = 5778;
        private Double samplingRate = 0.001;

        @DeprecatedConfigurationProperty(replacement="Use host + port properties instead")
        public String getHostPort() {
            return this.hostPort;
        }

        public void setHostPort(String hostPort) {
            this.hostPort = hostPort;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Double getSamplingRate() {
            return this.samplingRate;
        }

        public void setSamplingRate(Double samplingRate) {
            this.samplingRate = samplingRate;
        }
    }

    public static class RateLimitingSampler {
        private Double maxTracesPerSecond;

        public Double getMaxTracesPerSecond() {
            return this.maxTracesPerSecond;
        }

        public void setMaxTracesPerSecond(Double maxTracesPerSecond) {
            this.maxTracesPerSecond = maxTracesPerSecond;
        }
    }

    public static class ProbabilisticSampler {
        private Double samplingRate;

        public Double getSamplingRate() {
            return this.samplingRate;
        }

        public void setSamplingRate(Double samplingRate) {
            this.samplingRate = samplingRate;
        }
    }

    public static class ConstSampler {
        private Boolean decision;

        public Boolean getDecision() {
            return this.decision;
        }

        public void setDecision(Boolean decision) {
            this.decision = decision;
        }
    }

    public static class UdpSender {
        private String host = "localhost";
        private int port = 6831;
        private int maxPacketSize = 0;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public int getMaxPacketSize() {
            return this.maxPacketSize;
        }

        public void setMaxPacketSize(int maxPacketSize) {
            this.maxPacketSize = maxPacketSize;
        }
    }

    public static class HttpSender {
        private String url;
        private Integer maxPayload = 0;
        private String username;
        private String password;
        private String authToken;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Integer getMaxPayload() {
            return this.maxPayload;
        }

        public void setMaxPayload(Integer maxPayload) {
            this.maxPayload = maxPayload;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getAuthToken() {
            return this.authToken;
        }

        public void setAuthToken(String authToken) {
            this.authToken = authToken;
        }
    }

    public static class RemoteReporter {
        private Integer flushInterval;
        private Integer maxQueueSize;

        public Integer getFlushInterval() {
            return this.flushInterval;
        }

        public void setFlushInterval(Integer flushInterval) {
            this.flushInterval = flushInterval;
        }

        public Integer getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public void setMaxQueueSize(Integer maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
        }
    }
}

