/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.tool.xmlsectool;

import java.util.List;
import javax.annotation.Nonnull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SignatureHelper {
    private static final List<String> STRIP_CR_ELEMENTS = List.of("SignatureValue", "X509Certificate", "Modulus", "P", "Q", "G", "Y", "J");
    private static final List<String> ENSURE_NL_ELEMENTS = List.of("Modulus", "P", "G", "Y");

    private SignatureHelper() {
    }

    private static void removeCRsFromNamedChildren(@Nonnull Element signature, @Nonnull String elementName) {
        NodeList nodes = signature.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", elementName);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String text = node.getTextContent();
            if (text.indexOf(13) < 0) continue;
            node.setTextContent(text.replaceAll("\\r", ""));
        }
    }

    private static void ensureNLsWrapNamedChildren(@Nonnull Element signature, @Nonnull String elementName) {
        NodeList nodes = signature.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", elementName);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String text = node.getTextContent();
            String newText = "\n" + text.strip() + "\n";
            if (newText.equals(text)) continue;
            node.setTextContent(newText);
        }
    }

    public static void postProcessSignature(@Nonnull Element signatureElement) {
        for (String name : STRIP_CR_ELEMENTS) {
            SignatureHelper.removeCRsFromNamedChildren(signatureElement, name);
        }
        for (String name : ENSURE_NL_ELEMENTS) {
            SignatureHelper.ensureNLsWrapNamedChildren(signatureElement, name);
        }
    }
}

