/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.MultiBlockCipher;
import org.bouncycastle.util.Arrays;

public abstract class DefaultMultiBlockCipher
implements MultiBlockCipher {
    protected DefaultMultiBlockCipher() {
    }

    @Override
    public int getMultiBlockSize() {
        return this.getBlockSize();
    }

    @Override
    public int processBlocks(byte[] in, int inOff, int blockCount, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        int resultLen = 0;
        int blockSize = this.getMultiBlockSize();
        int len = blockCount * blockSize;
        if (in == out && Arrays.segmentsOverlap(inOff, len, outOff, len)) {
            in = new byte[len];
            System.arraycopy(out, inOff, in, 0, len);
            inOff = 0;
        }
        for (int i = 0; i != blockCount; ++i) {
            resultLen += this.processBlock(in, inOff, out, outOff + resultLen);
            inOff += blockSize;
        }
        return resultLen;
    }
}

