/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.Xof;
import org.bouncycastle.crypto.digests.AsconBaseDigest;

abstract class AsconXofBase
extends AsconBaseDigest
implements Xof {
    private boolean m_squeezing;
    private final byte[] buffer;
    private int bytesInBuffer;

    AsconXofBase() {
        this.buffer = new byte[this.BlockSize];
    }

    @Override
    public void update(byte in) {
        this.ensureNoAbsorbWhileSqueezing(this.m_squeezing);
        super.update(in);
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        this.ensureNoAbsorbWhileSqueezing(this.m_squeezing);
        super.update(input, inOff, len);
    }

    @Override
    public int doOutput(byte[] output, int outOff, int outLen) {
        int available;
        int bytesToOutput;
        this.ensureSufficientOutputBuffer(output, outOff, outLen);
        int bytesOutput = 0;
        if (this.bytesInBuffer != 0) {
            int startPos = this.BlockSize - this.bytesInBuffer;
            bytesToOutput = Math.min(outLen, this.bytesInBuffer);
            System.arraycopy(this.buffer, startPos, output, outOff, bytesToOutput);
            this.bytesInBuffer -= bytesToOutput;
            bytesOutput += bytesToOutput;
        }
        if ((available = outLen - bytesOutput) >= this.BlockSize) {
            bytesToOutput = available - available % this.BlockSize;
            bytesOutput += this.hash(output, outOff + bytesOutput, bytesToOutput);
        }
        if (bytesOutput < outLen) {
            this.hash(this.buffer, 0, this.BlockSize);
            bytesToOutput = outLen - bytesOutput;
            System.arraycopy(this.buffer, 0, output, outOff + bytesOutput, bytesToOutput);
            this.bytesInBuffer = this.buffer.length - bytesToOutput;
            bytesOutput += bytesToOutput;
        }
        return bytesOutput;
    }

    @Override
    public int doFinal(byte[] output, int outOff, int outLen) {
        int rlt = this.doOutput(output, outOff, outLen);
        this.reset();
        return rlt;
    }

    @Override
    public void reset() {
        this.m_squeezing = false;
        this.bytesInBuffer = 0;
        super.reset();
    }

    @Override
    protected void padAndAbsorb() {
        if (!this.m_squeezing) {
            this.m_squeezing = true;
            super.padAndAbsorb();
        } else {
            this.p.p(this.ASCON_PB_ROUNDS);
        }
    }

    private void ensureNoAbsorbWhileSqueezing(boolean m_squeezing) {
        if (m_squeezing) {
            throw new IllegalStateException("attempt to absorb while squeezing");
        }
    }
}

