/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.util.Arrays;

abstract class BufferBaseDigest
implements ExtendedDigest {
    protected int DigestSize;
    protected int BlockSize;
    protected byte[] m_buf;
    protected int m_bufPos;
    protected String algorithmName;
    protected ProcessingBuffer processor;

    protected BufferBaseDigest(ProcessingBufferType type, int BlockSize) {
        this.BlockSize = BlockSize;
        this.m_buf = new byte[BlockSize];
        switch (type.ord) {
            case 0: {
                this.processor = new BufferedProcessor();
                break;
            }
            case 1: {
                this.processor = new ImmediateProcessor();
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public int getDigestSize() {
        return this.DigestSize;
    }

    @Override
    public int getByteLength() {
        return this.BlockSize;
    }

    @Override
    public void update(byte in) {
        this.processor.update(in);
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        this.ensureSufficientInputBuffer(input, inOff, len);
        int available = this.BlockSize - this.m_bufPos;
        if (this.processor.isLengthWithinAvailableSpace(len, available)) {
            System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, len);
            this.m_bufPos += len;
            return;
        }
        if (this.m_bufPos > 0) {
            System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, available);
            inOff += available;
            len -= available;
            this.processBytes(this.m_buf, 0);
        }
        while (this.processor.isLengthExceedingBlockSize(len, this.BlockSize)) {
            this.processBytes(input, inOff);
            inOff += this.BlockSize;
            len -= this.BlockSize;
        }
        System.arraycopy(input, inOff, this.m_buf, 0, len);
        this.m_bufPos = len;
    }

    @Override
    public int doFinal(byte[] output, int outOff) {
        this.ensureSufficientOutputBuffer(output, outOff);
        this.finish(output, outOff);
        this.reset();
        return this.DigestSize;
    }

    @Override
    public void reset() {
        Arrays.clear(this.m_buf);
        this.m_bufPos = 0;
    }

    protected void ensureSufficientInputBuffer(byte[] input, int inOff, int len) {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
    }

    protected void ensureSufficientOutputBuffer(byte[] output, int outOff) {
        if (this.DigestSize + outOff > output.length) {
            throw new OutputLengthException("output buffer is too short");
        }
    }

    protected abstract void processBytes(byte[] var1, int var2);

    protected abstract void finish(byte[] var1, int var2);

    private class ImmediateProcessor
    implements ProcessingBuffer {
        private ImmediateProcessor() {
        }

        @Override
        public void update(byte input) {
            BufferBaseDigest.this.m_buf[BufferBaseDigest.this.m_bufPos] = input;
            if (++BufferBaseDigest.this.m_bufPos == BufferBaseDigest.this.BlockSize) {
                BufferBaseDigest.this.processBytes(BufferBaseDigest.this.m_buf, 0);
                BufferBaseDigest.this.m_bufPos = 0;
            }
        }

        @Override
        public boolean isLengthWithinAvailableSpace(int len, int available) {
            return len < available;
        }

        @Override
        public boolean isLengthExceedingBlockSize(int len, int size) {
            return len >= size;
        }
    }

    private class BufferedProcessor
    implements ProcessingBuffer {
        private BufferedProcessor() {
        }

        @Override
        public void update(byte input) {
            if (BufferBaseDigest.this.m_bufPos == BufferBaseDigest.this.BlockSize) {
                BufferBaseDigest.this.processBytes(BufferBaseDigest.this.m_buf, 0);
                BufferBaseDigest.this.m_bufPos = 0;
            }
            BufferBaseDigest.this.m_buf[BufferBaseDigest.this.m_bufPos++] = input;
        }

        @Override
        public boolean isLengthWithinAvailableSpace(int len, int available) {
            return len <= available;
        }

        @Override
        public boolean isLengthExceedingBlockSize(int len, int size) {
            return len > size;
        }
    }

    protected static interface ProcessingBuffer {
        public void update(byte var1);

        public boolean isLengthWithinAvailableSpace(int var1, int var2);

        public boolean isLengthExceedingBlockSize(int var1, int var2);
    }

    protected static class ProcessingBufferType {
        public static final int BUFFERED = 0;
        public static final int IMMEDIATE = 1;
        public static final ProcessingBufferType Buffered = new ProcessingBufferType(0);
        public static final ProcessingBufferType Immediate = new ProcessingBufferType(1);
        private final int ord;

        ProcessingBufferType(int ord) {
            this.ord = ord;
        }
    }
}

