/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.BufferBaseDigest;
import org.bouncycastle.crypto.engines.SparkleEngine;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Pack;

public class SparkleDigest
extends BufferBaseDigest {
    private static final int RATE_WORDS = 4;
    private final int[] state;
    private final int SPARKLE_STEPS_SLIM;
    private final int SPARKLE_STEPS_BIG;
    private final int STATE_WORDS;

    public SparkleDigest(SparkleParameters sparkleParameters) {
        super(BufferBaseDigest.ProcessingBufferType.Buffered, 16);
        switch (sparkleParameters) {
            case ESCH256: {
                this.algorithmName = "ESCH-256";
                this.DigestSize = 32;
                this.SPARKLE_STEPS_SLIM = 7;
                this.SPARKLE_STEPS_BIG = 11;
                this.STATE_WORDS = 12;
                break;
            }
            case ESCH384: {
                this.algorithmName = "ESCH-384";
                this.DigestSize = 48;
                this.SPARKLE_STEPS_SLIM = 8;
                this.SPARKLE_STEPS_BIG = 12;
                this.STATE_WORDS = 16;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid definition of SCHWAEMM instance");
            }
        }
        this.state = new int[this.STATE_WORDS];
    }

    @Override
    protected void processBytes(byte[] input, int inOff) {
        this.processBlock(input, inOff, this.SPARKLE_STEPS_SLIM);
    }

    @Override
    protected void finish(byte[] output, int outOff) {
        if (this.m_bufPos < this.BlockSize) {
            int n = (this.STATE_WORDS >> 1) - 1;
            this.state[n] = this.state[n] ^ 0x1000000;
            this.m_buf[this.m_bufPos++] = -128;
            Arrays.fill(this.m_buf, this.m_bufPos, this.BlockSize, (byte)0);
        } else {
            int n = (this.STATE_WORDS >> 1) - 1;
            this.state[n] = this.state[n] ^ 0x2000000;
        }
        this.processBlock(this.m_buf, 0, this.SPARKLE_STEPS_BIG);
        Pack.intToLittleEndian(this.state, 0, 4, output, outOff);
        if (this.STATE_WORDS == 16) {
            SparkleEngine.sparkle_opt16(Friend.INSTANCE, this.state, this.SPARKLE_STEPS_SLIM);
            Pack.intToLittleEndian(this.state, 0, 4, output, outOff + 16);
            SparkleEngine.sparkle_opt16(Friend.INSTANCE, this.state, this.SPARKLE_STEPS_SLIM);
            Pack.intToLittleEndian(this.state, 0, 4, output, outOff + 32);
        } else {
            SparkleEngine.sparkle_opt12(Friend.INSTANCE, this.state, this.SPARKLE_STEPS_SLIM);
            Pack.intToLittleEndian(this.state, 0, 4, output, outOff + 16);
        }
    }

    @Override
    public void reset() {
        super.reset();
        Arrays.fill(this.state, 0);
    }

    private void processBlock(byte[] buf, int off, int steps) {
        int t0 = Pack.littleEndianToInt(buf, off);
        int t1 = Pack.littleEndianToInt(buf, off + 4);
        int t2 = Pack.littleEndianToInt(buf, off + 8);
        int t3 = Pack.littleEndianToInt(buf, off + 12);
        int tx = SparkleDigest.ELL(t0 ^ t2);
        int ty = SparkleDigest.ELL(t1 ^ t3);
        this.state[0] = this.state[0] ^ (t0 ^ ty);
        this.state[1] = this.state[1] ^ (t1 ^ tx);
        this.state[2] = this.state[2] ^ (t2 ^ ty);
        this.state[3] = this.state[3] ^ (t3 ^ tx);
        this.state[4] = this.state[4] ^ ty;
        this.state[5] = this.state[5] ^ tx;
        if (this.STATE_WORDS == 16) {
            this.state[6] = this.state[6] ^ ty;
            this.state[7] = this.state[7] ^ tx;
            SparkleEngine.sparkle_opt16(Friend.INSTANCE, this.state, steps);
        } else {
            SparkleEngine.sparkle_opt12(Friend.INSTANCE, this.state, steps);
        }
    }

    private static int ELL(int x) {
        return Integers.rotateRight(x, 16) ^ x & 0xFFFF;
    }

    public static enum SparkleParameters {
        ESCH256,
        ESCH384;

    }

    public static class Friend {
        private static final Friend INSTANCE = new Friend();

        private Friend() {
        }
    }
}

