/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.engines.AEADBaseEngine;
import org.bouncycastle.crypto.engines.AsconBaseEngine;
import org.bouncycastle.util.Pack;

public class AsconEngine
extends AsconBaseEngine {
    private final AsconParameters asconParameters;
    private long K2;

    public AsconEngine(AsconParameters asconParameters) {
        this.asconParameters = asconParameters;
        this.MAC_SIZE = 16;
        this.IV_SIZE = 16;
        switch (asconParameters) {
            case ascon80pq: {
                this.KEY_SIZE = 20;
                this.BlockSize = 8;
                this.ASCON_IV = -6899501409222262784L;
                this.algorithmName = "Ascon-80pq AEAD";
                break;
            }
            case ascon128a: {
                this.KEY_SIZE = 16;
                this.BlockSize = 16;
                this.ASCON_IV = -9187330011336540160L;
                this.algorithmName = "Ascon-128a AEAD";
                break;
            }
            case ascon128: {
                this.KEY_SIZE = 16;
                this.BlockSize = 8;
                this.ASCON_IV = -9205344418435956736L;
                this.algorithmName = "Ascon-128 AEAD";
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid parameter setting for ASCON AEAD");
            }
        }
        this.nr = this.BlockSize == 8 ? 6 : 8;
        this.AADBufferSize = this.BlockSize;
        this.dsep = 1L;
        this.setInnerMembers(AEADBaseEngine.ProcessingBufferType.Immediate, AEADBaseEngine.AADOperatorType.Default, AEADBaseEngine.DataOperatorType.Default);
    }

    @Override
    protected long pad(int i) {
        return 128L << 56 - (i << 3);
    }

    @Override
    protected long loadBytes(byte[] in, int inOff) {
        return Pack.bigEndianToLong(in, inOff);
    }

    @Override
    protected void setBytes(long n, byte[] bs, int off) {
        Pack.longToBigEndian(n, bs, off);
    }

    @Override
    protected void ascon_aeadinit() {
        this.p.set(this.ASCON_IV, this.K1, this.K2, this.N0, this.N1);
        if (this.KEY_SIZE == 20) {
            this.p.x0 ^= this.K0;
        }
        this.p.p(12);
        if (this.KEY_SIZE == 20) {
            this.p.x2 ^= this.K0;
        }
        this.p.x3 ^= this.K1;
        this.p.x4 ^= this.K2;
    }

    @Override
    protected void processFinalAAD() {
        this.m_aad[this.m_aadPos] = -128;
        if (this.m_aadPos >= 8) {
            this.p.x0 ^= Pack.bigEndianToLong(this.m_aad, 0);
            this.p.x1 ^= Pack.bigEndianToLong(this.m_aad, 8) & -1L << 56 - (this.m_aadPos - 8 << 3);
        } else {
            this.p.x0 ^= Pack.bigEndianToLong(this.m_aad, 0) & -1L << 56 - (this.m_aadPos << 3);
        }
    }

    @Override
    protected void processFinalDecrypt(byte[] input, int inLen, byte[] output, int outOff) {
        if (inLen >= 8) {
            long c0 = Pack.bigEndianToLong(input, 0);
            this.p.x0 ^= c0;
            Pack.longToBigEndian(this.p.x0, output, outOff);
            this.p.x0 = c0;
            outOff += 8;
            this.p.x1 ^= this.pad(inLen -= 8);
            if (inLen != 0) {
                long c1 = Pack.littleEndianToLong_High(input, 8, inLen);
                this.p.x1 ^= c1;
                Pack.longToLittleEndian_High(this.p.x1, output, outOff, inLen);
                this.p.x1 &= -1L >>> (inLen << 3);
                this.p.x1 ^= c1;
            }
        } else {
            this.p.x0 ^= this.pad(inLen);
            if (inLen != 0) {
                long c0 = Pack.littleEndianToLong_High(input, 0, inLen);
                this.p.x0 ^= c0;
                Pack.longToLittleEndian_High(this.p.x0, output, outOff, inLen);
                this.p.x0 &= -1L >>> (inLen << 3);
                this.p.x0 ^= c0;
            }
        }
        this.finishData(AEADBaseEngine.State.DecFinal);
    }

    @Override
    protected void processFinalEncrypt(byte[] input, int inLen, byte[] output, int outOff) {
        if (inLen >= 8) {
            this.p.x0 ^= Pack.bigEndianToLong(input, 0);
            Pack.longToBigEndian(this.p.x0, output, outOff);
            outOff += 8;
            this.p.x1 ^= this.pad(inLen -= 8);
            if (inLen != 0) {
                this.p.x1 ^= Pack.littleEndianToLong_High(input, 8, inLen);
                Pack.longToLittleEndian_High(this.p.x1, output, outOff, inLen);
            }
        } else {
            this.p.x0 ^= this.pad(inLen);
            if (inLen != 0) {
                this.p.x0 ^= Pack.littleEndianToLong_High(input, 0, inLen);
                Pack.longToLittleEndian_High(this.p.x0, output, outOff, inLen);
            }
        }
        this.finishData(AEADBaseEngine.State.EncFinal);
    }

    protected void finishData(AEADBaseEngine.State nextState) {
        switch (this.asconParameters) {
            case ascon128: {
                this.p.x1 ^= this.K1;
                this.p.x2 ^= this.K2;
                break;
            }
            case ascon128a: {
                this.p.x2 ^= this.K1;
                this.p.x3 ^= this.K2;
                break;
            }
            case ascon80pq: {
                this.p.x1 ^= this.K0 << 32 | this.K1 >> 32;
                this.p.x2 ^= this.K1 << 32 | this.K2 >> 32;
                this.p.x3 ^= this.K2 << 32;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.p.p(12);
        this.p.x3 ^= this.K1;
        this.p.x4 ^= this.K2;
        this.m_state = nextState;
    }

    @Override
    protected void init(byte[] key, byte[] iv) throws IllegalArgumentException {
        this.N0 = Pack.bigEndianToLong(iv, 0);
        this.N1 = Pack.bigEndianToLong(iv, 8);
        if (this.KEY_SIZE == 16) {
            this.K1 = Pack.bigEndianToLong(key, 0);
            this.K2 = Pack.bigEndianToLong(key, 8);
        } else if (this.KEY_SIZE == 20) {
            this.K0 = Pack.bigEndianToInt(key, 0);
            this.K1 = Pack.bigEndianToLong(key, 4);
            this.K2 = Pack.bigEndianToLong(key, 12);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public String getAlgorithmVersion() {
        return "v1.2";
    }

    public static enum AsconParameters {
        ascon80pq,
        ascon128a,
        ascon128;

    }
}

