/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.engines.AEADBaseEngine;
import org.bouncycastle.util.Bytes;

public class GiftCofbEngine
extends AEADBaseEngine {
    private byte[] npub;
    private byte[] k;
    private byte[] Y;
    private byte[] input;
    private byte[] offset;
    private static final byte[] GIFT_RC = new byte[]{1, 3, 7, 15, 31, 62, 61, 59, 55, 47, 30, 60, 57, 51, 39, 14, 29, 58, 53, 43, 22, 44, 24, 48, 33, 2, 5, 11, 23, 46, 28, 56, 49, 35, 6, 13, 27, 54, 45, 26};

    public GiftCofbEngine() {
        this.KEY_SIZE = 16;
        this.IV_SIZE = 16;
        this.MAC_SIZE = 16;
        this.BlockSize = 16;
        this.AADBufferSize = 16;
        this.algorithmName = "GIFT-COFB AEAD";
        this.setInnerMembers(AEADBaseEngine.ProcessingBufferType.Buffered, AEADBaseEngine.AADOperatorType.Default, AEADBaseEngine.DataOperatorType.Counter);
    }

    private int rowperm(int S, int B0_pos, int B1_pos, int B2_pos, int B3_pos) {
        int T = 0;
        for (int b = 0; b < 8; ++b) {
            T |= (S >>> 4 * b & 1) << b + 8 * B0_pos;
            T |= (S >>> 4 * b + 1 & 1) << b + 8 * B1_pos;
            T |= (S >>> 4 * b + 2 & 1) << b + 8 * B2_pos;
            T |= (S >>> 4 * b + 3 & 1) << b + 8 * B3_pos;
        }
        return T;
    }

    private void giftb128(byte[] P, byte[] K, byte[] C) {
        int[] S = new int[4];
        short[] W = new short[8];
        S[0] = (P[0] & 0xFF) << 24 | (P[1] & 0xFF) << 16 | (P[2] & 0xFF) << 8 | P[3] & 0xFF;
        S[1] = (P[4] & 0xFF) << 24 | (P[5] & 0xFF) << 16 | (P[6] & 0xFF) << 8 | P[7] & 0xFF;
        S[2] = (P[8] & 0xFF) << 24 | (P[9] & 0xFF) << 16 | (P[10] & 0xFF) << 8 | P[11] & 0xFF;
        S[3] = (P[12] & 0xFF) << 24 | (P[13] & 0xFF) << 16 | (P[14] & 0xFF) << 8 | P[15] & 0xFF;
        W[0] = (short)((K[0] & 0xFF) << 8 | K[1] & 0xFF);
        W[1] = (short)((K[2] & 0xFF) << 8 | K[3] & 0xFF);
        W[2] = (short)((K[4] & 0xFF) << 8 | K[5] & 0xFF);
        W[3] = (short)((K[6] & 0xFF) << 8 | K[7] & 0xFF);
        W[4] = (short)((K[8] & 0xFF) << 8 | K[9] & 0xFF);
        W[5] = (short)((K[10] & 0xFF) << 8 | K[11] & 0xFF);
        W[6] = (short)((K[12] & 0xFF) << 8 | K[13] & 0xFF);
        W[7] = (short)((K[14] & 0xFF) << 8 | K[15] & 0xFF);
        for (int round = 0; round < 40; ++round) {
            S[1] = S[1] ^ S[0] & S[2];
            S[0] = S[0] ^ S[1] & S[3];
            S[2] = S[2] ^ (S[0] | S[1]);
            S[3] = S[3] ^ S[2];
            S[1] = S[1] ^ S[3];
            S[3] = ~S[3];
            S[2] = S[2] ^ S[0] & S[1];
            int T = S[0];
            S[0] = S[3];
            S[3] = T;
            S[0] = this.rowperm(S[0], 0, 3, 2, 1);
            S[1] = this.rowperm(S[1], 1, 0, 3, 2);
            S[2] = this.rowperm(S[2], 2, 1, 0, 3);
            S[3] = this.rowperm(S[3], 3, 2, 1, 0);
            S[2] = S[2] ^ ((W[2] & 0xFFFF) << 16 | W[3] & 0xFFFF);
            S[1] = S[1] ^ ((W[6] & 0xFFFF) << 16 | W[7] & 0xFFFF);
            S[3] = S[3] ^ (Integer.MIN_VALUE ^ GIFT_RC[round] & 0xFF);
            short T6 = (short)((W[6] & 0xFFFF) >>> 2 | (W[6] & 0xFFFF) << 14);
            short T7 = (short)((W[7] & 0xFFFF) >>> 12 | (W[7] & 0xFFFF) << 4);
            W[7] = W[5];
            W[6] = W[4];
            W[5] = W[3];
            W[4] = W[2];
            W[3] = W[1];
            W[2] = W[0];
            W[1] = T7;
            W[0] = T6;
        }
        C[0] = (byte)(S[0] >>> 24);
        C[1] = (byte)(S[0] >>> 16);
        C[2] = (byte)(S[0] >>> 8);
        C[3] = (byte)S[0];
        C[4] = (byte)(S[1] >>> 24);
        C[5] = (byte)(S[1] >>> 16);
        C[6] = (byte)(S[1] >>> 8);
        C[7] = (byte)S[1];
        C[8] = (byte)(S[2] >>> 24);
        C[9] = (byte)(S[2] >>> 16);
        C[10] = (byte)(S[2] >>> 8);
        C[11] = (byte)S[2];
        C[12] = (byte)(S[3] >>> 24);
        C[13] = (byte)(S[3] >>> 16);
        C[14] = (byte)(S[3] >>> 8);
        C[15] = (byte)S[3];
    }

    private void double_half_block(byte[] s) {
        int mask = ((s[0] & 0xFF) >>> 7) * 27;
        for (int i = 0; i < 7; ++i) {
            s[i] = (byte)((s[i] & 0xFF) << 1 | (s[i + 1] & 0xFF) >>> 7);
        }
        s[7] = (byte)((s[7] & 0xFF) << 1 ^ mask);
    }

    private void triple_half_block(byte[] s) {
        byte[] tmp = new byte[8];
        for (int i = 0; i < 7; ++i) {
            tmp[i] = (byte)((s[i] & 0xFF) << 1 | (s[i + 1] & 0xFF) >>> 7);
        }
        tmp[7] = (byte)((s[7] & 0xFF) << 1 ^ ((s[0] & 0xFF) >>> 7) * 27);
        Bytes.xorTo(8, tmp, s);
    }

    private void pho1(byte[] d, byte[] Y, byte[] M, int mOff, int no_of_bytes) {
        byte[] tmpM = new byte[16];
        byte[] tmp = new byte[16];
        if (no_of_bytes == 0) {
            tmpM[0] = -128;
        } else if (no_of_bytes < 16) {
            System.arraycopy(M, mOff, tmpM, 0, no_of_bytes);
            tmpM[no_of_bytes] = -128;
        } else {
            System.arraycopy(M, mOff, tmpM, 0, no_of_bytes);
        }
        System.arraycopy(Y, 8, tmp, 0, 8);
        for (int i = 0; i < 7; ++i) {
            tmp[i + 8] = (byte)((Y[i] & 0xFF) << 1 | (Y[i + 1] & 0xFF) >>> 7);
        }
        tmp[15] = (byte)((Y[7] & 0xFF) << 1 | (Y[0] & 0xFF) >>> 7);
        System.arraycopy(tmp, 0, Y, 0, 16);
        Bytes.xor(16, Y, tmpM, d);
    }

    @Override
    protected void processBufferAAD(byte[] in, int inOff) {
        this.pho1(this.input, this.Y, in, inOff, 16);
        this.double_half_block(this.offset);
        Bytes.xorTo(8, this.offset, this.input);
        this.giftb128(this.input, this.k, this.Y);
    }

    @Override
    protected void processFinalAAD() {
        int len = this.dataOperator.getLen() - (this.forEncryption ? 0 : this.MAC_SIZE);
        this.triple_half_block(this.offset);
        if ((this.m_aadPos & 0xF) != 0 || this.m_state == AEADBaseEngine.State.DecInit || this.m_state == AEADBaseEngine.State.EncInit) {
            this.triple_half_block(this.offset);
        }
        if (len == 0) {
            this.triple_half_block(this.offset);
            this.triple_half_block(this.offset);
        }
        this.pho1(this.input, this.Y, this.m_aad, 0, this.m_aadPos);
        Bytes.xorTo(8, this.offset, this.input);
        this.giftb128(this.input, this.k, this.Y);
    }

    @Override
    protected void finishAAD(AEADBaseEngine.State nextState, boolean isDoFinal) {
        this.finishAAD3(nextState, isDoFinal);
    }

    @Override
    protected void init(byte[] key, byte[] iv) {
        this.npub = iv;
        this.k = key;
        this.Y = new byte[this.BlockSize];
        this.input = new byte[16];
        this.offset = new byte[8];
    }

    @Override
    protected void processFinalBlock(byte[] output, int outOff) {
        int len = this.dataOperator.getLen() - (this.forEncryption ? 0 : this.MAC_SIZE);
        if (len != 0) {
            this.triple_half_block(this.offset);
            if ((len & 0xF) != 0) {
                this.triple_half_block(this.offset);
            }
            Bytes.xor(this.m_bufPos, this.Y, this.m_buf, 0, output, outOff);
            if (this.forEncryption) {
                this.pho1(this.input, this.Y, this.m_buf, 0, this.m_bufPos);
            } else {
                this.pho1(this.input, this.Y, output, outOff, this.m_bufPos);
            }
            Bytes.xorTo(8, this.offset, this.input);
            this.giftb128(this.input, this.k, this.Y);
        }
        System.arraycopy(this.Y, 0, this.mac, 0, this.BlockSize);
    }

    @Override
    protected void processBufferEncrypt(byte[] inputM, int inOff, byte[] output, int outOff) {
        this.double_half_block(this.offset);
        Bytes.xor(this.BlockSize, this.Y, inputM, inOff, output, outOff);
        this.pho1(this.input, this.Y, inputM, inOff, this.BlockSize);
        Bytes.xorTo(8, this.offset, this.input);
        this.giftb128(this.input, this.k, this.Y);
    }

    @Override
    protected void processBufferDecrypt(byte[] inputM, int inOff, byte[] output, int outOff) {
        this.double_half_block(this.offset);
        Bytes.xor(this.BlockSize, this.Y, inputM, inOff, output, outOff);
        this.pho1(this.input, this.Y, output, outOff, this.BlockSize);
        Bytes.xorTo(8, this.offset, this.input);
        this.giftb128(this.input, this.k, this.Y);
    }

    @Override
    protected void reset(boolean clearMac) {
        super.reset(clearMac);
        System.arraycopy(this.npub, 0, this.input, 0, this.IV_SIZE);
        this.giftb128(this.input, this.k, this.Y);
        System.arraycopy(this.Y, 0, this.offset, 0, 8);
    }
}

