/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.digests.XoodyakDigest;
import org.bouncycastle.crypto.engines.AEADBaseEngine;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Bytes;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Pack;

public class XoodyakEngine
extends AEADBaseEngine {
    private final byte[] state;
    private int phase;
    private int mode;
    private static final int f_bPrime_1 = 47;
    private byte[] K;
    private byte[] iv;
    private static final int PhaseUp = 2;
    private static final int PhaseDown = 1;
    private static final int[] RC = new int[]{88, 56, 960, 208, 288, 20, 96, 44, 896, 240, 416, 18};
    private boolean encrypted;
    private byte aadcd;
    private static final int ModeKeyed = 0;
    private static final int ModeHash = 1;

    public XoodyakEngine() {
        this.algorithmName = "Xoodyak AEAD";
        this.MAC_SIZE = 16;
        this.IV_SIZE = 16;
        this.KEY_SIZE = 16;
        this.BlockSize = 24;
        this.AADBufferSize = 44;
        this.state = new byte[48];
        this.setInnerMembers(AEADBaseEngine.ProcessingBufferType.Immediate, AEADBaseEngine.AADOperatorType.Default, AEADBaseEngine.DataOperatorType.Counter);
    }

    @Override
    protected void init(byte[] key, byte[] iv) throws IllegalArgumentException {
        this.K = key;
        this.iv = iv;
    }

    @Override
    protected void processBufferAAD(byte[] input, int inOff) {
        this.AbsorbAny(input, inOff, this.AADBufferSize, this.aadcd);
        this.aadcd = 0;
    }

    @Override
    protected void processFinalAAD() {
        this.AbsorbAny(this.m_aad, 0, this.m_aadPos, this.aadcd);
    }

    @Override
    protected void finishAAD(AEADBaseEngine.State nextState, boolean isDoFinal) {
        this.finishAAD3(nextState, isDoFinal);
    }

    @Override
    protected void processBufferEncrypt(byte[] input, int inOff, byte[] output, int outOff) {
        XoodyakEngine.up(this.mode, this.state, this.encrypted ? 0 : 128);
        Bytes.xor(this.BlockSize, this.state, input, inOff, output, outOff);
        XoodyakEngine.down(this.mode, this.state, input, inOff, this.BlockSize, 0);
        this.phase = 1;
        this.encrypted = true;
    }

    @Override
    protected void processBufferDecrypt(byte[] input, int inOff, byte[] output, int outOff) {
        XoodyakEngine.up(this.mode, this.state, this.encrypted ? 0 : 128);
        Bytes.xor(this.BlockSize, this.state, input, inOff, output, outOff);
        XoodyakEngine.down(this.mode, this.state, output, outOff, this.BlockSize, 0);
        this.phase = 1;
        this.encrypted = true;
    }

    @Override
    protected void processFinalBlock(byte[] output, int outOff) {
        if (this.m_bufPos != 0 || !this.encrypted) {
            XoodyakEngine.up(this.mode, this.state, this.encrypted ? 0 : 128);
            Bytes.xor(this.m_bufPos, this.state, this.m_buf, 0, output, outOff);
            if (this.forEncryption) {
                XoodyakEngine.down(this.mode, this.state, this.m_buf, 0, this.m_bufPos, 0);
            } else {
                XoodyakEngine.down(this.mode, this.state, output, outOff, this.m_bufPos, 0);
            }
            this.phase = 1;
        }
        XoodyakEngine.up(this.mode, this.state, 64);
        System.arraycopy(this.state, 0, this.mac, 0, this.MAC_SIZE);
        this.phase = 2;
    }

    @Override
    protected void reset(boolean clearMac) {
        super.reset(clearMac);
        Arrays.fill(this.state, (byte)0);
        this.encrypted = false;
        this.phase = 2;
        this.aadcd = (byte)3;
        int KLen = this.K.length;
        int IDLen = this.iv.length;
        byte[] KID = new byte[this.AADBufferSize];
        this.mode = 0;
        System.arraycopy(this.K, 0, KID, 0, KLen);
        System.arraycopy(this.iv, 0, KID, KLen, IDLen);
        KID[KLen + IDLen] = (byte)IDLen;
        this.AbsorbAny(KID, 0, KLen + IDLen + 1, 2);
    }

    private void AbsorbAny(byte[] X, int Xoff, int XLen, int Cd) {
        int splitLen;
        if (this.phase != 2) {
            XoodyakEngine.up(this.mode, this.state, 0);
        }
        do {
            splitLen = Math.min(XLen, this.AADBufferSize);
            XoodyakEngine.down(this.mode, this.state, X, Xoff, splitLen, Cd);
            this.phase = 1;
            Cd = 0;
            Xoff += splitLen;
        } while ((XLen -= splitLen) != 0);
    }

    public static void up(XoodyakDigest.Friend friend, int mode, byte[] state, int Cu) {
        if (null == friend) {
            throw new NullPointerException("This method is only for use by XoodyakDigest");
        }
        XoodyakEngine.up(mode, state, Cu);
    }

    private static void up(int mode, byte[] state, int Cu) {
        if (mode != 1) {
            state[47] = (byte)(state[47] ^ Cu);
        }
        int a0 = Pack.littleEndianToInt(state, 0);
        int a1 = Pack.littleEndianToInt(state, 4);
        int a2 = Pack.littleEndianToInt(state, 8);
        int a3 = Pack.littleEndianToInt(state, 12);
        int a4 = Pack.littleEndianToInt(state, 16);
        int a5 = Pack.littleEndianToInt(state, 20);
        int a6 = Pack.littleEndianToInt(state, 24);
        int a7 = Pack.littleEndianToInt(state, 28);
        int a8 = Pack.littleEndianToInt(state, 32);
        int a9 = Pack.littleEndianToInt(state, 36);
        int a10 = Pack.littleEndianToInt(state, 40);
        int a11 = Pack.littleEndianToInt(state, 44);
        for (int i = 0; i < 12; ++i) {
            int p0 = a0 ^ a4 ^ a8;
            int p1 = a1 ^ a5 ^ a9;
            int p2 = a2 ^ a6 ^ a10;
            int p3 = a3 ^ a7 ^ a11;
            int e0 = Integers.rotateLeft(p3, 5) ^ Integers.rotateLeft(p3, 14);
            int e1 = Integers.rotateLeft(p0, 5) ^ Integers.rotateLeft(p0, 14);
            int e2 = Integers.rotateLeft(p1, 5) ^ Integers.rotateLeft(p1, 14);
            int e3 = Integers.rotateLeft(p2, 5) ^ Integers.rotateLeft(p2, 14);
            a0 ^= e0;
            a4 ^= e0;
            a8 ^= e0;
            a1 ^= e1;
            a5 ^= e1;
            a9 ^= e1;
            a2 ^= e2;
            a6 ^= e2;
            a10 ^= e2;
            a3 ^= e3;
            a7 ^= e3;
            a11 ^= e3;
            int b0 = a0;
            int b1 = a1;
            int b2 = a2;
            int b3 = a3;
            int b4 = a7;
            int b5 = a4;
            int b6 = a5;
            int b7 = a6;
            int b8 = Integers.rotateLeft(a8, 11);
            int b9 = Integers.rotateLeft(a9, 11);
            int b10 = Integers.rotateLeft(a10, 11);
            int b11 = Integers.rotateLeft(a11, 11);
            a0 = (b0 ^= RC[i]) ^ ~b4 & b8;
            a1 = b1 ^ ~b5 & b9;
            a2 = b2 ^ ~b6 & b10;
            a3 = b3 ^ ~b7 & b11;
            a4 = b4 ^ ~b8 & b0;
            a5 = b5 ^ ~b9 & b1;
            a6 = b6 ^ ~b10 & b2;
            a7 = b7 ^ ~b11 & b3;
            b8 ^= ~b0 & b4;
            b9 ^= ~b1 & b5;
            b10 ^= ~b2 & b6;
            b11 ^= ~b3 & b7;
            a4 = Integers.rotateLeft(a4, 1);
            a5 = Integers.rotateLeft(a5, 1);
            a6 = Integers.rotateLeft(a6, 1);
            a7 = Integers.rotateLeft(a7, 1);
            a8 = Integers.rotateLeft(b10, 8);
            a9 = Integers.rotateLeft(b11, 8);
            a10 = Integers.rotateLeft(b8, 8);
            a11 = Integers.rotateLeft(b9, 8);
        }
        Pack.intToLittleEndian(a0, state, 0);
        Pack.intToLittleEndian(a1, state, 4);
        Pack.intToLittleEndian(a2, state, 8);
        Pack.intToLittleEndian(a3, state, 12);
        Pack.intToLittleEndian(a4, state, 16);
        Pack.intToLittleEndian(a5, state, 20);
        Pack.intToLittleEndian(a6, state, 24);
        Pack.intToLittleEndian(a7, state, 28);
        Pack.intToLittleEndian(a8, state, 32);
        Pack.intToLittleEndian(a9, state, 36);
        Pack.intToLittleEndian(a10, state, 40);
        Pack.intToLittleEndian(a11, state, 44);
    }

    public static void down(XoodyakDigest.Friend friend, int mode, byte[] state, byte[] Xi, int XiOff, int XiLen, int Cd) {
        if (null == friend) {
            throw new NullPointerException("This method is only for use by XoodyakDigest");
        }
        XoodyakEngine.down(mode, state, Xi, XiOff, XiLen, Cd);
    }

    private static void down(int mode, byte[] state, byte[] Xi, int XiOff, int XiLen, int Cd) {
        Bytes.xorTo(XiLen, Xi, XiOff, state);
        int n = XiLen;
        state[n] = (byte)(state[n] ^ 1);
        state[47] = (byte)(state[47] ^ (mode == 1 ? Cd & 1 : Cd));
    }
}

