/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.hpke;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.RawAgreement;
import org.bouncycastle.crypto.agreement.BasicRawAgreement;
import org.bouncycastle.crypto.agreement.ECDHCBasicAgreement;
import org.bouncycastle.crypto.agreement.X25519Agreement;
import org.bouncycastle.crypto.agreement.X448Agreement;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import org.bouncycastle.crypto.generators.X448KeyPairGenerator;
import org.bouncycastle.crypto.hpke.HKDF;
import org.bouncycastle.crypto.hpke.KEM;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.crypto.params.X448KeyGenerationParameters;
import org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import org.bouncycastle.crypto.params.X448PublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.math.ec.WNafUtil;
import org.bouncycastle.math.ec.rfc7748.X25519;
import org.bouncycastle.math.ec.rfc7748.X448;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;

class DHKEM
extends KEM {
    private AsymmetricCipherKeyPairGenerator kpGen;
    private RawAgreement rawAgreement;
    private final short kemId;
    private HKDF hkdf;
    private byte bitmask;
    private int Nsk;
    private int Nsecret;
    private int Nenc;
    ECDomainParameters domainParams;

    protected DHKEM(short kemid) {
        this.kemId = kemid;
        switch (kemid) {
            case 16: {
                this.hkdf = new HKDF(1);
                this.domainParams = DHKEM.getDomainParameters("P-256");
                this.rawAgreement = new BasicRawAgreement(new ECDHCBasicAgreement());
                this.bitmask = (byte)-1;
                this.Nsk = 32;
                this.Nsecret = 32;
                this.Nenc = 65;
                this.kpGen = new ECKeyPairGenerator();
                this.kpGen.init(new ECKeyGenerationParameters(this.domainParams, DHKEM.getSecureRandom()));
                break;
            }
            case 17: {
                this.hkdf = new HKDF(2);
                this.domainParams = DHKEM.getDomainParameters("P-384");
                this.rawAgreement = new BasicRawAgreement(new ECDHCBasicAgreement());
                this.bitmask = (byte)-1;
                this.Nsk = 48;
                this.Nsecret = 48;
                this.Nenc = 97;
                this.kpGen = new ECKeyPairGenerator();
                this.kpGen.init(new ECKeyGenerationParameters(this.domainParams, DHKEM.getSecureRandom()));
                break;
            }
            case 18: {
                this.hkdf = new HKDF(3);
                this.domainParams = DHKEM.getDomainParameters("P-521");
                this.rawAgreement = new BasicRawAgreement(new ECDHCBasicAgreement());
                this.bitmask = 1;
                this.Nsk = 66;
                this.Nsecret = 64;
                this.Nenc = 133;
                this.kpGen = new ECKeyPairGenerator();
                this.kpGen.init(new ECKeyGenerationParameters(this.domainParams, DHKEM.getSecureRandom()));
                break;
            }
            case 32: {
                this.hkdf = new HKDF(1);
                this.rawAgreement = new X25519Agreement();
                this.Nsecret = 32;
                this.Nsk = 32;
                this.Nenc = 32;
                this.kpGen = new X25519KeyPairGenerator();
                this.kpGen.init(new X25519KeyGenerationParameters(DHKEM.getSecureRandom()));
                break;
            }
            case 33: {
                this.hkdf = new HKDF(3);
                this.rawAgreement = new X448Agreement();
                this.Nsecret = 64;
                this.Nsk = 56;
                this.Nenc = 56;
                this.kpGen = new X448KeyPairGenerator();
                this.kpGen.init(new X448KeyGenerationParameters(DHKEM.getSecureRandom()));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid kem id");
            }
        }
    }

    @Override
    public byte[] SerializePublicKey(AsymmetricKeyParameter key) {
        switch (this.kemId) {
            case 16: 
            case 17: 
            case 18: {
                return ((ECPublicKeyParameters)key).getQ().getEncoded(false);
            }
            case 33: {
                return ((X448PublicKeyParameters)key).getEncoded();
            }
            case 32: {
                return ((X25519PublicKeyParameters)key).getEncoded();
            }
        }
        throw new IllegalStateException("invalid kem id");
    }

    @Override
    public byte[] SerializePrivateKey(AsymmetricKeyParameter key) {
        switch (this.kemId) {
            case 16: 
            case 17: 
            case 18: {
                return BigIntegers.asUnsignedByteArray(this.Nsk, ((ECPrivateKeyParameters)key).getD());
            }
            case 33: {
                byte[] encoded = ((X448PrivateKeyParameters)key).getEncoded();
                X448.clampPrivateKey(encoded);
                return encoded;
            }
            case 32: {
                byte[] encoded = ((X25519PrivateKeyParameters)key).getEncoded();
                X25519.clampPrivateKey(encoded);
                return encoded;
            }
        }
        throw new IllegalStateException("invalid kem id");
    }

    @Override
    public AsymmetricKeyParameter DeserializePublicKey(byte[] pkEncoded) {
        if (pkEncoded == null) {
            throw new NullPointerException("'pkEncoded' cannot be null");
        }
        if (pkEncoded.length != this.Nenc) {
            throw new IllegalArgumentException("'pkEncoded' has invalid length");
        }
        switch (this.kemId) {
            case 16: 
            case 17: 
            case 18: {
                if (pkEncoded[0] != 4) {
                    throw new IllegalArgumentException("'pkEncoded' has invalid format");
                }
                ECPoint G = this.domainParams.getCurve().decodePoint(pkEncoded);
                return new ECPublicKeyParameters(G, this.domainParams);
            }
            case 33: {
                return new X448PublicKeyParameters(pkEncoded);
            }
            case 32: {
                return new X25519PublicKeyParameters(pkEncoded);
            }
        }
        throw new IllegalStateException("invalid kem id");
    }

    @Override
    public AsymmetricCipherKeyPair DeserializePrivateKey(byte[] skEncoded, byte[] pkEncoded) {
        if (skEncoded == null) {
            throw new NullPointerException("'skEncoded' cannot be null");
        }
        if (skEncoded.length != this.Nsk) {
            throw new IllegalArgumentException("'skEncoded' has invalid length");
        }
        AsymmetricKeyParameter pubParam = null;
        if (pkEncoded != null) {
            pubParam = this.DeserializePublicKey(pkEncoded);
        }
        switch (this.kemId) {
            case 16: 
            case 17: 
            case 18: {
                BigInteger d = new BigInteger(1, skEncoded);
                ECPrivateKeyParameters ec = new ECPrivateKeyParameters(d, this.domainParams);
                if (pubParam == null) {
                    ECPoint Q = new FixedPointCombMultiplier().multiply(this.domainParams.getG(), ec.getD());
                    pubParam = new ECPublicKeyParameters(Q, this.domainParams);
                }
                return new AsymmetricCipherKeyPair(pubParam, ec);
            }
            case 33: {
                X448PrivateKeyParameters x448 = new X448PrivateKeyParameters(skEncoded);
                if (pubParam == null) {
                    pubParam = x448.generatePublicKey();
                }
                return new AsymmetricCipherKeyPair(pubParam, x448);
            }
            case 32: {
                X25519PrivateKeyParameters x25519 = new X25519PrivateKeyParameters(skEncoded);
                if (pubParam == null) {
                    pubParam = x25519.generatePublicKey();
                }
                return new AsymmetricCipherKeyPair(pubParam, x25519);
            }
        }
        throw new IllegalStateException("invalid kem id");
    }

    @Override
    int getEncryptionSize() {
        return this.Nenc;
    }

    private boolean validateSk(BigInteger d) {
        BigInteger n = this.domainParams.getN();
        int nBitLength = n.bitLength();
        int minWeight = nBitLength >>> 2;
        if (d.compareTo(BigInteger.valueOf(1L)) < 0 || d.compareTo(n) >= 0) {
            return false;
        }
        return WNafUtil.getNafWeight(d) >= minWeight;
    }

    @Override
    public AsymmetricCipherKeyPair GeneratePrivateKey() {
        return this.kpGen.generateKeyPair();
    }

    @Override
    public AsymmetricCipherKeyPair DeriveKeyPair(byte[] ikm) {
        byte[] suiteID = Arrays.concatenate(Strings.toByteArray("KEM"), Pack.shortToBigEndian(this.kemId));
        switch (this.kemId) {
            case 16: 
            case 17: 
            case 18: {
                byte[] dkp_prk = this.hkdf.LabeledExtract(null, suiteID, "dkp_prk", ikm);
                byte[] counterArray = new byte[1];
                for (int counter = 0; counter < 256; ++counter) {
                    counterArray[0] = (byte)counter;
                    byte[] bytes = this.hkdf.LabeledExpand(dkp_prk, suiteID, "candidate", counterArray, this.Nsk);
                    bytes[0] = (byte)(bytes[0] & this.bitmask);
                    BigInteger d = new BigInteger(1, bytes);
                    if (!this.validateSk(d)) continue;
                    ECPoint Q = new FixedPointCombMultiplier().multiply(this.domainParams.getG(), d);
                    ECPrivateKeyParameters sk = new ECPrivateKeyParameters(d, this.domainParams);
                    ECPublicKeyParameters pk = new ECPublicKeyParameters(Q, this.domainParams);
                    return new AsymmetricCipherKeyPair(pk, sk);
                }
                throw new IllegalStateException("DeriveKeyPairError");
            }
            case 33: {
                byte[] dkp_prk = this.hkdf.LabeledExtract(null, suiteID, "dkp_prk", ikm);
                byte[] x448sk = this.hkdf.LabeledExpand(dkp_prk, suiteID, "sk", null, this.Nsk);
                X448PrivateKeyParameters x448params = new X448PrivateKeyParameters(x448sk);
                return new AsymmetricCipherKeyPair(x448params.generatePublicKey(), x448params);
            }
            case 32: {
                byte[] dkp_prk = this.hkdf.LabeledExtract(null, suiteID, "dkp_prk", ikm);
                byte[] skBytes = this.hkdf.LabeledExpand(dkp_prk, suiteID, "sk", null, this.Nsk);
                X25519PrivateKeyParameters sk = new X25519PrivateKeyParameters(skBytes);
                return new AsymmetricCipherKeyPair(sk.generatePublicKey(), sk);
            }
        }
        throw new IllegalStateException("invalid kem id");
    }

    @Override
    protected byte[][] Encap(AsymmetricKeyParameter pkR) {
        return this.Encap(pkR, this.kpGen.generateKeyPair());
    }

    @Override
    protected byte[][] Encap(AsymmetricKeyParameter pkR, AsymmetricCipherKeyPair kpE) {
        byte[][] output = new byte[2][];
        byte[] secret = DHKEM.calculateRawAgreement(this.rawAgreement, kpE.getPrivate(), pkR);
        byte[] enc = this.SerializePublicKey(kpE.getPublic());
        byte[] pkRm = this.SerializePublicKey(pkR);
        byte[] KEMContext = Arrays.concatenate(enc, pkRm);
        byte[] sharedSecret = this.ExtractAndExpand(secret, KEMContext);
        output[0] = sharedSecret;
        output[1] = enc;
        return output;
    }

    @Override
    protected byte[] Decap(byte[] enc, AsymmetricCipherKeyPair kpR) {
        AsymmetricKeyParameter pkE = this.DeserializePublicKey(enc);
        byte[] secret = DHKEM.calculateRawAgreement(this.rawAgreement, kpR.getPrivate(), pkE);
        byte[] pkRm = this.SerializePublicKey(kpR.getPublic());
        byte[] KEMContext = Arrays.concatenate(enc, pkRm);
        return this.ExtractAndExpand(secret, KEMContext);
    }

    @Override
    protected byte[][] AuthEncap(AsymmetricKeyParameter pkR, AsymmetricCipherKeyPair kpS) {
        byte[][] output = new byte[2][];
        AsymmetricCipherKeyPair kpE = this.kpGen.generateKeyPair();
        this.rawAgreement.init(kpE.getPrivate());
        int agreementSize = this.rawAgreement.getAgreementSize();
        byte[] secret = new byte[agreementSize * 2];
        this.rawAgreement.calculateAgreement(pkR, secret, 0);
        this.rawAgreement.init(kpS.getPrivate());
        if (agreementSize != this.rawAgreement.getAgreementSize()) {
            throw new IllegalStateException();
        }
        this.rawAgreement.calculateAgreement(pkR, secret, agreementSize);
        byte[] enc = this.SerializePublicKey(kpE.getPublic());
        byte[] pkRm = this.SerializePublicKey(pkR);
        byte[] pkSm = this.SerializePublicKey(kpS.getPublic());
        byte[] KEMContext = Arrays.concatenate(enc, pkRm, pkSm);
        byte[] sharedSecret = this.ExtractAndExpand(secret, KEMContext);
        output[0] = sharedSecret;
        output[1] = enc;
        return output;
    }

    @Override
    protected byte[] AuthDecap(byte[] enc, AsymmetricCipherKeyPair kpR, AsymmetricKeyParameter pkS) {
        AsymmetricKeyParameter pkE = this.DeserializePublicKey(enc);
        this.rawAgreement.init(kpR.getPrivate());
        int agreementSize = this.rawAgreement.getAgreementSize();
        byte[] secret = new byte[agreementSize * 2];
        this.rawAgreement.calculateAgreement(pkE, secret, 0);
        this.rawAgreement.calculateAgreement(pkS, secret, agreementSize);
        byte[] pkRm = this.SerializePublicKey(kpR.getPublic());
        byte[] pkSm = this.SerializePublicKey(pkS);
        byte[] KEMContext = Arrays.concatenate(enc, pkRm, pkSm);
        return this.ExtractAndExpand(secret, KEMContext);
    }

    private byte[] ExtractAndExpand(byte[] dh, byte[] kemContext) {
        byte[] suiteID = Arrays.concatenate(Strings.toByteArray("KEM"), Pack.shortToBigEndian(this.kemId));
        byte[] eae_prk = this.hkdf.LabeledExtract(null, suiteID, "eae_prk", dh);
        return this.hkdf.LabeledExpand(eae_prk, suiteID, "shared_secret", kemContext, this.Nsecret);
    }

    private static byte[] calculateRawAgreement(RawAgreement rawAgreement, AsymmetricKeyParameter privateKey, AsymmetricKeyParameter publicKey) {
        rawAgreement.init(privateKey);
        byte[] z = new byte[rawAgreement.getAgreementSize()];
        rawAgreement.calculateAgreement(publicKey, z, 0);
        return z;
    }

    private static ECDomainParameters getDomainParameters(String curveName) {
        return new ECDomainParameters(CustomNamedCurves.getByName(curveName));
    }

    private static SecureRandom getSecureRandom() {
        return CryptoServicesRegistrar.getSecureRandom();
    }
}

