/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.parsers;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.crypto.KeyParser;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.io.Streams;

public class ECIESPublicKeyParser
implements KeyParser {
    private ECDomainParameters ecParams;

    public ECIESPublicKeyParser(ECDomainParameters ecParams) {
        this.ecParams = ecParams;
    }

    @Override
    public AsymmetricKeyParameter readKey(InputStream stream) throws IOException {
        boolean compressed;
        int first = stream.read();
        if (first < 0) {
            throw new EOFException();
        }
        switch (first) {
            case 0: {
                throw new IOException("Sender's public key invalid.");
            }
            case 2: 
            case 3: {
                compressed = true;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                compressed = false;
                break;
            }
            default: {
                throw new IOException("Sender's public key has invalid point encoding 0x" + Integer.toString(first, 16));
            }
        }
        ECCurve curve = this.ecParams.getCurve();
        int encodingLength = curve.getAffinePointEncodingLength(compressed);
        byte[] V = new byte[encodingLength];
        V[0] = (byte)first;
        int readLength = encodingLength - 1;
        if (Streams.readFully(stream, V, 1, readLength) != readLength) {
            throw new EOFException();
        }
        return new ECPublicKeyParameters(curve.decodePoint(V), this.ecParams);
    }
}

